/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.Assumption;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.methods.SharedMethodInfo;

public final class ConstantEntry {
    private final Assumption assumption;
    private final RubyConstant constant;

    public ConstantEntry(RubyConstant constant) {
        this.assumption = Assumption.create((String)"constant is not overridden:");
        this.constant = constant;
    }

    public ConstantEntry() {
        this.assumption = Assumption.create((String)"constant is not defined:");
        this.constant = null;
    }

    public ConstantEntry withNewAssumption() {
        if (this.constant != null) {
            return new ConstantEntry(this.constant);
        }
        return new ConstantEntry();
    }

    public Assumption getAssumption() {
        return this.assumption;
    }

    public RubyConstant getConstant() {
        return this.constant;
    }

    public void invalidate(String reason, RubyModule module, String constantName) {
        this.assumption.invalidate(reason + ": " + SharedMethodInfo.moduleAndConstantName(module, constantName));
    }
}

