/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.backtrace;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.ArrayList;
import java.util.List;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.exception.GetBacktraceException;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.thread.RubyBacktraceLocation;
import org.truffleruby.language.CallStackManager;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.AllocationTracing;

public final class Backtrace {
    private final Node location;
    private final int omitted;
    private RaiseException raiseException;
    private final Throwable javaThrowable;
    private TruffleStackTraceElement[] stackTrace;
    private int totalUnderlyingElements;
    public static final TruffleStackTraceElement[] EMPTY_STACK_TRACE_ELEMENTS_ARRAY = new TruffleStackTraceElement[0];

    public Backtrace(Node location, int omitted, Throwable javaThrowable) {
        this.location = location;
        this.omitted = omitted;
        this.javaThrowable = javaThrowable;
    }

    public Backtrace(Node location, int omitted, TruffleStackTraceElement[] stackTraceElements) {
        this.location = location;
        this.omitted = omitted;
        this.javaThrowable = null;
        this.stackTrace = stackTraceElements;
    }

    public Backtrace(AbstractTruffleException exception) {
        assert (!(exception instanceof RaiseException));
        this.location = exception.getLocation();
        this.omitted = 0;
        this.javaThrowable = null;
        this.stackTrace = this.getStackTrace(exception);
    }

    public Backtrace(Throwable exception) {
        this.location = null;
        this.omitted = 0;
        this.javaThrowable = null;
        this.stackTrace = this.getStackTrace(exception);
    }

    public Node getLocation() {
        return this.location;
    }

    public RaiseException getRaiseException() {
        return this.raiseException;
    }

    public void setRaiseException(RaiseException raiseException) {
        assert (this.raiseException == null) : "the RaiseException of a Backtrace must not be set again, otherwise the original backtrace is lost";
        this.raiseException = raiseException;
    }

    public int getOmitted() {
        return this.omitted;
    }

    public Throwable getJavaThrowable() {
        return this.javaThrowable;
    }

    public int getTotalUnderlyingElements() {
        this.getStackTrace();
        return this.totalUnderlyingElements;
    }

    @CompilerDirectives.TruffleBoundary
    public static String labelFor(TruffleStackTraceElement e) {
        RootNode root = e.getTarget().getRootNode();
        String label = root instanceof RubyRootNode ? ((RubyRootNode)root).getSharedMethodInfo().getOriginalName() : root.getName();
        return label == null ? "<unknown>" : label;
    }

    @CompilerDirectives.TruffleBoundary
    public static String baseLabelFor(TruffleStackTraceElement e) {
        RootNode root = e.getTarget().getRootNode();
        String baseLabel = root instanceof RubyRootNode ? ((RubyRootNode)root).getSharedMethodInfo().getMethodName() : root.getName();
        return baseLabel == null ? "<unknown>" : baseLabel;
    }

    @CompilerDirectives.TruffleBoundary
    public Backtrace copy(RubyException exception) {
        Backtrace copy = new Backtrace(this.location, this.omitted, this.javaThrowable);
        RaiseException newRaiseException = new RaiseException(this.raiseException, exception);
        copy.setRaiseException(newRaiseException);
        return copy;
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleStackTraceElement[] getStackTrace(Throwable truffleException) {
        if (this.stackTrace != null) {
            return this.stackTrace;
        }
        if (truffleException == null) {
            truffleException = new GetBacktraceException(this.location, -1);
        }
        List fullStackTrace = TruffleStackTrace.getStackTrace((Throwable)truffleException);
        assert (fullStackTrace != null);
        ArrayList<TruffleStackTraceElement> stackTraceList = new ArrayList<TruffleStackTraceElement>();
        RubyContext context = RubyLanguage.getCurrentContext();
        CallStackManager callStackManager = context.getCallStack();
        int processedCount = 0;
        int retainedCount = 0;
        for (TruffleStackTraceElement stackTraceElement : fullStackTrace) {
            RootCallTarget callTarget;
            assert (processedCount != 0 || stackTraceElement.getLocation() == this.location);
            ++processedCount;
            Node callNode = stackTraceElement.getLocation();
            if (callStackManager.ignoreFrame(callNode, callTarget = stackTraceElement.getTarget())) continue;
            if (retainedCount < this.omitted) {
                ++retainedCount;
                continue;
            }
            RootNode rootNode = callTarget.getRootNode();
            if (rootNode instanceof RubyRootNode || callNode != null) {
                stackTraceList.add(stackTraceElement);
            }
            ++retainedCount;
        }
        while (!stackTraceList.isEmpty() && ((TruffleStackTraceElement)stackTraceList.get(stackTraceList.size() - 1)).getLocation() == null) {
            stackTraceList.remove(stackTraceList.size() - 1);
            --retainedCount;
        }
        this.totalUnderlyingElements = retainedCount;
        this.stackTrace = stackTraceList.toArray(EMPTY_STACK_TRACE_ELEMENTS_ARRAY);
        return this.stackTrace;
    }

    public TruffleStackTraceElement[] getStackTrace() {
        return this.getStackTrace((Throwable)((Object)this.raiseException));
    }

    @CompilerDirectives.TruffleBoundary
    public Object getBacktraceLocations(RubyContext context, RubyLanguage language, int length, Node node) {
        int stackTraceLength;
        if (this.raiseException != null) {
            stackTraceLength = this.getStackTrace().length;
        } else {
            int stackTraceElementsLimit = length < 0 ? -1 : this.omitted + length;
            GetBacktraceException e = new GetBacktraceException(node, stackTraceElementsLimit);
            stackTraceLength = this.getStackTrace((Throwable)((Object)e)).length;
        }
        if (stackTraceLength == 0) {
            return this.omitted > this.totalUnderlyingElements ? Nil.INSTANCE : ArrayHelpers.createEmptyArray(context, language);
        }
        int locationsLength = length < 0 ? stackTraceLength + 1 + length : Math.min(stackTraceLength, length);
        Object[] locations = new Object[locationsLength];
        for (int i = 0; i < locationsLength; ++i) {
            RubyBacktraceLocation instance = new RubyBacktraceLocation(context.getCoreLibrary().threadBacktraceLocationClass, language.threadBacktraceLocationShape, this, i);
            AllocationTracing.trace(instance, node);
            locations[i] = instance;
        }
        return ArrayHelpers.createArray(context, language, locations);
    }
}

