/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.control.FrameOnStackMarker;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;

public final class RubyArguments {
    static final int RUNTIME_ARGUMENT_COUNT = ArgumentIndicies.values().length;

    public static boolean assertFrameArguments(Object[] rubyArgs) {
        assert (rubyArgs.length >= RUNTIME_ARGUMENT_COUNT);
        Object declarationFrame = rubyArgs[ArgumentIndicies.DECLARATION_FRAME.ordinal()];
        assert (declarationFrame == null || declarationFrame instanceof MaterializedFrame) : declarationFrame;
        Object callerVariables = rubyArgs[ArgumentIndicies.CALLER_SPECIAL_VARIABLES.ordinal()];
        assert (callerVariables == null || callerVariables instanceof SpecialVariableStorage) : callerVariables;
        Object internalMethod = rubyArgs[ArgumentIndicies.METHOD.ordinal()];
        assert (internalMethod instanceof InternalMethod) : internalMethod;
        Object declarationContext = rubyArgs[ArgumentIndicies.DECLARATION_CONTEXT.ordinal()];
        assert (declarationContext instanceof DeclarationContext) : declarationContext;
        Object frameOnStackMarker = rubyArgs[ArgumentIndicies.FRAME_ON_STACK_MARKER.ordinal()];
        assert (frameOnStackMarker == null || frameOnStackMarker instanceof FrameOnStackMarker) : frameOnStackMarker;
        assert (RubyGuards.assertIsValidRubyValue(rubyArgs[ArgumentIndicies.SELF.ordinal()]));
        Object block = rubyArgs[ArgumentIndicies.BLOCK.ordinal()];
        assert (block instanceof RubyProc || block == Nil.INSTANCE) : block;
        Object descriptor = rubyArgs[ArgumentIndicies.DESCRIPTOR.ordinal()];
        assert (descriptor instanceof ArgumentsDescriptor) : descriptor;
        if (descriptor instanceof KeywordArgumentsDescriptor) {
            Object lastArgument = RubyArguments.getLastArgument(rubyArgs);
            assert (lastArgument instanceof RubyHash) : "the last frame argument must be a Hash with a kwargs descriptor";
            assert (!((RubyHash)lastArgument).empty()) : "empty kwargs should not have been passed";
        }
        int userArgumentsCount = rubyArgs.length - RUNTIME_ARGUMENT_COUNT;
        assert (ArrayUtils.assertValidElements(rubyArgs, RUNTIME_ARGUMENT_COUNT, userArgumentsCount));
        return true;
    }

    public static Object[] pack(MaterializedFrame declarationFrame, SpecialVariableStorage callerSpecialVariables, InternalMethod method, FrameOnStackMarker frameOnStackMarker, Object self, Object block, ArgumentsDescriptor descriptor, Object[] arguments) {
        DeclarationContext declarationContext = method.getDeclarationContext();
        return RubyArguments.pack(declarationFrame, callerSpecialVariables, method, declarationContext, frameOnStackMarker, self, block, descriptor, arguments);
    }

    public static Object[] pack(MaterializedFrame declarationFrame, SpecialVariableStorage callerSpecialVariables, InternalMethod method, DeclarationContext declarationContext, FrameOnStackMarker frameOnStackMarker, Object self, Object block, ArgumentsDescriptor descriptor, Object[] arguments) {
        Object[] rubyArgs = new Object[RUNTIME_ARGUMENT_COUNT + arguments.length];
        rubyArgs[ArgumentIndicies.DECLARATION_FRAME.ordinal()] = declarationFrame;
        rubyArgs[ArgumentIndicies.CALLER_SPECIAL_VARIABLES.ordinal()] = callerSpecialVariables;
        rubyArgs[ArgumentIndicies.METHOD.ordinal()] = method;
        rubyArgs[ArgumentIndicies.DECLARATION_CONTEXT.ordinal()] = declarationContext;
        rubyArgs[ArgumentIndicies.FRAME_ON_STACK_MARKER.ordinal()] = frameOnStackMarker;
        rubyArgs[ArgumentIndicies.SELF.ordinal()] = self;
        rubyArgs[ArgumentIndicies.BLOCK.ordinal()] = block;
        rubyArgs[ArgumentIndicies.DESCRIPTOR.ordinal()] = descriptor;
        ArrayUtils.arraycopy(arguments, 0, rubyArgs, RUNTIME_ARGUMENT_COUNT, arguments.length);
        assert (RubyArguments.assertFrameArguments(rubyArgs));
        return rubyArgs;
    }

    public static Object[] allocate(int count) {
        return new Object[RUNTIME_ARGUMENT_COUNT + count];
    }

    public static Object[] repack(Object[] rubyArgs, Object receiver) {
        Object[] newArgs = new Object[rubyArgs.length];
        newArgs[ArgumentIndicies.SELF.ordinal()] = receiver;
        newArgs[ArgumentIndicies.BLOCK.ordinal()] = RubyArguments.getBlock(rubyArgs);
        newArgs[ArgumentIndicies.DESCRIPTOR.ordinal()] = RubyArguments.getDescriptor(rubyArgs);
        int count = rubyArgs.length - RUNTIME_ARGUMENT_COUNT;
        System.arraycopy(rubyArgs, RUNTIME_ARGUMENT_COUNT, newArgs, RUNTIME_ARGUMENT_COUNT, count);
        return newArgs;
    }

    public static Object[] repack(Object[] rubyArgs, Object receiver, int from) {
        return RubyArguments.repack(rubyArgs, receiver, from, 0);
    }

    public static Object[] repack(Object[] rubyArgs, Object receiver, int from, int to) {
        int count = RubyArguments.getRawArgumentsCount(rubyArgs) - from;
        Object[] newArgs = new Object[RUNTIME_ARGUMENT_COUNT + to + count];
        newArgs[ArgumentIndicies.SELF.ordinal()] = receiver;
        newArgs[ArgumentIndicies.BLOCK.ordinal()] = RubyArguments.getBlock(rubyArgs);
        newArgs[ArgumentIndicies.DESCRIPTOR.ordinal()] = RubyArguments.getDescriptor(rubyArgs);
        System.arraycopy(rubyArgs, RUNTIME_ARGUMENT_COUNT + from, newArgs, RUNTIME_ARGUMENT_COUNT + to, count);
        return newArgs;
    }

    public static Object[] repackForCall(Object[] rubyArgs) {
        return CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant((Object)rubyArgs.length) ? (Object[])rubyArgs.clone() : rubyArgs;
    }

    public static MaterializedFrame getDeclarationFrame(Frame frame) {
        return (MaterializedFrame)frame.getArguments()[ArgumentIndicies.DECLARATION_FRAME.ordinal()];
    }

    public static void setDeclarationFrame(Frame frame, MaterializedFrame declarationFrame) {
        frame.getArguments()[ArgumentIndicies.DECLARATION_FRAME.ordinal()] = declarationFrame;
    }

    public static void setCallerSpecialVariables(Object[] args, SpecialVariableStorage callerSpecialVariables) {
        args[ArgumentIndicies.CALLER_SPECIAL_VARIABLES.ordinal()] = callerSpecialVariables;
    }

    public static SpecialVariableStorage getCallerSpecialVariables(Frame frame) {
        return (SpecialVariableStorage)frame.getArguments()[ArgumentIndicies.CALLER_SPECIAL_VARIABLES.ordinal()];
    }

    public static InternalMethod getMethod(Object[] args) {
        return (InternalMethod)args[ArgumentIndicies.METHOD.ordinal()];
    }

    public static InternalMethod getMethod(Frame frame) {
        return (InternalMethod)frame.getArguments()[ArgumentIndicies.METHOD.ordinal()];
    }

    public static void setMethod(Object[] args, InternalMethod method) {
        args[ArgumentIndicies.METHOD.ordinal()] = method;
        args[ArgumentIndicies.DECLARATION_CONTEXT.ordinal()] = method.getDeclarationContext();
    }

    public static DeclarationContext getDeclarationContext(Frame frame) {
        return (DeclarationContext)frame.getArguments()[ArgumentIndicies.DECLARATION_CONTEXT.ordinal()];
    }

    public static DeclarationContext getDeclarationContext(Object[] rubyArgs) {
        return (DeclarationContext)rubyArgs[ArgumentIndicies.DECLARATION_CONTEXT.ordinal()];
    }

    public static void setDeclarationContext(Frame frame, DeclarationContext declarationContext) {
        frame.getArguments()[ArgumentIndicies.DECLARATION_CONTEXT.ordinal()] = declarationContext;
    }

    public static FrameOnStackMarker getFrameOnStackMarker(Frame frame) {
        return (FrameOnStackMarker)frame.getArguments()[ArgumentIndicies.FRAME_ON_STACK_MARKER.ordinal()];
    }

    public static Object getSelf(Object[] args) {
        return args[ArgumentIndicies.SELF.ordinal()];
    }

    public static void setSelf(Object[] args, Object self) {
        args[ArgumentIndicies.SELF.ordinal()] = self;
    }

    public static Object getSelf(Frame frame) {
        return frame.getArguments()[ArgumentIndicies.SELF.ordinal()];
    }

    public static Object getBlock(Object[] args) {
        Object block = args[ArgumentIndicies.BLOCK.ordinal()];
        assert (block instanceof Nil || block instanceof RubyProc) : StringUtils.toString(block);
        return block;
    }

    public static void setBlock(Object[] args, Object block) {
        assert (block instanceof Nil || block instanceof RubyProc) : StringUtils.toString(block);
        args[ArgumentIndicies.BLOCK.ordinal()] = block;
    }

    public static Object getBlock(Frame frame) {
        Object block = frame.getArguments()[ArgumentIndicies.BLOCK.ordinal()];
        assert (block instanceof Nil || block instanceof RubyProc) : StringUtils.toString(block);
        return block;
    }

    public static void setDescriptor(Object[] args, ArgumentsDescriptor descriptor) {
        assert (descriptor != null);
        args[ArgumentIndicies.DESCRIPTOR.ordinal()] = descriptor;
    }

    public static ArgumentsDescriptor getDescriptor(Frame frame) {
        return RubyArguments.getDescriptor(frame.getArguments());
    }

    public static ArgumentsDescriptor getDescriptor(Object[] args) {
        Object descriptor = args[ArgumentIndicies.DESCRIPTOR.ordinal()];
        assert (descriptor instanceof ArgumentsDescriptor) : descriptor;
        return (ArgumentsDescriptor)descriptor;
    }

    public static int getRawArgumentsCount(Frame frame) {
        return frame.getArguments().length - RUNTIME_ARGUMENT_COUNT;
    }

    public static int getRawArgumentsCount(Object[] rubyArgs) {
        return rubyArgs.length - RUNTIME_ARGUMENT_COUNT;
    }

    public static int getPositionalArgumentsCount(Frame frame, boolean methodHasKeywordParameters) {
        return RubyArguments.getPositionalArgumentsCount(frame.getArguments(), methodHasKeywordParameters);
    }

    public static int getPositionalArgumentsCount(Object[] rubyArgs, boolean methodHasKeywordParameters) {
        CompilerAsserts.partialEvaluationConstant((boolean)methodHasKeywordParameters);
        int argumentsCount = rubyArgs.length - RUNTIME_ARGUMENT_COUNT;
        if (methodHasKeywordParameters && RubyArguments.getDescriptor(rubyArgs) instanceof KeywordArgumentsDescriptor) {
            return argumentsCount - 1;
        }
        return argumentsCount;
    }

    public static int getPositionalArgumentsCount(Object[] rubyArgs) {
        return rubyArgs.length - RUNTIME_ARGUMENT_COUNT;
    }

    public static Object getArgument(Frame frame, int index) {
        assert (index >= 0 && index < RubyArguments.getRawArgumentsCount(frame));
        return frame.getArguments()[RUNTIME_ARGUMENT_COUNT + index];
    }

    public static Object getArgument(Object[] rubyArgs, int index) {
        assert (index >= 0 && index < RubyArguments.getRawArgumentsCount(rubyArgs));
        return rubyArgs[RUNTIME_ARGUMENT_COUNT + index];
    }

    public static Object getLastArgument(Frame frame) {
        return RubyArguments.getLastArgument(frame.getArguments());
    }

    public static Object getLastArgument(Object[] rubyArgs) {
        assert (RubyArguments.getRawArgumentsCount(rubyArgs) > 0);
        return rubyArgs[rubyArgs.length - 1];
    }

    public static void setLastArgument(Frame frame, Object value) {
        RubyArguments.setLastArgument(frame.getArguments(), value);
    }

    public static void setLastArgument(Object[] rubyArgs, Object value) {
        assert (RubyArguments.getRawArgumentsCount(rubyArgs) > 0);
        rubyArgs[rubyArgs.length - 1] = value;
    }

    public static void setArgument(Object[] rubyArgs, int index, Object value) {
        assert (index >= 0 && index < RubyArguments.getRawArgumentsCount(rubyArgs));
        rubyArgs[RubyArguments.RUNTIME_ARGUMENT_COUNT + index] = value;
    }

    public static Object[] getPositionalArguments(Object[] rubyArgs) {
        int count = RubyArguments.getPositionalArgumentsCount(rubyArgs);
        return ArrayUtils.extractRange(rubyArgs, RUNTIME_ARGUMENT_COUNT, RUNTIME_ARGUMENT_COUNT + count);
    }

    public static Object[] getRawArguments(Frame frame, int start, int length) {
        Object[] rubyArgs = frame.getArguments();
        return ArrayUtils.extractRange(rubyArgs, RUNTIME_ARGUMENT_COUNT + start, RUNTIME_ARGUMENT_COUNT + start + length);
    }

    public static Object[] getRawArguments(Object[] rubyArgs) {
        return ArrayUtils.extractRange(rubyArgs, RUNTIME_ARGUMENT_COUNT, rubyArgs.length);
    }

    public static Object[] getRawArguments(Frame frame) {
        Object[] rubyArgs = frame.getArguments();
        return ArrayUtils.extractRange(rubyArgs, RUNTIME_ARGUMENT_COUNT, rubyArgs.length);
    }

    public static void setArguments(Object[] rubyArgs, Object[] arguments) {
        ArrayUtils.arraycopy(arguments, 0, rubyArgs, RUNTIME_ARGUMENT_COUNT, arguments.length);
    }

    public static Frame getDeclarationFrame(Frame topFrame, int level) {
        assert (topFrame != null);
        assert (level >= 0);
        CompilerAsserts.partialEvaluationConstant((int)level);
        if (level == 0) {
            return topFrame;
        }
        return RubyArguments.getDeclarationFrame(RubyArguments.getDeclarationFrame(topFrame), level - 1);
    }

    public static MaterializedFrame getDeclarationFrame(MaterializedFrame frame, int level) {
        assert (frame != null);
        assert (level >= 0);
        CompilerAsserts.partialEvaluationConstant((int)level);
        return CompilerDirectives.inCompiledCode() && level <= 16 ? RubyArguments.getDeclarationFrameExplode(frame, level) : RubyArguments.getDeclarationFrameLoop(frame, level);
    }

    @ExplodeLoop
    private static MaterializedFrame getDeclarationFrameExplode(MaterializedFrame frame, int level) {
        for (int n = 0; n < level; ++n) {
            frame = RubyArguments.getDeclarationFrame((Frame)frame);
        }
        return frame;
    }

    private static MaterializedFrame getDeclarationFrameLoop(MaterializedFrame frame, int level) {
        for (int n = 0; n < level; ++n) {
            frame = RubyArguments.getDeclarationFrame((Frame)frame);
        }
        return frame;
    }

    public static MaterializedFrame tryGetDeclarationFrame(Frame frame) {
        if (ArgumentIndicies.DECLARATION_FRAME.ordinal() >= frame.getArguments().length) {
            return null;
        }
        Object declarationFrame = frame.getArguments()[ArgumentIndicies.DECLARATION_FRAME.ordinal()];
        if (declarationFrame instanceof MaterializedFrame) {
            return (MaterializedFrame)declarationFrame;
        }
        return null;
    }

    public static Object tryGetSelf(Frame frame) {
        if (ArgumentIndicies.SELF.ordinal() >= frame.getArguments().length) {
            return null;
        }
        return frame.getArguments()[ArgumentIndicies.SELF.ordinal()];
    }

    public static RubyProc tryGetBlock(Frame frame) {
        if (ArgumentIndicies.BLOCK.ordinal() >= frame.getArguments().length) {
            return null;
        }
        Object proc = frame.getArguments()[ArgumentIndicies.BLOCK.ordinal()];
        return proc instanceof RubyProc ? (RubyProc)proc : null;
    }

    public static InternalMethod tryGetMethod(Frame frame) {
        if (ArgumentIndicies.METHOD.ordinal() >= frame.getArguments().length) {
            return null;
        }
        Object method = frame.getArguments()[ArgumentIndicies.METHOD.ordinal()];
        if (method instanceof InternalMethod) {
            return (InternalMethod)method;
        }
        return null;
    }

    public static DeclarationContext tryGetDeclarationContext(Frame frame) {
        if (frame == null) {
            return null;
        }
        if (ArgumentIndicies.DECLARATION_CONTEXT.ordinal() >= frame.getArguments().length) {
            return null;
        }
        Object declarationContext = frame.getArguments()[ArgumentIndicies.DECLARATION_CONTEXT.ordinal()];
        if (declarationContext instanceof DeclarationContext) {
            return (DeclarationContext)declarationContext;
        }
        return null;
    }

    private static enum ArgumentIndicies {
        DECLARATION_FRAME,
        CALLER_SPECIAL_VARIABLES,
        METHOD,
        DECLARATION_CONTEXT,
        FRAME_ON_STACK_MARKER,
        SELF,
        BLOCK,
        DESCRIPTOR;

    }
}

