/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;

public final class ReadUserKeywordsHashNode
extends RubyBaseNode {
    private final ConditionProfile keywordArgumentsProfile = ConditionProfile.create();

    public RubyHash execute(VirtualFrame frame) {
        ArgumentsDescriptor descriptor = RubyArguments.getDescriptor((Frame)frame);
        if (this.keywordArgumentsProfile.profile(descriptor instanceof KeywordArgumentsDescriptor)) {
            RubyHash keywords = (RubyHash)RubyArguments.getLastArgument((Frame)frame);
            assert (!keywords.empty());
            assert (this.assertHashMatchesDescriptor(keywords, (KeywordArgumentsDescriptor)descriptor));
            return keywords;
        }
        return null;
    }

    private boolean assertHashMatchesDescriptor(RubyHash hash, KeywordArgumentsDescriptor descriptor) {
        HashStoreLibrary hashStoreLibrary = HashStoreLibrary.getUncached(hash);
        for (String keyword : descriptor.getKeywords()) {
            RubySymbol symbol = this.getSymbol(keyword);
            Object value = hashStoreLibrary.lookupOrDefault(hash.store, null, hash, symbol, (f, h, k) -> null);
            assert (value != null) : "descriptor claims " + keyword + " was passed as a keyword argument but it's not in the hash";
        }
        return true;
    }
}

