/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;

public final class ReadPostArgumentNode
extends RubyContextSourceNode {
    private final int indexFromCount;
    private final int required;
    private final int optional;
    private final boolean hasRest;
    private final boolean keywordArguments;
    private final ConditionProfile enoughArguments = ConditionProfile.create();

    public ReadPostArgumentNode(int indexFromCount, int required, int optional, boolean hasRest, boolean keywordArguments) {
        this.indexFromCount = indexFromCount;
        this.required = required;
        this.optional = optional;
        this.hasRest = hasRest;
        this.keywordArguments = keywordArguments;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int length = RubyArguments.getPositionalArgumentsCount((Frame)frame, this.keywordArguments);
        if (this.enoughArguments.profile(length >= this.required)) {
            int effectiveIndex = this.hasRest || length <= this.optional + this.required ? length - this.indexFromCount : this.optional + this.required - this.indexFromCount;
            return RubyArguments.getArgument((Frame)frame, effectiveIndex);
        }
        int effectiveIndex = this.required - this.indexFromCount;
        if (effectiveIndex < length) {
            return RubyArguments.getArgument((Frame)frame, effectiveIndex);
        }
        return nil;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " -" + this.indexFromCount;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadPostArgumentNode copy = new ReadPostArgumentNode(this.indexFromCount, this.required, this.optional, this.hasRest, this.keywordArguments);
        return copy.copyFlags(this);
    }
}

