/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;

public final class ReadOptionalArgumentNode
extends RubyContextSourceNode {
    private final int index;
    private final int minimum;
    private final boolean keywordArguments;
    @Node.Child
    private RubyNode defaultValue;
    private final BranchProfile defaultValueProfile = BranchProfile.create();

    public ReadOptionalArgumentNode(int index, int minimum, boolean keywordArguments, RubyNode defaultValue) {
        this.index = index;
        this.minimum = minimum;
        this.keywordArguments = keywordArguments;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int positionalArgumentsCount = RubyArguments.getPositionalArgumentsCount((Frame)frame, this.keywordArguments);
        if (positionalArgumentsCount >= this.minimum) {
            return RubyArguments.getArgument((Frame)frame, this.index);
        }
        this.defaultValueProfile.enter();
        return this.defaultValue.execute(frame);
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.index;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadOptionalArgumentNode copy = new ReadOptionalArgumentNode(this.index, this.minimum, this.keywordArguments, this.defaultValue.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

