/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.hash.HashOperations;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.CheckKeywordArityNode;
import org.truffleruby.language.arguments.ReadUserKeywordsHashNode;
import org.truffleruby.language.methods.Arity;

public final class ReadKeywordRestArgumentNode
extends RubyContextSourceNode
implements HashStoreLibrary.EachEntryCallback {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final RubySymbol[] excludedKeywords;
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;
    @Node.Child
    private HashStoreLibrary hashes = HashStoreLibrary.createDispatched();
    private final ConditionProfile noHash = ConditionProfile.create();

    public ReadKeywordRestArgumentNode(RubyLanguage language, Arity arity) {
        this(CheckKeywordArityNode.keywordsAsSymbols(language, arity));
    }

    private ReadKeywordRestArgumentNode(RubySymbol[] excludedKeywords) {
        this.excludedKeywords = excludedKeywords;
        this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.lookupRestKeywordArgumentHash(frame);
    }

    private Object lookupRestKeywordArgumentHash(VirtualFrame frame) {
        RubyHash hash = this.readUserKeywordsHashNode.execute(frame);
        if (this.noHash.profile(hash == null)) {
            return HashOperations.newEmptyHash(this.getContext(), this.getLanguage());
        }
        RubyHash kwRest = HashOperations.newEmptyHash(this.getContext(), this.getLanguage());
        return this.hashes.eachEntry(hash.store, hash, this, kwRest);
    }

    @Override
    public void accept(int index, Object key, Object value, Object kwRest) {
        if (!this.keywordExcluded(key)) {
            RubyHash hash = (RubyHash)kwRest;
            this.hashes.set(hash.store, hash, key, value, false);
        }
    }

    @ExplodeLoop
    private boolean keywordExcluded(Object keyword) {
        for (int i = 0; i < this.excludedKeywords.length; ++i) {
            if (this.excludedKeywords[i] != keyword) continue;
            return true;
        }
        return false;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadKeywordRestArgumentNode copy = new ReadKeywordRestArgumentNode(this.excludedKeywords);
        return copy.copyFlags(this);
    }
}

