/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.kernel.TruffleKernelNodes;
import org.truffleruby.language.CallStackManager;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;

public class ReadCallerVariablesNode
extends RubyBaseNode {
    private final ConditionProfile inArgumentsProfile = ConditionProfile.create();

    public static ReadCallerVariablesNode create() {
        return new ReadCallerVariablesNode();
    }

    public SpecialVariableStorage execute(Frame frame) {
        SpecialVariableStorage data = RubyArguments.getCallerSpecialVariables(frame);
        if (this.inArgumentsProfile.profile(data != null)) {
            return data;
        }
        return this.getCallerSpecialVariables();
    }

    @CompilerDirectives.TruffleBoundary
    protected SpecialVariableStorage getCallerSpecialVariables() {
        MaterializedFrame callerFrame = (MaterializedFrame)Truffle.getRuntime().iterateFrames(f -> f.getFrame(FrameInstance.FrameAccess.MATERIALIZE).materialize(), 1);
        if (!CallStackManager.isRubyFrame((Frame)callerFrame)) {
            throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("Cannot call Ruby method which needs caller special variables directly in a foreign language", this));
        }
        return TruffleKernelNodes.GetSpecialVariableStorage.executeUncached((Frame)callerFrame);
    }
}

