/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.array.ArrayIndexNodes;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

public final class ReadBlockPostArgumentFromArrayNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode readArrayNode;
    @Node.Child
    private ArrayIndexNodes.ReadNormalizedNode arrayReadNormalizedNode;
    private final int indexFromCount;
    private final int required;
    private final int optional;
    private final boolean hasRest;
    private final ConditionProfile enoughArguments = ConditionProfile.create();

    public ReadBlockPostArgumentFromArrayNode(RubyNode readArrayNode, int indexFromCount, int required, int optional, boolean hasRest) {
        this.readArrayNode = readArrayNode;
        this.indexFromCount = indexFromCount;
        this.required = required;
        this.optional = optional;
        this.hasRest = hasRest;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyArray array = (RubyArray)this.readArrayNode.execute(frame);
        int length = array.size;
        if (this.enoughArguments.profile(length >= this.required)) {
            int effectiveIndex = this.hasRest || length <= this.optional + this.required ? length - this.indexFromCount : this.optional + this.required - this.indexFromCount;
            return this.getReadNormalizedNode().executeRead(array, effectiveIndex);
        }
        int effectiveIndex = this.required - this.indexFromCount;
        if (effectiveIndex < length) {
            return this.getReadNormalizedNode().executeRead(array, effectiveIndex);
        }
        return nil;
    }

    private ArrayIndexNodes.ReadNormalizedNode getReadNormalizedNode() {
        if (this.arrayReadNormalizedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.arrayReadNormalizedNode = (ArrayIndexNodes.ReadNormalizedNode)this.insert(ArrayIndexNodes.ReadNormalizedNode.create());
        }
        return this.arrayReadNormalizedNode;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " -" + this.indexFromCount;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadBlockPostArgumentFromArrayNode copy = new ReadBlockPostArgumentFromArrayNode(this.readArrayNode.cloneUninitialized(), this.indexFromCount, this.required, this.optional, this.hasRest);
        return copy.copyFlags(this);
    }
}

