/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.core.array.ArrayIndexNodes;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

public final class ReadBlockOptionalArgumentFromArrayNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode readArrayNode;
    @Node.Child
    private RubyNode defaultValue;
    @Node.Child
    private ArrayIndexNodes.ReadNormalizedNode arrayReadNormalizedNode;
    private final int index;
    private final int minimum;
    private final BranchProfile defaultValueProfile = BranchProfile.create();

    public ReadBlockOptionalArgumentFromArrayNode(RubyNode readArrayNode, int index, int minimum, RubyNode defaultValue) {
        this.readArrayNode = readArrayNode;
        this.index = index;
        this.minimum = minimum;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyArray array = (RubyArray)this.readArrayNode.execute(frame);
        int length = array.size;
        if (length >= this.minimum) {
            if (this.arrayReadNormalizedNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayReadNormalizedNode = (ArrayIndexNodes.ReadNormalizedNode)this.insert(ArrayIndexNodes.ReadNormalizedNode.create());
            }
            return this.arrayReadNormalizedNode.executeRead(array, this.index);
        }
        this.defaultValueProfile.enter();
        return this.defaultValue.execute(frame);
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.index;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadBlockOptionalArgumentFromArrayNode copy = new ReadBlockOptionalArgumentFromArrayNode(this.readArrayNode.cloneUninitialized(), this.index, this.minimum, this.defaultValue.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

