/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import java.util.Objects;
import org.truffleruby.language.NoImplicitCastsToLong;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.ProfileArgumentNodeGen;

@TypeSystemReference(value=NoImplicitCastsToLong.class)
@ImportStatic(value={CompilerDirectives.class})
@NodeChild(value="childNode", type=RubyNode.class)
public abstract class ProfileArgumentNode
extends RubyContextSourceNode {
    protected abstract RubyNode getChildNode();

    @Specialization(guards={"guardBoolean(value, cachedValue)"})
    boolean doBoolean(boolean value, @Cached(value="createCachedValue(value)") @Cached.Shared Object cachedValue) {
        return (Boolean)cachedValue;
    }

    @Specialization(guards={"guardInt(value, cachedValue)"})
    int doInt(int value, @Cached(value="createCachedValue(value)") @Cached.Shared Object cachedValue) {
        return (Integer)cachedValue;
    }

    @Specialization(guards={"guardLong(value, cachedValue)"})
    long doLong(long value, @Cached(value="createCachedValue(value)") @Cached.Shared Object cachedValue) {
        return (Long)cachedValue;
    }

    @Specialization(guards={"guardDouble(value, cachedValue)"})
    double doDouble(double value, @Cached(value="createCachedValue(value)") @Cached.Shared Object cachedValue) {
        return (Double)cachedValue;
    }

    @Specialization(guards={"guardClass(value, cachedValue)", "!isPrimitiveClass(cachedValue)"})
    Object doClass(Object value, @Cached(value="createCachedValue(value)") @Cached.Shared Object cachedValue) {
        assert (RubyGuards.assertIsValidRubyValue(value));
        if (CompilerDirectives.inInterpreter()) {
            return value;
        }
        return CompilerDirectives.castExact((Object)value, (Class)((Class)cachedValue));
    }

    @Specialization(replaces={"doBoolean", "doInt", "doLong", "doDouble", "doClass"})
    Object doGeneric(Object value) {
        assert (RubyGuards.assertIsValidRubyValue(value));
        return value;
    }

    @NeverDefault
    static Object createCachedValue(Object value) {
        if (RubyGuards.isPrimitive(value)) {
            return value;
        }
        return value == null ? Objects.class : value.getClass();
    }

    static boolean guardBoolean(boolean value, Object cachedValue) {
        Boolean cachedBoolean;
        return cachedValue instanceof Boolean && value == (cachedBoolean = (Boolean)cachedValue);
    }

    static boolean guardInt(int value, Object cachedValue) {
        Integer cachedInt;
        return cachedValue instanceof Integer && value == (cachedInt = (Integer)cachedValue);
    }

    static boolean guardLong(long value, Object cachedValue) {
        Long cachedLong;
        return cachedValue instanceof Long && value == (cachedLong = (Long)cachedValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean guardDouble(double value, Object cachedValue) {
        if (!(cachedValue instanceof Double)) return false;
        Double cachedDouble = (Double)cachedValue;
        if (Double.doubleToRawLongBits(value) != Double.doubleToRawLongBits(cachedDouble)) return false;
        return true;
    }

    static boolean guardClass(Object value, Object cachedValue) {
        Class cachedClass;
        return cachedValue instanceof Class && CompilerDirectives.isExact((Object)value, (Class)(cachedClass = (Class)cachedValue));
    }

    @Idempotent
    static boolean isPrimitiveClass(Object cachedValue) {
        return RubyGuards.isPrimitiveClass((Class)cachedValue);
    }

    @Override
    public RubyNode cloneUninitialized() {
        ProfileArgumentNode copy = ProfileArgumentNodeGen.create(this.getChildNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

