/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.RubyContext;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.globals.ReadSimpleGlobalVariableNode;

public class WarnNode
extends RubyBaseNode {
    @Node.Child
    protected ReadSimpleGlobalVariableNode readVerboseNode = ReadSimpleGlobalVariableNode.create("$VERBOSE");
    @Node.Child
    private DispatchNode callWarnNode;
    @Node.Child
    private TruffleString.FromJavaStringNode fromJavaStringNode;

    @NeverDefault
    public static WarnNode create() {
        return new WarnNode();
    }

    public boolean shouldWarn() {
        Object verbose = this.readVerboseNode.execute();
        return verbose != nil;
    }

    public final boolean shouldWarnForDeprecation() {
        return this.shouldWarn() && (Boolean)this.getContext().getWarningCategoryDeprecated().get() != false;
    }

    public void warningMessage(SourceSection sourceSection, String message) {
        assert (this.shouldWarn());
        if (this.fromJavaStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.fromJavaStringNode = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
        }
        if (this.callWarnNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callWarnNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        WarnNode.callWarn(this.getContext(), sourceSection, message, this, this.fromJavaStringNode, this.callWarnNode);
    }

    static void callWarn(RubyContext context, SourceSection sourceSection, String message, RubyBaseNode node, TruffleString.FromJavaStringNode fromJavaStringNode, DispatchNode callWarnNode) {
        String warningMessage = WarnNode.buildWarningMessage(context, sourceSection, message);
        RubyString warningString = node.createString(fromJavaStringNode, warningMessage, Encodings.UTF_8);
        callWarnNode.call((Object)context.getCoreLibrary().kernelModule, "warn", (Object)warningString);
    }

    @CompilerDirectives.TruffleBoundary
    private static String buildWarningMessage(RubyContext context, SourceSection sourceSection, String message) {
        String sourceLocation = sourceSection != null ? context.fileLine(sourceSection) + ": " : "";
        return sourceLocation + "warning: " + message;
    }

    @DenyReplace
    public static final class UncachedWarnNode
    extends AbstractUncachedWarnNode {
        public static final UncachedWarnNode INSTANCE = new UncachedWarnNode();

        UncachedWarnNode() {
        }

        @Override
        public boolean shouldWarn() {
            return this.coreLibrary().warningsEnabled();
        }
    }

    static abstract class AbstractUncachedWarnNode
    extends RubyBaseNode {
        AbstractUncachedWarnNode() {
        }

        public abstract boolean shouldWarn();

        public void warningMessage(SourceSection sourceSection, String message) {
            assert (this.shouldWarn());
            WarnNode.callWarn(this.getContext(), sourceSection, message, this, TruffleString.FromJavaStringNode.getUncached(), DispatchNode.getUncached());
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

