/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.llvm.api.Toolchain;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.graalvm.options.OptionDescriptor;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.CoreMethodNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.EmitWarningsNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.exceptions.TopLevelRaiseHandler;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.loader.CodeLoader;
import org.truffleruby.language.loader.MainLoader;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;
import org.truffleruby.shared.Metrics;
import org.truffleruby.shared.options.OptionsCatalog;

@CoreModule(value="Truffle::Boot")
public abstract class TruffleBootNodes {
    private static Toolchain getToolchain(RubyContext context, Node currentNode) {
        LanguageInfo llvmInfo = (LanguageInfo)context.getEnv().getInternalLanguages().get("llvm");
        if (llvmInfo == null) {
            throw new RaiseException(context, context.getCoreExceptions().runtimeError("Could not find Sulong in internal languages", currentNode));
        }
        Toolchain toolchain = (Toolchain)context.getEnv().lookup(llvmInfo, Toolchain.class);
        if (toolchain == null) {
            throw new RaiseException(context, context.getCoreExceptions().runtimeError("Could not find the LLVM Toolchain", currentNode));
        }
        return toolchain;
    }

    @CoreMethod(names={"read_abi_version"}, onSingleton=true)
    public static abstract class ReadABIVersionNode
    extends CoreMethodNode {
        private static final String ABI_VERSION_FILE = "lib/cext/include/truffleruby/truffleruby-abi-version.h";

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString basicABIVersion() {
            byte[] bytes;
            TruffleFile file = this.getLanguage().getRubyHomeTruffleFile().resolve(ABI_VERSION_FILE);
            try {
                bytes = file.readAllBytes();
            }
            catch (IOException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            int startQuote = ArrayUtils.indexOf((byte[])bytes, (int)0, (int)bytes.length, (byte[])new byte[]{34});
            if (startQuote < 0) {
                throw CompilerDirectives.shouldNotReachHere((String)"Invalid contents for lib/cext/include/truffleruby/truffleruby-abi-version.h");
            }
            int start = startQuote + 1;
            int endQuote = ArrayUtils.indexOf((byte[])bytes, (int)start, (int)bytes.length, (byte[])new byte[]{34});
            if (endQuote < 0) {
                throw CompilerDirectives.shouldNotReachHere((String)"Invalid contents for lib/cext/include/truffleruby/truffleruby-abi-version.h");
            }
            String basicVersion = new String(bytes, start, endQuote - start, StandardCharsets.US_ASCII);
            return this.createString(TruffleString.FromJavaStringNode.getUncached(), basicVersion, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"toolchain_paths"}, onSingleton=true, required=1)
    public static abstract class ToolchainPathsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object toolchainPaths(RubySymbol pathName, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String name = pathName.getString();
            Toolchain toolchain = TruffleBootNodes.getToolchain(this.getContext(), this);
            List paths = toolchain.getPaths(name);
            if (paths != null) {
                String path = StringUtils.join(paths.toArray(), File.pathSeparator);
                return this.createString(fromJavaStringNode, path, Encodings.UTF_8);
            }
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("Toolchain path " + name + " not found", this));
        }
    }

    @CoreMethod(names={"toolchain_executable"}, onSingleton=true, required=1)
    public static abstract class ToolchainExecutableNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object toolchainExecutable(RubySymbol executable, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String name = executable.getString();
            Toolchain toolchain = TruffleBootNodes.getToolchain(this.getContext(), this);
            TruffleFile path = toolchain.getToolPath(name);
            if (path != null) {
                return this.createString(fromJavaStringNode, path.getPath(), Encodings.UTF_8);
            }
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("Toolchain executable " + name + " not found", this));
        }
    }

    @CoreMethod(names={"single_threaded?"}, onSingleton=true)
    public static abstract class SingleThreadedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean singleThreaded() {
            return this.getContext().getOptions().SINGLE_THREADED;
        }
    }

    @CoreMethod(names={"print_time_metric"}, onSingleton=true, required=1)
    public static abstract class PrintTimeMetricNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object printTimeMetric(RubySymbol name) {
            Metrics.printTime((String)name.getString());
            return nil;
        }
    }

    @CoreMethod(names={"get_option"}, onSingleton=true, required=1)
    public static abstract class GetOptionNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"libOptionName.isRubyString(optionName)"}, limit="1")
        Object getOption(Object optionName, @Cached RubyStringLibrary libOptionName) {
            String optionNameString = RubyGuards.getJavaString(optionName);
            OptionDescriptor descriptor = OptionsCatalog.fromName((String)("ruby." + optionNameString));
            if (descriptor == null) {
                throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameError("option not defined: " + optionNameString, nil, optionNameString, this));
            }
            Object value = this.getContext().getOptions().fromDescriptor(descriptor);
            if (value != null && this.getContext().isPreInitializing()) {
                throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("Truffle::Boot.get_option() should not be called during pre-initialization as context options might change at runtime.\nUse Truffle::Boot.{delay,redo} to delay such a check to runtime, or make the option a language option.", this));
            }
            if (value == null) {
                value = this.getLanguage().options.fromDescriptor(descriptor);
            }
            if (value instanceof Boolean || value instanceof Integer) {
                return value;
            }
            if (value instanceof Enum) {
                return this.getSymbol(value.toString());
            }
            if (value instanceof String) {
                return this.createString(this.fromJavaStringNode, (String)value, Encodings.UTF_8);
            }
            if (value instanceof String[]) {
                return this.toRubyArray((String[])value);
            }
            throw CompilerDirectives.shouldNotReachHere((String)("Unknown value for option " + optionNameString + ": " + String.valueOf(value)));
        }

        private RubyArray toRubyArray(String[] strings) {
            Object[] objects = new Object[strings.length];
            for (int n = 0; n < strings.length; ++n) {
                objects[n] = this.createString(this.fromJavaStringNode, strings[n], Encodings.UTF_8);
            }
            return this.createArray(objects);
        }
    }

    @CoreMethod(names={"inner_check_syntax"}, onSingleton=true, required=1)
    public static abstract class InnerCheckSyntaxNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object innerCheckSyntax(RubySource source) {
            RubyContext context = this.getContext();
            RootCallTarget callTarget = context.getCodeLoader().parse(source, ParserContext.TOP_LEVEL, null, context.getRootLexicalScope(), null);
            RubyRootNode rubyRootNode = RubyRootNode.of(callTarget);
            EmitWarningsNode emitWarningsNode = (EmitWarningsNode)((Object)NodeUtil.findFirstNodeInstance((Node)rubyRootNode, EmitWarningsNode.class));
            if (emitWarningsNode != null) {
                emitWarningsNode.printWarnings(context);
            }
            return nil;
        }
    }

    @CoreMethod(names={"source_of_caller"}, onSingleton=true)
    public static abstract class SourceOfCallerNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object sourceOfCaller() {
            int[] frameCount = new int[]{0};
            Source source = (Source)Truffle.getRuntime().iterateFrames(frameInstance -> {
                if (frameCount[0] == 2) {
                    return frameInstance.getCallNode().getEncapsulatingSourceSection().getSource();
                }
                frameCount[0] = frameCount[0] + 1;
                return null;
            });
            if (source == null) {
                return nil;
            }
            return this.createString(this.fromJavaStringNode, this.getLanguage().getSourcePath(source), Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"extra_load_paths"}, onSingleton=true)
    public static abstract class ExtraLoadPathsNode
    extends CoreMethodNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray extraLoadPaths() {
            String[] paths = this.getContext().getOptions().LOAD_PATHS;
            Object[] array = new Object[paths.length];
            for (int n = 0; n < array.length; ++n) {
                array[n] = this.createString(this.fromJavaStringNode, paths[n], Encodings.UTF_8);
            }
            return this.createArray(array);
        }
    }

    @CoreMethod(names={"original_argv"}, onSingleton=true)
    public static abstract class OriginalArgvNode
    extends CoreMethodNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray originalArgv() {
            String[] argv = this.getContext().getEnv().getApplicationArguments();
            Object[] array = new Object[argv.length];
            for (int n = 0; n < array.length; ++n) {
                array[n] = this.createString(this.fromJavaStringNode, argv[n], this.getContext().getEncodingManager().getDefaultExternalEncoding());
            }
            return this.createArray(array);
        }
    }

    @CoreMethod(names={"main"}, onSingleton=true, required=4, lowerFixnum={1})
    public static abstract class MainNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        TopLevelRaiseHandler topLevelRaiseHandler = new TopLevelRaiseHandler();
        @Node.Child
        DispatchNode checkSyntax = DispatchNode.create();
        @Node.Child
        IndirectCallNode callNode = IndirectCallNode.create();
        @Node.Child
        DispatchNode requireNode = DispatchNode.create();
        @Node.Child
        TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        int main(int argc, long argv, String kind, String toExecute) {
            return this.topLevelRaiseHandler.execute(() -> {
                this.getContext().nativeArgc = argc;
                this.getContext().nativeArgv = argv;
                this.setArgvGlobals();
                RubySource rubySource = this.loadMainSourceSettingDollarZero(kind, toExecute.intern());
                for (String requiredLibrary : this.getContext().getOptions().REQUIRED_LIBRARIES) {
                    this.requireNode.call((Object)this.coreLibrary().mainObject, "require", (Object)this.utf8(requiredLibrary));
                }
                if (this.getContext().getOptions().SYNTAX_CHECK) {
                    this.checkSyntax.call((Object)this.coreLibrary().truffleBootModule, "check_syntax", rubySource);
                } else {
                    RootCallTarget callTarget = this.getContext().getCodeLoader().parseTopLevelWithCache(rubySource, null);
                    CodeLoader.DeferredCall deferredCall = this.getContext().getCodeLoader().prepareExecute(callTarget, ParserContext.TOP_LEVEL_FIRST, DeclarationContext.topLevel(this.getContext()), null, (Object)this.coreLibrary().mainObject, this.getContext().getRootLexicalScope());
                    deferredCall.call(this.callNode);
                }
            });
        }

        private void setArgvGlobals() {
            if (this.getContext().getOptions().ARGV_GLOBALS) {
                String[] global_flags;
                String[] global_values = this.getContext().getOptions().ARGV_GLOBAL_VALUES;
                assert (global_values.length % 2 == 0);
                for (int i = 0; i < global_values.length; i += 2) {
                    String key = global_values[i];
                    String value = global_values[i + 1];
                    this.getContext().getCoreLibrary().globalVariables.define("$" + key, (Object)this.utf8(value), (Node)this);
                }
                for (String flag : global_flags = this.getContext().getOptions().ARGV_GLOBAL_FLAGS) {
                    this.getContext().getCoreLibrary().globalVariables.define("$" + flag, true, (Node)this);
                }
            }
        }

        private RubySource loadMainSourceSettingDollarZero(String kind, String toExecute) {
            String mainScriptName;
            RubySource rubySource;
            MainLoader mainLoader = new MainLoader(this.getContext(), this.getLanguage());
            try {
                switch (kind) {
                    case "FILE": {
                        rubySource = mainLoader.loadFromFile(this.getContext().getEnv(), this, toExecute);
                        mainScriptName = toExecute;
                        break;
                    }
                    case "STDIN": {
                        rubySource = mainLoader.loadFromStandardIn(this, "-");
                        mainScriptName = "-";
                        break;
                    }
                    case "INLINE": {
                        rubySource = mainLoader.loadFromCommandLineArgument(toExecute);
                        mainScriptName = "-e";
                        break;
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere((String)kind);
                    }
                }
            }
            catch (IOException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().ioError(e, (Node)this));
            }
            assert ("application/x-ruby;main-script=true".equals(rubySource.getSource().getMimeType()));
            this.getContext().initializeMainScriptName(mainScriptName);
            return rubySource;
        }

        private RubyString utf8(String string) {
            return this.createString(this.fromJavaStringNode, string, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"was_preinitialized?"}, onSingleton=true)
    public static abstract class WasPreinitializedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean wasPreinitializedContext() {
            return this.getContext().wasPreInitialized();
        }
    }

    @CoreMethod(names={"preinitializing?"}, onSingleton=true)
    public static abstract class IsPreinitializingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isPreinitializingContext() {
            return this.getContext().isPreInitializing();
        }
    }

    @CoreMethod(names={"force_context"}, onSingleton=true)
    public static abstract class ForceContextNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object forceContext() {
            return nil;
        }
    }

    @CoreMethod(names={"ruby_home"}, onSingleton=true)
    public static abstract class RubyHomeNode
    extends CoreMethodNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object rubyHome() {
            String home = this.getLanguage().getRubyHome();
            return this.createString(this.fromJavaStringNode, home, Encodings.UTF_8);
        }
    }
}

