/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.truffleruby.RubyContext;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.SafepointAction;

public final class SafepointManager {
    private final RubyContext context;

    public SafepointManager(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public void pauseRubyThreadAndExecute(Node currentNode, SafepointAction action) {
        RubyThread rubyThread = action.getTargetThread();
        if (this.context.getEnv().getContext().isEntered() && this.context.getLanguageSlow().getCurrentThread() == rubyThread) {
            if (this.context.getLanguageSlow().getCurrentFiber() != rubyThread.getCurrentFiber()) {
                throw CompilerDirectives.shouldNotReachHere((String)"The currently executing Java thread does not correspond to the currently active fiber for the current Ruby thread");
            }
            action.run(rubyThread, currentNode);
        } else {
            this.pauseAllThreadsAndExecute(currentNode, action);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void pauseAllThreadsAndExecute(Node currentNode, SafepointAction action) {
        Future future = this.context.getEnv().submitThreadLocal(null, (ThreadLocalAction)action);
        if (action.isSynchronous()) {
            TruffleSafepoint.setBlockedThreadInterruptible((Node)currentNode, f -> {
                try {
                    f.get();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }, (Object)future);
        }
    }
}

