/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.kernel.TraceManager;
import org.truffleruby.core.method.RubyMethod;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.debug.RubyScope;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNodeWithExecute;
import org.truffleruby.language.RubyNodeWrapper;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.stdlib.CoverageManager;

@ExportLibrary(value=NodeLibrary.class)
@GenerateWrapper
public abstract class RubyNode
extends RubyBaseNodeWithExecute
implements InstrumentableNode {
    public static final RubyNode[] EMPTY_ARRAY = new RubyNode[0];
    private static final byte FLAG_NEWLINE = 0;
    private static final byte FLAG_COVERAGE_LINE = 1;
    private static final byte FLAG_CALL = 2;
    private static final byte FLAG_ROOT = 3;
    protected static final int NO_SOURCE = -1;
    private static final int UNAVAILABLE_SOURCE_SECTION_LENGTH = -1;

    public abstract Nil executeVoid(VirtualFrame var1);

    public abstract Object isDefined(VirtualFrame var1, RubyLanguage var2, RubyContext var3);

    protected static Object defaultIsDefined(Node currentNode) {
        assert (!(currentNode instanceof InstrumentableNode.WrapperNode));
        return FrozenStrings.EXPRESSION;
    }

    protected abstract int getSourceCharIndex();

    protected abstract void setSourceCharIndex(int var1);

    protected abstract int getSourceLength();

    protected abstract void setSourceLength(int var1);

    public boolean hasSource() {
        return this.isAdoptable() && this.getSourceCharIndex() != -1;
    }

    public void unsafeSetSourceSection(SourceSection sourceSection) {
        assert (!this.hasSource());
        if (sourceSection.isAvailable()) {
            this.unsafeSetSourceSection(sourceSection.getCharIndex(), sourceSection.getCharLength());
        } else {
            this.unsafeSetSourceSection(0, -1);
        }
    }

    public void unsafeSetSourceSection(int charIndex, int sourceLength) {
        assert (!this.hasSource());
        assert (sourceLength != 0 || charIndex != 0);
        this.setSourceCharIndex(charIndex);
        this.setSourceLength(sourceLength);
    }

    public RubyNode copySourceSection(RubyNode from) {
        if (from.hasSource()) {
            this.unsafeSetSourceSection(from.getSourceCharIndex(), from.getSourceLength());
        }
        return this;
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection getSourceSection() {
        if (!this.hasSource()) {
            return null;
        }
        Source source = this.getSource();
        if (source == null) {
            return null;
        }
        int sourceLength = this.getSourceLength();
        if (sourceLength == -1) {
            return source.createUnavailableSection();
        }
        return source.createSection(this.getSourceCharIndex(), sourceLength);
    }

    private Source getSource() {
        RootNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return null;
        }
        SourceSection sourceSection = rootNode.getSourceSection();
        if (sourceSection == null) {
            return null;
        }
        return sourceSection.getSource();
    }

    public String toString() {
        return super.toString() + " at " + RubyLanguage.fileLineRange(this.getSourceSection());
    }

    public boolean isInstrumentable() {
        return this.hasSource();
    }

    protected abstract byte getFlags();

    protected abstract void setFlags(byte var1);

    private void setFlag(byte flag) {
        this.setFlags((byte)(this.getFlags() | 1 << flag));
    }

    public void unsafeSetIsNewLine() {
        this.setFlag((byte)0);
    }

    public void unsafeSetIsCoverageLine() {
        this.setFlag((byte)1);
    }

    public void unsafeSetIsCall() {
        this.setFlag((byte)2);
    }

    public void unsafeSetIsRoot() {
        this.setFlag((byte)3);
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        byte flags = this.getFlags();
        if (tag == TraceManager.CallTag.class) {
            return RubyNode.isTag(flags, (byte)2);
        }
        if (tag == TraceManager.LineTag.class || tag == StandardTags.StatementTag.class) {
            return RubyNode.isTag(flags, (byte)0);
        }
        if (tag == CoverageManager.LineTag.class) {
            return RubyNode.isTag(flags, (byte)1);
        }
        if (tag == StandardTags.RootTag.class) {
            return RubyNode.isTag(flags, (byte)3);
        }
        return false;
    }

    private static boolean isTag(byte flags, byte flag) {
        return (flags >> flag & 1) == 1;
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new RubyNodeWrapper(this, probe);
    }

    public static RubyNode unwrapNode(RubyNode node) {
        if (node instanceof InstrumentableNode.WrapperNode) {
            InstrumentableNode.WrapperNode wrapperNode = (InstrumentableNode.WrapperNode)node;
            return (RubyNode)wrapperNode.getDelegateNode();
        }
        return node;
    }

    public boolean isContinuable() {
        return true;
    }

    public boolean canSubsumeFollowing() {
        return false;
    }

    public RubyNode subsumeFollowing(RubyNode following) {
        throw new UnsupportedOperationException();
    }

    public RubyNode simplifyAsTailExpression() {
        return this;
    }

    @ExportMessage
    boolean accepts(@Cached(value="this", adopt=false) RubyNode cachedNode) {
        return this == cachedNode;
    }

    @ExportMessage
    final boolean hasScope(Frame frame) {
        return this.getParent() != null;
    }

    @ExportMessage
    final Object getScope(Frame frame, boolean nodeEnter, @CachedLibrary(value="this") NodeLibrary node) throws UnsupportedMessageException {
        if (this.hasScope(frame)) {
            return new RubyScope(RubyContext.get((Node)node), RubyLanguage.get((Node)node), frame.materialize(), this);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    final boolean hasReceiverMember(Frame frame) {
        return frame != null;
    }

    @ExportMessage
    final Object getReceiverMember(Frame frame) throws UnsupportedMessageException {
        if (frame == null) {
            throw UnsupportedMessageException.create();
        }
        return "self";
    }

    @ExportMessage
    boolean hasRootInstance(Frame frame) {
        return frame != null;
    }

    @ExportMessage
    Object getRootInstance(Frame frame, @CachedLibrary(value="this") NodeLibrary node) throws UnsupportedMessageException {
        if (frame == null) {
            throw UnsupportedMessageException.create();
        }
        Object self = RubyArguments.getSelf(frame);
        InternalMethod method = RubyArguments.getMethod(frame);
        return new RubyMethod(RubyContext.get((Node)node).getCoreLibrary().methodClass, RubyLanguage.get((Node)node).methodShape, self, method);
    }

    @Override
    public abstract RubyNode cloneUninitialized();

    public static RubyNode cloneUninitialized(RubyNode node) {
        return node == null ? null : node.cloneUninitialized();
    }

    protected static RubyNode[] cloneUninitialized(RubyNode[] nodes) {
        if (nodes == null) {
            return null;
        }
        RubyNode[] copies = new RubyNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            copies[i] = nodes[i].cloneUninitialized();
        }
        return copies;
    }
}

