/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.TriState;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.cast.IntegerCastNode;
import org.truffleruby.core.cast.LongCastNode;
import org.truffleruby.core.cast.ToLongNode;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.interop.ForeignToRubyArgumentsNode;
import org.truffleruby.interop.TranslateInteropRubyExceptionNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.InternalRespondToNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.methods.GetMethodObjectNode;
import org.truffleruby.language.objects.IsANode;
import org.truffleruby.language.objects.IsFrozenNode;
import org.truffleruby.language.objects.LogicalClassNode;
import org.truffleruby.language.objects.WriteObjectFieldNode;
import org.truffleruby.language.objects.shared.SharedObjects;

@ExportLibrary(value=InteropLibrary.class)
public abstract class RubyDynamicObject
extends DynamicObject {
    private RubyClass metaClass;

    public RubyDynamicObject(RubyClass metaClass, Shape shape) {
        super(shape);
        assert (metaClass != null);
        this.metaClass = metaClass;
    }

    protected RubyDynamicObject(Shape classShape, String constructorOnlyForClassClass) {
        super(classShape);
        this.metaClass = (RubyClass)this;
    }

    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(RubyClass metaClass) {
        SharedObjects.assertPropagateSharing(this, metaClass);
        this.metaClass = metaClass;
    }

    public final RubyClass getLogicalClass() {
        return this.metaClass.nonSingletonClass;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        String className = this.getLogicalClass().fields.getName();
        return StringUtils.format("%s@%x<%s>", ((Object)((Object)this)).getClass().getSimpleName(), System.identityHashCode((Object)this), className);
    }

    @ExportMessage
    public boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    public Class<RubyLanguage> getLanguage() {
        return RubyLanguage.class;
    }

    @ExportMessage
    public Object toDisplayString(boolean allowSideEffects, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached RubyStringLibrary libString, @Cached KernelNodes.ToSNode kernelToSNode) {
        if (allowSideEffects) {
            Object inspect = dispatchNode.call((Object)this, "inspect");
            if (libString.isRubyString(inspect)) {
                return inspect;
            }
            return kernelToSNode.execute((Object)this);
        }
        return kernelToSNode.execute((Object)this);
    }

    @ExportMessage
    public int identityHashCode() {
        return System.identityHashCode((Object)this);
    }

    @ExportMessage
    public TriState isIdenticalOrUndefined(Object other, @Cached @Cached.Exclusive ConditionProfile rubyObjectProfile) {
        if (rubyObjectProfile.profile(other instanceof RubyDynamicObject)) {
            return TriState.valueOf((this == other ? 1 : 0) != 0);
        }
        return TriState.UNDEFINED;
    }

    @ExportMessage
    public boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    public RubyClass getMetaObject(@Cached LogicalClassNode classNode) {
        return classNode.execute((Object)this);
    }

    @ExportMessage
    public boolean hasArrayElements(@Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_has_array_elements?");
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public long getArraySize(@Cached IntegerCastNode integerCastNode, @Cached @Cached.Shared BranchProfile errorProfile, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Bind(value="$node") Node node) throws UnsupportedMessageException {
        Object value;
        try {
            value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_array_size");
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e);
        }
        if (value == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnsupportedMessageException.create();
        }
        return integerCastNode.execute(node, value);
    }

    @ExportMessage
    public Object readArrayElement(long index, @Cached @Cached.Shared BranchProfile errorProfile, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Exclusive DispatchNode dispatchNode) throws InvalidArrayIndexException, UnsupportedMessageException {
        try {
            Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_read_array_element", (Object)index);
            if (value == DispatchNode.MISSING) {
                errorProfile.enter();
                throw UnsupportedMessageException.create();
            }
            return value;
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e, index);
        }
    }

    @ExportMessage
    public void writeArrayElement(long index, Object value, @Cached @Cached.Shared BranchProfile errorProfile, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Exclusive DispatchNode dispatchNode) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
        try {
            Object result = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_write_array_element", (Object)index, value);
            if (result == DispatchNode.MISSING) {
                errorProfile.enter();
                throw UnsupportedMessageException.create();
            }
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e, index, value);
        }
    }

    @ExportMessage
    public void removeArrayElement(long index, @Cached @Cached.Shared BranchProfile errorProfile, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Exclusive DispatchNode dispatchNode) throws UnsupportedMessageException, InvalidArrayIndexException {
        try {
            Object result = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_remove_array_element", (Object)index);
            if (result == DispatchNode.MISSING) {
                errorProfile.enter();
                throw UnsupportedMessageException.create();
            }
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e, index);
        }
    }

    @ExportMessage
    public boolean isArrayElementReadable(long index, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_array_element_readable?", (Object)index);
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public boolean isArrayElementModifiable(long index, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_array_element_modifiable?", (Object)index);
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public boolean isArrayElementInsertable(long index, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_array_element_insertable?", (Object)index);
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public boolean isArrayElementRemovable(long index, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_array_element_removable?", (Object)index);
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public boolean hasHashEntries(@Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_has_hash_entries?");
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public long getHashSize(@Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared BranchProfile errorProfile, @Cached @Cached.Exclusive ToLongNode toInt, @Bind(value="$node") Node node) throws UnsupportedMessageException {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_hash_size");
        if (value == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnsupportedMessageException.create();
        }
        return toInt.execute(node, value);
    }

    @ExportMessage
    public boolean isHashEntryReadable(Object key, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_hash_entry_readable?", key);
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public boolean isHashEntryModifiable(Object key, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_hash_entry_modifiable?", key);
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public boolean isHashEntryInsertable(Object key, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_hash_entry_insertable?", key);
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public boolean isHashEntryRemovable(Object key, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_hash_entry_removable?", key);
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public Object readHashValue(Object key, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Shared BranchProfile errorProfile) throws UnsupportedMessageException, UnknownKeyException {
        Object value;
        try {
            value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_read_hash_entry", key);
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e, key);
        }
        if (value == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnsupportedMessageException.create();
        }
        return value;
    }

    @ExportMessage
    public void writeHashEntry(Object key, Object value, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Shared BranchProfile errorProfile) throws UnsupportedMessageException, UnknownKeyException {
        Object result;
        try {
            result = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_write_hash_entry", key, value);
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e, key);
        }
        if (result == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    public void removeHashEntry(Object key, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Shared BranchProfile errorProfile) throws UnsupportedMessageException, UnknownKeyException {
        Object result;
        try {
            result = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_remove_hash_entry", key);
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e, key);
        }
        if (result == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    public Object getHashEntriesIterator(@Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared BranchProfile errorProfile) throws UnsupportedMessageException {
        Object result = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_hash_entries_iterator");
        if (result == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnsupportedMessageException.create();
        }
        return result;
    }

    @ExportMessage
    public Object getHashKeysIterator(@Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared BranchProfile errorProfile) throws UnsupportedMessageException {
        Object result = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_hash_keys_iterator");
        if (result == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnsupportedMessageException.create();
        }
        return result;
    }

    @ExportMessage
    public Object getHashValuesIterator(@Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared BranchProfile errorProfile) throws UnsupportedMessageException {
        Object result = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_hash_values_iterator");
        if (result == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnsupportedMessageException.create();
        }
        return result;
    }

    @ExportMessage
    public boolean hasIterator(@CachedLibrary(value="this") InteropLibrary node, @Cached @Cached.Exclusive IsANode isANode) {
        return isANode.executeIsA((Object)this, RubyContext.get((Node)node).getCoreLibrary().enumerableModule);
    }

    @ExportMessage
    public Object getIterator(@CachedLibrary(value="this") InteropLibrary interopLibrary, @CachedLibrary(value="this") InteropLibrary node, @Cached @Cached.Exclusive DispatchNode dispatchNode) throws UnsupportedMessageException {
        if (!interopLibrary.hasIterator((Object)this)) {
            throw UnsupportedMessageException.create();
        }
        RubyContext context = RubyContext.get((Node)node);
        return dispatchNode.call((Object)context.getCoreLibrary().truffleInteropOperationsModule, "get_iterator", (Object)this);
    }

    @ExportMessage
    public boolean isIterator(@CachedLibrary(value="this") InteropLibrary node, @Cached @Cached.Exclusive IsANode isANode) {
        return isANode.executeIsA((Object)this, RubyContext.get((Node)node).getCoreLibrary().enumeratorClass);
    }

    @ExportMessage
    public boolean hasIteratorNextElement(@CachedLibrary(value="this") InteropLibrary interopLibrary, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) throws UnsupportedMessageException {
        if (!interopLibrary.isIterator((Object)this)) {
            throw UnsupportedMessageException.create();
        }
        return booleanCastNode.execute(node, dispatchNode.call((Object)RubyContext.get((Node)node).getCoreLibrary().truffleInteropOperationsModule, "enumerator_has_next?", (Object)this));
    }

    @ExportMessage
    public Object getIteratorNextElement(@CachedLibrary(value="this") InteropLibrary interopLibrary, @CachedLibrary(value="this") InteropLibrary node, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive IsANode isANode, @Cached @Cached.Exclusive ConditionProfile stopIterationProfile) throws UnsupportedMessageException, StopIterationException {
        if (!interopLibrary.isIterator((Object)this)) {
            throw UnsupportedMessageException.create();
        }
        try {
            return dispatchNode.call((Object)this, "next");
        }
        catch (RaiseException e) {
            RubyContext context = RubyContext.get((Node)node);
            if (stopIterationProfile.profile(isANode.executeIsA(e.getException(), context.getCoreLibrary().stopIterationClass))) {
                throw StopIterationException.create((Throwable)((Object)e));
            }
            throw e;
        }
    }

    @ExportMessage
    public boolean isPointer(@Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_pointer?");
        return value != DispatchNode.MISSING && booleanCastNode.execute(node, value);
    }

    @ExportMessage
    public long asPointer(@Cached @Cached.Shared BranchProfile errorProfile, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached LongCastNode longCastNode, @Bind(value="$node") Node node) throws UnsupportedMessageException {
        Object value;
        try {
            value = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_as_pointer");
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e);
        }
        if (value == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnsupportedMessageException.create();
        }
        return longCastNode.executeCastLong(node, value);
    }

    @ExportMessage
    public void toNative(@Cached @Cached.Shared BranchProfile errorProfile, @Cached @Cached.Exclusive DispatchNode dispatchNode) {
        dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_to_native");
    }

    @ExportMessage
    public boolean hasMembers(@Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_has_members?");
        return dynamic == DispatchNode.MISSING || booleanCastNode.execute(node, dynamic);
    }

    @ExportMessage
    public Object getMembers(boolean internal, @CachedLibrary(value="this") InteropLibrary node, @Cached @Cached.Exclusive DispatchNode dispatchNode) {
        return dispatchNode.call(RubyContext.get((Node)node).getCoreLibrary().truffleInteropModule, "get_members_implementation", (Object)this, (Object)internal);
    }

    private static boolean isIVar(String name) {
        return !name.isEmpty() && name.charAt(0) == '@';
    }

    @ExportMessage
    public Object readMember(String name, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary, @Cached @Cached.Shared InternalRespondToNode definedNode, @Cached GetMethodObjectNode getMethodObjectNode, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Cached @Cached.Shared ConditionProfile ivarFoundProfile, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Shared BranchProfile errorProfile) throws UnknownIdentifierException, UnsupportedMessageException {
        Object dynamic;
        try {
            dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_read_member", (Object)name);
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e, name);
        }
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            Object iVar = objectLibrary.getOrDefault((DynamicObject)this, (Object)name, null);
            if (ivarFoundProfile.profile(iVar != null)) {
                return iVar;
            }
            if (definedNode.execute(null, (Object)this, name)) {
                return getMethodObjectNode.execute(null, (Object)this, name, DispatchConfiguration.PRIVATE);
            }
            errorProfile.enter();
            throw UnknownIdentifierException.create((String)name);
        }
        return dynamic;
    }

    @ExportMessage
    public void writeMember(String name, Object value, @Cached WriteObjectFieldNode writeObjectFieldNode, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared IsFrozenNode isFrozenNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Shared BranchProfile errorProfile, @Bind(value="$node") Node node) throws UnknownIdentifierException, UnsupportedMessageException {
        Object dynamic;
        try {
            dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_write_member", (Object)name, value);
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e, name);
        }
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            if (isFrozenNode.execute((Object)this)) {
                errorProfile.enter();
                throw UnsupportedMessageException.create();
            }
            if (RubyDynamicObject.isIVar(name)) {
                writeObjectFieldNode.execute(node, this, name, value);
            } else {
                errorProfile.enter();
                throw UnknownIdentifierException.create((String)name);
            }
        }
    }

    @ExportMessage
    public void removeMember(String name, @Cached @Cached.Exclusive DispatchNode removeInstanceVariableNode, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Shared BranchProfile errorProfile, @CachedLibrary(value="this") InteropLibrary interopLibrary) throws UnknownIdentifierException, UnsupportedMessageException {
        Object dynamic;
        try {
            dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_remove_member", (Object)name);
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e, name);
        }
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            if (!interopLibrary.isMemberRemovable((Object)this, name)) {
                errorProfile.enter();
                throw UnknownIdentifierException.create((String)name);
            }
            try {
                removeInstanceVariableNode.call((Object)this, "remove_instance_variable", (Object)name);
            }
            catch (RaiseException e) {
                errorProfile.enter();
                throw UnknownIdentifierException.create((String)name, (Throwable)((Object)e));
            }
        }
    }

    @ExportMessage
    public Object invokeMember(String name, Object[] arguments, @Cached @Cached.Exclusive DispatchNode dispatchDynamic, @Cached @Cached.Exclusive DispatchNode dispatchMember, @Cached @Cached.Exclusive ForeignToRubyArgumentsNode foreignToRubyArgumentsNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Cached @Cached.Shared TranslateInteropRubyExceptionNode translateRubyException, @Cached @Cached.Shared BranchProfile errorProfile, @Bind(value="$node") Node node) throws UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException, ArityException {
        Object dynamic;
        Object[] convertedArguments = foreignToRubyArgumentsNode.executeConvert(node, arguments);
        Object[] combinedArguments = ArrayUtils.unshift(convertedArguments, name);
        try {
            dynamic = dispatchDynamic.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_invoke_member", combinedArguments);
        }
        catch (RaiseException e) {
            throw translateRubyException.execute(e, name, arguments);
        }
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            Object result = dispatchMember.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, name, convertedArguments);
            if (result == DispatchNode.MISSING) {
                errorProfile.enter();
                throw UnknownIdentifierException.create((String)name);
            }
            return result;
        }
        return dynamic;
    }

    @ExportMessage
    public boolean isMemberReadable(String name, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary, @Cached @Cached.Shared InternalRespondToNode definedNode, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Cached @Cached.Shared ConditionProfile ivarFoundProfile, @Bind(value="$node") Node node) {
        Object dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_member_readable?", (Object)name);
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            if (ivarFoundProfile.profile(objectLibrary.containsKey((DynamicObject)this, (Object)name))) {
                return true;
            }
            return definedNode.execute(null, (Object)this, name);
        }
        return booleanCastNode.execute(node, dynamic);
    }

    @ExportMessage
    public boolean isMemberModifiable(String name, @Cached @Cached.Shared IsFrozenNode isFrozenNode, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Bind(value="$node") Node node) {
        Object dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_member_modifiable?", (Object)name);
        return this.isMemberModifiableRemovable(node, dynamic, name, isFrozenNode, objectLibrary, booleanCastNode, dynamicProfile);
    }

    @ExportMessage
    public boolean isMemberRemovable(String name, @Cached @Cached.Shared IsFrozenNode isFrozenNode, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Bind(value="$node") Node node) {
        Object dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_member_removable?", (Object)name);
        return this.isMemberModifiableRemovable(node, dynamic, name, isFrozenNode, objectLibrary, booleanCastNode, dynamicProfile);
    }

    private boolean isMemberModifiableRemovable(Node node, Object dynamic, String name, IsFrozenNode isFrozenNode, DynamicObjectLibrary objectLibrary, BooleanCastNode booleanCastNode, ConditionProfile dynamicProfile) {
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            if (isFrozenNode.execute((Object)this)) {
                return false;
            }
            return objectLibrary.containsKey((DynamicObject)this, (Object)name);
        }
        return booleanCastNode.execute(node, dynamic);
    }

    @ExportMessage
    public boolean isMemberInsertable(String name, @Cached @Cached.Shared IsFrozenNode isFrozenNode, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Bind(value="$node") Node node) {
        Object dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_member_insertable?", (Object)name);
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            if (isFrozenNode.execute((Object)this) || !RubyDynamicObject.isIVar(name)) {
                return false;
            }
            return !objectLibrary.containsKey((DynamicObject)this, (Object)name);
        }
        return booleanCastNode.execute(node, dynamic);
    }

    @ExportMessage
    public boolean isMemberInvocable(String name, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary, @Cached @Cached.Shared InternalRespondToNode definedNode, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Cached @Cached.Shared ConditionProfile ivarFoundProfile, @Bind(value="$node") Node node) {
        Object dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_member_invocable?", (Object)name);
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            Object iVar = objectLibrary.getOrDefault((DynamicObject)this, (Object)name, null);
            if (ivarFoundProfile.profile(iVar != null)) {
                return false;
            }
            return definedNode.execute(null, (Object)this, name);
        }
        return booleanCastNode.execute(node, dynamic);
    }

    @ExportMessage
    public boolean isMemberInternal(String name, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary, @Cached @Cached.Shared InternalRespondToNode definedNode, @Cached(parameters={"PUBLIC"}) @Cached.Exclusive InternalRespondToNode definedPublicNode, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Cached @Cached.Shared ConditionProfile ivarFoundProfile, @Bind(value="$node") Node node) {
        Object dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_member_internal?", (Object)name);
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            Object result = objectLibrary.getOrDefault((DynamicObject)this, (Object)name, null);
            if (ivarFoundProfile.profile(result != null)) {
                return true;
            }
            return definedNode.execute(null, (Object)this, name) && !definedPublicNode.execute(null, (Object)this, name);
        }
        return booleanCastNode.execute(node, dynamic);
    }

    @ExportMessage
    public boolean hasMemberReadSideEffects(String name, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_has_member_read_side_effects?", (Object)name);
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            return false;
        }
        return booleanCastNode.execute(node, dynamic);
    }

    @ExportMessage
    public boolean hasMemberWriteSideEffects(String name, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Shared ConditionProfile dynamicProfile, @Cached @Cached.Exclusive BooleanCastNode booleanCastNode, @Bind(value="$node") Node node) {
        Object dynamic = dispatchNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, "polyglot_has_member_write_side_effects?", (Object)name);
        if (dynamicProfile.profile(dynamic == DispatchNode.MISSING)) {
            return false;
        }
        return booleanCastNode.execute(node, dynamic);
    }

    @ExportMessage
    public boolean isInstantiable(@Cached(parameters={"PUBLIC"}) @Cached.Exclusive InternalRespondToNode doesRespond) {
        return doesRespond.execute(null, (Object)this, "new");
    }

    @ExportMessage
    public Object instantiate(Object[] arguments, @Cached @Cached.Shared BranchProfile errorProfile, @Cached @Cached.Exclusive DispatchNode dispatchNode, @Cached @Cached.Exclusive ForeignToRubyArgumentsNode foreignToRubyArgumentsNode, @Bind(value="$node") Node node) throws UnsupportedMessageException {
        Object instance = dispatchNode.call(DispatchConfiguration.PUBLIC_RETURN_MISSING, (Object)this, "new", foreignToRubyArgumentsNode.executeConvert(node, arguments));
        if (instance == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnsupportedMessageException.create();
        }
        return instance;
    }
}

