/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.truffleruby.RubyContext;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.globals.ReadSimpleGlobalVariableNode;

public abstract class PerformanceWarningNode
extends RubyBaseNode {
    @Node.Child
    ReadSimpleGlobalVariableNode readVerboseNode = ReadSimpleGlobalVariableNode.create("$VERBOSE");
    private static final Set<String> DISPLAYED_WARNINGS = ConcurrentHashMap.newKeySet();

    public final void warn(String message) {
        this.executeWarn(message);
    }

    protected abstract void executeWarn(String var1);

    @Specialization(rewriteOn={Warned.class})
    void warnOnce(String message) throws Warned {
        CompilerAsserts.partialEvaluationConstant((Object)message);
        if (this.readVerboseNode.execute() == nil) {
            return;
        }
        if (!((Boolean)this.getContext().getWarningCategoryPerformance().get()).booleanValue()) {
            return;
        }
        PerformanceWarningNode.log(this.getContext(), message, this);
        throw new Warned();
    }

    @Specialization(replaces={"warnOnce"})
    void doNotWarn(String message) {
    }

    @CompilerDirectives.TruffleBoundary
    public static void warn(RubyContext context, String message, Node currentNode) {
        if (!context.getCoreLibrary().warningsEnabled()) {
            return;
        }
        if (!((Boolean)context.getWarningCategoryPerformance().get()).booleanValue()) {
            return;
        }
        PerformanceWarningNode.log(context, message, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    private static void log(RubyContext context, String message, Node currentNode) {
        SourceSection userSourceSection = context.getCallStack().getTopMostUserSourceSection(currentNode.getEncapsulatingSourceSection());
        String displayedWarning = String.format("%s: warning: %s%n", context.fileLine(userSourceSection), message);
        if (DISPLAYED_WARNINGS.add(displayedWarning)) {
            RubyString messageString = PerformanceWarningNode.createString(currentNode, TruffleString.FromJavaStringNode.getUncached(), displayedWarning, Encodings.US_ASCII);
            RubyModule warningModule = context.getCoreLibrary().truffleWarningOperationsModule;
            RubyContext.send(currentNode, warningModule, "performance_warning", new Object[]{messageString});
        }
    }

    protected static final class Warned
    extends ControlFlowException {
        protected Warned() {
        }
    }
}

