/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.TriState;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.cext.ValueWrapper;
import org.truffleruby.interop.ForeignToRubyArgumentsNode;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.InternalRespondToNode;
import org.truffleruby.language.methods.GetMethodObjectNode;

@ExportLibrary(value=InteropLibrary.class)
public abstract class ImmutableRubyObject
implements TruffleObject {
    protected ValueWrapper valueWrapper;
    protected long objectId;

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public ValueWrapper getValueWrapper() {
        return this.valueWrapper;
    }

    public void setValueWrapper(ValueWrapper valueWrapper) {
        this.valueWrapper = valueWrapper;
    }

    @ExportMessage
    public boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    public Class<RubyLanguage> getLanguage() {
        return RubyLanguage.class;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public String toDisplayString(boolean allowSideEffects) {
        throw new AbstractMethodError();
    }

    @ExportMessage
    public int identityHashCode() {
        return System.identityHashCode(this);
    }

    @ExportMessage
    public TriState isIdenticalOrUndefined(Object other, @Cached @Cached.Exclusive ConditionProfile immutableRubyObjectProfile) {
        if (immutableRubyObjectProfile.profile(other instanceof ImmutableRubyObject)) {
            return TriState.valueOf((this == other ? 1 : 0) != 0);
        }
        return TriState.UNDEFINED;
    }

    @ExportMessage
    public boolean hasMembers() {
        return true;
    }

    @ExportMessage
    public Object getMembers(boolean internal, @CachedLibrary(value="this") InteropLibrary node, @Cached @Cached.Exclusive DispatchNode dispatchNode) {
        return dispatchNode.call(RubyContext.get((Node)node).getCoreLibrary().truffleInteropModule, "get_members_implementation", this, (Object)internal);
    }

    @ExportMessage
    public boolean isMemberReadable(String name, @Cached @Cached.Shared InternalRespondToNode definedNode) {
        return definedNode.execute(null, this, name);
    }

    @ExportMessage
    public Object readMember(String name, @Cached @Cached.Shared InternalRespondToNode definedNode, @Cached GetMethodObjectNode getMethodObjectNode, @Cached @Cached.Shared BranchProfile errorProfile) throws UnknownIdentifierException {
        if (definedNode.execute(null, this, name)) {
            return getMethodObjectNode.execute(null, this, name, DispatchConfiguration.PRIVATE);
        }
        errorProfile.enter();
        throw UnknownIdentifierException.create((String)name);
    }

    @ExportMessage
    public boolean isMemberInvocable(String name, @Cached @Cached.Shared InternalRespondToNode definedNode) {
        return definedNode.execute(null, this, name);
    }

    @ExportMessage
    public Object invokeMember(String name, Object[] arguments, @Cached @Cached.Exclusive DispatchNode dispatchMember, @Cached @Cached.Exclusive ForeignToRubyArgumentsNode foreignToRubyArgumentsNode, @Cached @Cached.Shared BranchProfile errorProfile, @Bind(value="$node") Node node) throws UnknownIdentifierException {
        Object[] convertedArguments = foreignToRubyArgumentsNode.executeConvert(node, arguments);
        Object result = dispatchMember.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, (Object)this, name, convertedArguments);
        if (result == DispatchNode.MISSING) {
            errorProfile.enter();
            throw UnknownIdentifierException.create((String)name);
        }
        return result;
    }

    @ExportMessage
    public boolean isMemberInternal(String name, @Cached @Cached.Shared InternalRespondToNode definedNode, @Cached(parameters={"PUBLIC"}) @Cached.Exclusive InternalRespondToNode definedPublicNode) {
        return definedNode.execute(null, this, name) && !definedPublicNode.execute(null, this, name);
    }
}

