/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.DispatchNode;

public final class DataNode
extends RubyContextSourceNode {
    @Node.Child
    private TruffleString.FromJavaStringNode fromJavaStringNode;
    @Node.Child
    private DispatchNode callHelperNode;
    private final int endPosition;

    public DataNode(int endPosition) {
        this.endPosition = endPosition;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.fromJavaStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.fromJavaStringNode = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
        }
        if (this.callHelperNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callHelperNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        String path = this.getPath();
        RubyEncoding rubyLocaleEncoding = this.getContext().getEncodingManager().getLocaleEncoding();
        RubyString pathString = this.createString(this.fromJavaStringNode, path, rubyLocaleEncoding);
        Object data = this.callHelperNode.call(this.coreLibrary().truffleInternalModule, "get_data", (Object)pathString, (Object)this.endPosition);
        this.coreLibrary().objectClass.fields.setConstant(this.getContext(), null, "DATA", data);
        return nil;
    }

    @CompilerDirectives.TruffleBoundary
    private String getPath() {
        return this.getLanguage().getSourcePath(this.getEncapsulatingSourceSection().getSource());
    }

    @Override
    public RubyNode cloneUninitialized() {
        DataNode copy = new DataNode(this.endPosition);
        return copy.copyFlags(this);
    }
}

