/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.interop.TranslateInteropExceptionNodeGen;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class TranslateInteropExceptionNode
extends RubyBaseNode {
    public final RuntimeException execute(Node node, InteropException exception) {
        return this.execute(node, exception, false, null, null);
    }

    public final RuntimeException executeInInvokeMember(Node node, InteropException exception, Object receiver, Object[] args) {
        return this.execute(node, exception, true, receiver, args);
    }

    public static RuntimeException executeUncached(InteropException exception) {
        return TranslateInteropExceptionNodeGen.getUncached().execute(null, exception, false, null, null);
    }

    protected abstract RuntimeException execute(Node var1, InteropException var2, boolean var3, Object var4, Object[] var5);

    @Specialization
    static RuntimeException handle(Node node, UnsupportedMessageException exception, boolean inInvokeMember, Object receiver, Object[] args) {
        return new RaiseException(TranslateInteropExceptionNode.getContext(node), TranslateInteropExceptionNode.coreExceptions(node).unsupportedMessageError(exception.getMessage(), node), exception);
    }

    @Specialization
    static RuntimeException handle(Node node, InvalidArrayIndexException exception, boolean inInvokeMember, Object receiver, Object[] args) {
        return new RaiseException(TranslateInteropExceptionNode.getContext(node), TranslateInteropExceptionNode.coreExceptions(node).indexErrorInvalidArrayIndexException(exception, node), exception);
    }

    @Specialization
    static RuntimeException handle(Node node, InvalidBufferOffsetException exception, boolean inInvokeMember, Object receiver, Object[] args) {
        return new RaiseException(TranslateInteropExceptionNode.getContext(node), TranslateInteropExceptionNode.coreExceptions(node).indexErrorInvalidBufferOffsetException(exception, node), (Throwable)exception);
    }

    @Specialization
    static RuntimeException handle(Node node, UnknownKeyException exception, boolean inInvokeMember, Object receiver, Object[] args) {
        return new RaiseException(TranslateInteropExceptionNode.getContext(node), TranslateInteropExceptionNode.coreExceptions(node).keyError(exception, node), (Throwable)exception);
    }

    @Specialization
    static RuntimeException handle(Node node, UnknownIdentifierException exception, boolean inInvokeMember, Object receiver, Object[] args) {
        if (inInvokeMember) {
            return new RaiseException(TranslateInteropExceptionNode.getContext(node), TranslateInteropExceptionNode.coreExceptions(node).noMethodErrorUnknownIdentifier(receiver, exception.getUnknownIdentifier(), args, exception, node), exception);
        }
        return new RaiseException(TranslateInteropExceptionNode.getContext(node), TranslateInteropExceptionNode.coreExceptions(node).nameErrorUnknownIdentifierException(exception, receiver, node), exception);
    }

    @Specialization
    static RuntimeException handle(Node node, UnsupportedTypeException exception, boolean inInvokeMember, Object receiver, Object[] args) {
        return new RaiseException(TranslateInteropExceptionNode.getContext(node), TranslateInteropExceptionNode.coreExceptions(node).typeErrorUnsupportedTypeException(exception, node), (Throwable)exception);
    }

    @Specialization
    static RuntimeException handle(Node node, ArityException exception, boolean inInvokeMember, Object receiver, Object[] args) {
        return new RaiseException(TranslateInteropExceptionNode.getContext(node), TranslateInteropExceptionNode.coreExceptions(node).argumentErrorMinMaxArity(exception.getActualArity(), exception.getExpectedMinArity(), exception.getExpectedMaxArity(), node), (Throwable)exception);
    }

    @Specialization
    static RuntimeException handle(Node node, StopIterationException exception, boolean inInvokeMember, Object receiver, Object[] args) {
        return new RaiseException(TranslateInteropExceptionNode.getContext(node), TranslateInteropExceptionNode.coreExceptions(node).stopIteration(exception.getMessage(), node), (Throwable)exception);
    }
}

