/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.interop.FromJavaStringNodeGen;
import org.truffleruby.language.RubyBaseNode;

@GenerateInline
@GenerateCached(value=false)
@GenerateUncached
@ReportPolymorphism
public abstract class FromJavaStringNode
extends RubyBaseNode {
    public abstract RubyString executeFromJavaString(Node var1, String var2);

    public static RubyString executeUncached(String value) {
        return FromJavaStringNodeGen.getUncached().executeFromJavaString(null, value);
    }

    @Specialization(guards={"stringsEquals(cachedValue, value)"}, limit="getLimit()")
    static RubyString doCached(Node node, String value, @Cached(value="value") String cachedValue, @Cached(inline=false) @Cached.Shared TruffleString.FromJavaStringNode tstringFromJavaStringNode, @Cached(value="getTString(cachedValue, tstringFromJavaStringNode)") TruffleString cachedTString) {
        RubyString rubyString = FromJavaStringNode.createString(node, cachedTString, Encodings.UTF_8);
        rubyString.freeze();
        return rubyString;
    }

    @Specialization(replaces={"doCached"})
    static RubyString doGeneric(Node node, String value, @Cached(inline=false) @Cached.Shared TruffleString.FromJavaStringNode tstringFromJavaStringNode) {
        RubyString rubyString = FromJavaStringNode.createString(node, tstringFromJavaStringNode, value, Encodings.UTF_8);
        rubyString.freeze();
        return rubyString;
    }

    protected static boolean stringsEquals(String a, String b) {
        return a.equals(b);
    }

    protected static TruffleString getTString(String value, TruffleString.FromJavaStringNode tstringFromJavaStringNode) {
        return tstringFromJavaStringNode.execute(value, TruffleString.Encoding.UTF_8);
    }

    protected int getLimit() {
        return this.getLanguage().options.INTEROP_CONVERT_CACHE;
    }
}

