/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.language.control.RaiseException;

@ExportLibrary(value=ReflectionLibrary.class)
public final class BoxedValue
implements TruffleObject {
    private static final Message READ_MEMBER = Message.resolve(InteropLibrary.class, (String)"readMember");
    private static final Message INVOKE_MEMBER = Message.resolve(InteropLibrary.class, (String)"invokeMember");
    private final Object value;

    public BoxedValue(Object value) {
        this.value = value;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    protected Object send(Message message, Object[] args, @CachedLibrary(value="this") ReflectionLibrary node) throws Exception {
        if (message == READ_MEMBER || message == INVOKE_MEMBER) {
            RubyContext context = RubyContext.get((Node)node);
            throw new RaiseException(context, context.getCoreExceptions().unsupportedMessageError("Methods should not be called on a BoxedValue as that would expose the potential Ruby object behind rather than relying on interop messages", (Node)node));
        }
        ReflectionLibrary reflection = (ReflectionLibrary)ReflectionLibrary.getFactory().getUncached();
        return reflection.send(this.value, message, args);
    }
}

