/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.extra.ffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.lang.ref.Cleaner;
import java.lang.reflect.Field;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.core.thread.ThreadLocalBuffer;
import org.truffleruby.language.control.RaiseException;
import sun.misc.Unsafe;

@ExportLibrary(value=InteropLibrary.class)
public final class Pointer
implements AutoCloseable,
TruffleObject {
    private static final Pointer NULL = new Pointer();
    private static final ThreadLocalBuffer NULL_BUFFER = new ThreadLocalBuffer(NULL, null);
    public static final long SIZE = 8L;
    public static final long UNBOUNDED = Long.MAX_VALUE;
    public static final Pointer[] EMPTY_ARRAY = new Pointer[0];
    private final long address;
    private final long size;
    private Cleaner.Cleanable cleanable = null;
    private AutoReleaseState autoReleaseState = null;
    private static final Unsafe UNSAFE = Pointer.getUnsafe();

    public static void checkNativeAccess(RubyContext context) {
        if (!context.getOptions().NATIVE_PLATFORM) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new RaiseException(context, context.getCoreExceptions().securityError("native access is not allowed", null));
        }
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"})
    public static Pointer getNullPointer(RubyContext context) {
        Pointer.checkNativeAccess(context);
        return NULL;
    }

    public static ThreadLocalBuffer getNullBuffer(RubyContext context) {
        Pointer.checkNativeAccess(context);
        return NULL_BUFFER;
    }

    public static Pointer malloc(RubyContext context, long size) {
        Pointer.checkNativeAccess(context);
        return new Pointer(context, UNSAFE.allocateMemory(size), size);
    }

    public static Pointer mallocAutoRelease(RubyLanguage language, RubyContext context, long size) {
        Pointer.checkNativeAccess(context);
        return new Pointer(language, context, UNSAFE.allocateMemory(size), size);
    }

    public static Pointer calloc(RubyContext context, long size) {
        Pointer pointer = Pointer.malloc(context, size);
        pointer.writeBytes(0L, size, (byte)0);
        return pointer;
    }

    public static Pointer callocAutoRelease(RubyLanguage language, RubyContext context, long size) {
        Pointer pointer = Pointer.mallocAutoRelease(language, context, size);
        pointer.writeBytes(0L, size, (byte)0);
        return pointer;
    }

    private Pointer() {
        this.address = 0L;
        this.size = 0L;
    }

    public Pointer(RubyContext context, long address) {
        this(context, address, Long.MAX_VALUE);
    }

    public Pointer(RubyContext context, long address, long size) {
        Pointer.checkNativeAccess(context);
        this.address = address;
        this.size = size;
    }

    private Pointer(RubyLanguage language, RubyContext context, long address, long size) {
        Pointer.checkNativeAccess(context);
        this.address = address;
        this.size = size;
        this.enableAutoreleaseUnsynchronized(language);
    }

    @ExportMessage.Ignore
    public boolean isNull() {
        return this.address == 0L;
    }

    public long getAddress() {
        return this.address;
    }

    public long getEndAddress() {
        assert (this.isBounded());
        return this.address + this.size;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isBounded() {
        return this.size != Long.MAX_VALUE;
    }

    @ExportMessage
    protected boolean isPointer() {
        return true;
    }

    @ExportMessage
    protected long asPointer() {
        return this.address;
    }

    public void writeByte(long offset, byte b) {
        assert (this.address + offset != 0L);
        UNSAFE.putByte(this.address + offset, b);
    }

    public void writeShort(long offset, short value) {
        assert (this.address + offset != 0L);
        UNSAFE.putShort(this.address + offset, value);
    }

    public void writeInt(long offset, int value) {
        assert (this.address + offset != 0L);
        UNSAFE.putInt(this.address + offset, value);
    }

    public void writeLong(long offset, long value) {
        assert (this.address + offset != 0L);
        UNSAFE.putLong(this.address + offset, value);
    }

    public void writeFloat(long offset, float value) {
        assert (this.address + offset != 0L);
        UNSAFE.putFloat(this.address + offset, value);
    }

    public void writeDouble(long offset, double value) {
        assert (this.address + offset != 0L);
        UNSAFE.putDouble(this.address + offset, value);
    }

    public void writePointer(long offset, long address) {
        this.writeLong(offset, address);
    }

    @CompilerDirectives.TruffleBoundary
    public void writeBytes(long destByteOffset, long size, byte value) {
        assert (this.address + destByteOffset != 0L || size == 0L);
        UNSAFE.setMemory(this.address + destByteOffset, size, value);
    }

    @CompilerDirectives.TruffleBoundary
    public void writeBytes(long destByteOffset, Pointer source, int sourceByteOffset, long bytesToCopy) {
        assert (this.address + destByteOffset != 0L || bytesToCopy == 0L);
        assert (source != null);
        assert (sourceByteOffset >= 0);
        assert (bytesToCopy >= 0L);
        UNSAFE.copyMemory(source.getAddress() + (long)sourceByteOffset, this.address + destByteOffset, bytesToCopy);
    }

    public byte readByte(long offset) {
        assert (this.address + offset != 0L);
        return UNSAFE.getByte(this.address + offset);
    }

    public byte[] readBytes(long offset, int length) {
        byte[] bytes = new byte[length];
        this.readBytes(offset, bytes, 0, length);
        return bytes;
    }

    @CompilerDirectives.TruffleBoundary
    public void readBytes(long offset, byte[] buffer, int bufferPos, int length) {
        assert (this.address + offset != 0L || length == 0);
        assert (buffer != null);
        assert (bufferPos >= 0);
        assert (length >= 0);
        UNSAFE.copyMemory(null, this.address + offset, buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + bufferPos, length);
    }

    public short readShort(long offset) {
        assert (this.address + offset != 0L);
        return UNSAFE.getShort(this.address + offset);
    }

    public int readInt(long offset) {
        assert (this.address + offset != 0L);
        return UNSAFE.getInt(this.address + offset);
    }

    public long readLong(long offset) {
        assert (this.address + offset != 0L);
        return UNSAFE.getLong(this.address + offset);
    }

    public float readFloat(long offset) {
        assert (this.address + offset != 0L);
        return UNSAFE.getFloat(this.address + offset);
    }

    public double readDouble(long offset) {
        assert (this.address + offset != 0L);
        return UNSAFE.getDouble(this.address + offset);
    }

    public byte[] readZeroTerminatedByteArray(RubyContext context, InteropLibrary interopLibrary, long offset) {
        return this.readBytes(offset, this.checkStringSize(this.findNullByte(context, interopLibrary, offset)));
    }

    public byte[] readZeroTerminatedByteArray(RubyContext context, InteropLibrary interopLibrary, long offset, long limit) {
        return this.readBytes(offset, this.checkStringSize(this.findNullByte(context, interopLibrary, offset, limit)));
    }

    public long findNullByte(RubyContext context, InteropLibrary interopLibrary, long offset) {
        if (context.getOptions().NATIVE_PLATFORM) {
            try {
                return (Long)interopLibrary.execute(context.getTruffleNFI().getStrlen(), new Object[]{this.address + offset});
            }
            catch (InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        int n = 0;
        while (this.readByte(offset + (long)n) != 0) {
            ++n;
        }
        return n;
    }

    private long findNullByte(RubyContext context, InteropLibrary interopLibrary, long offset, long limit) {
        if (context.getOptions().NATIVE_PLATFORM) {
            try {
                return (Long)interopLibrary.execute(context.getTruffleNFI().getStrnlen(), new Object[]{this.address + offset, limit});
            }
            catch (InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        int n = 0;
        while ((long)n < limit) {
            if (this.readByte(offset + (long)n) == 0) {
                return n;
            }
            ++n;
        }
        return limit;
    }

    private int checkStringSize(long size) {
        if (size > Integer.MAX_VALUE) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedOperationException("native string is too long to read into managed code");
        }
        return (int)size;
    }

    public Pointer readPointer(RubyContext context, long offset) {
        return new Pointer(context, this.readLong(offset));
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void free() {
        if (this.cleanable != null) {
            this.cleanable.clean();
        } else {
            UNSAFE.freeMemory(this.address);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void freeNoAutorelease() {
        if (this.cleanable != null) {
            throw new UnsupportedOperationException("Calling freeNoAutorelease() on a autorelease Pointer");
        }
        UNSAFE.freeMemory(this.address);
    }

    @Override
    public void close() {
        this.freeNoAutorelease();
    }

    public synchronized boolean isAutorelease() {
        return this.cleanable != null;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void enableAutorelease(RubyLanguage language) {
        if (this.cleanable != null) {
            return;
        }
        this.enableAutoreleaseUnsynchronized(language);
    }

    @CompilerDirectives.TruffleBoundary
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    private void enableAutoreleaseUnsynchronized(RubyLanguage language) {
        this.autoReleaseState = new AutoReleaseState(this.address);
        this.cleanable = language.cleaner.register(this, this.autoReleaseState);
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void disableAutorelease() {
        if (this.cleanable == null) {
            return;
        }
        this.autoReleaseState.markFreed();
        this.cleanable.clean();
        this.cleanable = null;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Pointer)) {
            return false;
        }
        return ((Pointer)other).getAddress() == this.address;
    }

    public int hashCode() {
        return Long.hashCode(this.address);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "Pointer@0x" + Long.toHexString(this.address) + "(size=" + String.valueOf(this.isBounded() ? Long.valueOf(this.size) : "UNBOUNDED") + ")";
    }

    public static long rawMalloc(long size) {
        return UNSAFE.allocateMemory(size);
    }

    public static long rawRealloc(long address, long size) {
        return UNSAFE.reallocateMemory(address, size);
    }

    public static void rawFree(long address) {
        UNSAFE.freeMemory(address);
    }

    private static Unsafe getUnsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new Error(e);
        }
    }

    private static final class AutoReleaseState
    implements Runnable {
        long address;

        AutoReleaseState(long address) {
            this.address = address;
        }

        @Override
        public void run() {
            if (this.address != 0L) {
                UNSAFE.freeMemory(this.address);
            }
        }

        public void markFreed() {
            this.address = 0L;
        }
    }
}

