/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.extra;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.time.GetTimeZoneNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.library.RubyStringLibrary;

@CoreModule(value="Truffle::POSIX", isClass=true)
public abstract class TrufflePosixNodes {
    @CompilerDirectives.TruffleBoundary
    private static void invalidateENV(String name) {
        if (name.equals("TZ")) {
            GetTimeZoneNode.invalidateTZ();
        }
    }

    @Primitive(name="posix_invalidate_env")
    public static abstract class InvalidateEnvNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"libEnvVar.isRubyString(envVar)"}, limit="1")
        Object invalidate(Object envVar, @Cached RubyStringLibrary libEnvVar) {
            TrufflePosixNodes.invalidateENV(RubyGuards.getJavaString(envVar));
            return envVar;
        }
    }
}

