/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.extra;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

public final class RubyConcurrentMap
extends RubyDynamicObject
implements ObjectGraphNode {
    private ConcurrentHashMap<Key, Object> map;

    public RubyConcurrentMap(RubyClass rubyClass, Shape shape) {
        super(rubyClass, shape);
    }

    @CompilerDirectives.TruffleBoundary
    public void allocateMap(int initialCapacity, float loadFactor) {
        this.map = initialCapacity <= 0 ? new ConcurrentHashMap() : (loadFactor <= 0.0f ? new ConcurrentHashMap(initialCapacity) : new ConcurrentHashMap(initialCapacity, loadFactor));
    }

    public ConcurrentHashMap<Key, Object> getMap() {
        return this.map;
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        for (Map.Entry<Key, Object> entry : this.map.entrySet()) {
            ObjectGraph.addProperty(reachable, entry.getKey().key);
            ObjectGraph.addProperty(reachable, entry.getValue());
        }
    }

    public static final class Key {
        public final Object key;
        private final int hashCode;

        public Key(Object key, int hashCode) {
            this.key = key;
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            assert (other instanceof Key);
            Key otherKey = (Key)other;
            if (this.key == otherKey.key) {
                return true;
            }
            if (this.hashCode != otherKey.hashCode) {
                return false;
            }
            return KernelNodes.SameOrEqlNode.executeUncached(this.key, otherKey.key);
        }
    }
}

