/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.List;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.debug.VariableNamesObject;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyScope
implements TruffleObject {
    public static final String RECEIVER_MEMBER = "self";
    public final MaterializedFrame frame;
    public final RubyBinding binding;
    public final RubyNode node;

    public RubyScope(RubyContext context, RubyLanguage language, MaterializedFrame frame, RubyNode node) {
        assert (frame != null);
        this.frame = frame;
        this.binding = BindingNodes.createBinding(context, language, frame);
        this.node = node;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.hasScopeParent() ? "block" : "method";
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    boolean hasScopeParent() {
        return RubyArguments.getDeclarationFrame((Frame)this.frame) != null;
    }

    @ExportMessage
    Object getScopeParent(@CachedLibrary(value="this") InteropLibrary node) throws UnsupportedMessageException {
        MaterializedFrame parentFrame = RubyArguments.getDeclarationFrame((Frame)this.frame);
        if (parentFrame != null) {
            RubyLanguage language = RubyLanguage.get((Node)node);
            RubyContext context = RubyContext.get((Node)node);
            return new RubyScope(context, language, parentFrame, null);
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean hasSourceLocation() {
        RootNode rootNode = this.node == null ? null : this.node.getRootNode();
        return rootNode != null && rootNode.getSourceSection() != null;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public SourceSection getSourceLocation() throws UnsupportedMessageException {
        RootNode rootNode;
        RootNode rootNode2 = rootNode = this.node == null ? null : this.node.getRootNode();
        if (rootNode == null) {
            throw UnsupportedMessageException.create();
        }
        SourceSection sourceSection = rootNode.getSourceSection();
        if (sourceSection == null) {
            throw UnsupportedMessageException.create();
        }
        return sourceSection;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return RubyLanguage.class;
    }

    @ExportMessage
    protected boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected Object getMembers(boolean includeInternal) {
        List<String> members = BindingNodes.LocalVariablesNode.listLocalVariablesWithDuplicates(this.frame, RECEIVER_MEMBER);
        return new VariableNamesObject(members.toArray(StringUtils.EMPTY_STRING_ARRAY));
    }

    @ExportMessage
    protected boolean isMemberInsertable(String member) {
        return false;
    }

    @ExportMessage
    static final class WriteMember {
        WriteMember() {
        }

        @Specialization
        static void writeMember(RubyScope scope, String member, Object value, @CachedLibrary(value="scope") InteropLibrary interopLibrary, @Cached BindingNodes.LocalVariableSetNode localVariableSetNode, @Bind(value="this") Node node) throws UnknownIdentifierException {
            if (!interopLibrary.isMemberModifiable((Object)scope, member)) {
                throw UnknownIdentifierException.create((String)member);
            }
            localVariableSetNode.execute(node, scope.binding, member, value);
        }
    }

    @ExportMessage
    static final class IsMemberModifiable {
        IsMemberModifiable() {
        }

        @Specialization(guards={"RECEIVER_MEMBER.equals(member)"})
        static boolean readSelf(RubyScope scope, String member) {
            return false;
        }

        @Specialization(guards={"!RECEIVER_MEMBER.equals(member)"})
        static boolean isMemberModifiable(RubyScope scope, String member, @Cached @Cached.Exclusive BindingNodes.HasLocalVariableNode hasLocalVariableNode, @Bind(value="this") Node node) {
            return hasLocalVariableNode.execute(node, scope.binding, member);
        }
    }

    @ExportMessage
    static final class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"RECEIVER_MEMBER.equals(member)"})
        static boolean readSelf(RubyScope scope, String member) {
            return true;
        }

        @Specialization(guards={"!RECEIVER_MEMBER.equals(member)"})
        static boolean isMemberReadable(RubyScope scope, String member, @Cached @Cached.Exclusive BindingNodes.HasLocalVariableNode hasLocalVariableNode, @Bind(value="this") Node node) {
            return hasLocalVariableNode.execute(node, scope.binding, member);
        }
    }

    @ExportMessage
    static final class ReadMember {
        ReadMember() {
        }

        @Specialization(guards={"RECEIVER_MEMBER.equals(member)"})
        static Object readSelf(RubyScope scope, String member) {
            return RubyArguments.getSelf((Frame)scope.frame);
        }

        @Specialization(guards={"!RECEIVER_MEMBER.equals(member)"})
        static Object read(RubyScope scope, String member, @Cached @Cached.Exclusive BindingNodes.LocalVariableGetNode localVariableGetNode, @Bind(value="this") Node node) throws UnknownIdentifierException {
            try {
                return localVariableGetNode.execute(node, scope.binding, member);
            }
            catch (RaiseException e) {
                throw UnknownIdentifierException.create((String)member);
            }
        }
    }
}

