/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.debug.MetricsBodyNode;
import org.truffleruby.debug.MetricsInternalRootNode;
import org.truffleruby.shared.options.Profile;

public final class MetricsProfiler {
    private final RubyLanguage language;
    private final RubyContext context;
    private final Map<String, RootCallTarget> summaryCallTargets = new ConcurrentHashMap<String, RootCallTarget>();

    public MetricsProfiler(RubyLanguage language, RubyContext context) {
        this.language = language;
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public <T> T callWithMetrics(String metricKind, String feature, Supplier<T> supplier) {
        if (this.context.getOptions().METRICS_PROFILE_REQUIRE != Profile.NONE) {
            RootCallTarget callTarget = this.getCallTarget(metricKind, feature);
            return MetricsProfiler.callAndCast(callTarget, supplier);
        }
        return supplier.get();
    }

    private <T> RootCallTarget getCallTarget(String metricKind, String feature) {
        if (this.context.getOptions().METRICS_PROFILE_REQUIRE == Profile.DETAIL) {
            String name = "metrics " + metricKind + " " + this.language.getPathRelativeToHome(feature);
            return this.newCallTarget(name);
        }
        String name = "metrics " + metricKind;
        return ConcurrentOperations.getOrCompute(this.summaryCallTargets, name, this::newCallTarget);
    }

    private <T> RootCallTarget newCallTarget(String name) {
        MetricsBodyNode body = new MetricsBodyNode();
        MetricsInternalRootNode rootNode = new MetricsInternalRootNode(this.context, name, body);
        return rootNode.getCallTarget();
    }

    private static <T> T callAndCast(RootCallTarget callTarget, Supplier<T> supplier) {
        return (T)callTarget.call(new Object[]{supplier});
    }
}

