/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.tracepoint;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.core.tracepoint.RubyTracePoint;
import org.truffleruby.core.tracepoint.TraceBaseEventNode;
import org.truffleruby.core.tracepoint.TracePointState;

final class TracePointEventNode
extends TraceBaseEventNode {
    private final ConditionProfile inTracePointProfile = ConditionProfile.create();
    private final RubyTracePoint tracePoint;
    private final RubyProc proc;
    private final RubySymbol event;
    private final RubyLanguage language;

    public TracePointEventNode(RubyContext context, RubyLanguage language, EventContext eventContext, RubyTracePoint tracePoint, RubySymbol event) {
        super(context, language, eventContext);
        this.tracePoint = tracePoint;
        this.proc = tracePoint.proc;
        this.event = event;
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEnter(VirtualFrame frame) {
        RubyThread rubyThread = RubyLanguage.get((Node)this).getCurrentThread();
        TracePointState state = rubyThread.tracePointState;
        if (this.inTracePointProfile.profile(state.insideProc)) {
            return;
        }
        state.event = this.event;
        state.path = this.getFile();
        state.line = this.getLine();
        state.binding = BindingNodes.createBinding(this.context, this.language, frame.materialize(), this.eventContext.getInstrumentedSourceSection());
        state.insideProc = true;
        try {
            this.callBlock(this.proc, this.tracePoint);
        }
        finally {
            state.insideProc = false;
            state.binding = null;
        }
    }
}

