/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.time;

import com.oracle.truffle.api.CompilerDirectives;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.util.Locale;

public final class TimeZoneAndName {
    private static final DateTimeFormatter SHORT_ZONE_NAME_FORMATTER = new DateTimeFormatterBuilder().appendZoneText(TextStyle.SHORT).toFormatter(Locale.ENGLISH);
    private final ZoneId zone;
    private final String name;

    public TimeZoneAndName(ZoneId zone) {
        assert (!(zone instanceof ZoneOffset));
        this.zone = zone;
        this.name = null;
    }

    public TimeZoneAndName(ZoneOffset zone, String name) {
        assert (name != null);
        this.zone = zone;
        this.name = name;
    }

    public ZoneId getZone() {
        return this.zone;
    }

    @CompilerDirectives.TruffleBoundary
    public String getName(ZonedDateTime dateTime) {
        if (this.name != null) {
            return this.name;
        }
        return dateTime.format(SHORT_ZONE_NAME_FORMATTER);
    }
}

