/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.time;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.exception.ErrnoErrorNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.time.GetTimeZoneNode;
import org.truffleruby.core.time.GetTimeZoneNodeGen;
import org.truffleruby.core.time.RubyDateFormatter;
import org.truffleruby.core.time.RubyTime;
import org.truffleruby.core.time.TimeZoneAndName;
import org.truffleruby.language.Nil;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.IsFrozenNode;

@CoreModule(value="Time", isClass=true)
public abstract class TimeNodes {

    @Primitive(name="time_s_from_array", lowerFixnum={1, 2, 3, 4, 5, 6, 7, 8})
    public static abstract class TimeSFromArrayPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode;

        @Specialization(guards={"(isutc || !isRubyDynamicObject(utcoffset)) || isNil(utcoffset)"})
        @CompilerDirectives.TruffleBoundary
        RubyTime timeSFromArray(RubyClass timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean isutc, Object utcoffset) {
            ZonedDateTime dt;
            boolean sixtySeconds;
            boolean relativeOffset;
            ZoneId zone;
            RubyLanguage language = this.getLanguage();
            if (nsec < 0 || nsec > 999999999 || sec < 0 || sec > 60 || min < 0 || min > 59 || hour < 0 || hour > 23 || mday < 1 || mday > 31 || month < 1 || month > 12) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorOutOfRange(this));
            }
            Object zoneToStore = nil;
            TimeZoneAndName envZone = null;
            if (isutc) {
                zone = GetTimeZoneNode.UTC;
                relativeOffset = false;
                zoneToStore = language.coreStrings.UTC.createInstance(this.getContext());
            } else if (utcoffset == nil) {
                if (this.fromJavaStringNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.fromJavaStringNode = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                }
                envZone = this.getTimeZoneNode.executeGetTimeZone();
                zone = envZone.getZone();
                relativeOffset = false;
            } else if (utcoffset instanceof Integer || utcoffset instanceof Long) {
                int offset = ((Number)utcoffset).intValue();
                zone = this.getZoneOffset(offset);
                relativeOffset = true;
                zoneToStore = nil;
            } else {
                throw new UnsupportedOperationException(StringUtils.format("%s %s %s %s", isdst, isutc, utcoffset, utcoffset.getClass()));
            }
            boolean bl = sixtySeconds = sec == 60;
            if (sixtySeconds) {
                sec = 0;
            }
            try {
                dt = ZonedDateTime.of(year, month, mday, hour, min, sec, nsec, zone);
            }
            catch (DateTimeException e) {
                dt = ZonedDateTime.of(year, 1, 1, hour, min, sec, nsec, zone).plusMonths(month - 1).plusDays(mday - 1);
            }
            if (sixtySeconds) {
                dt = dt.plusSeconds(60L);
            }
            if (isdst == 0) {
                dt = dt.withLaterOffsetAtOverlap();
            } else if (isdst == 1) {
                dt = dt.withEarlierOffsetAtOverlap();
            }
            if (envZone != null) {
                String shortZoneName = envZone.getName(dt);
                zoneToStore = this.createString(this.fromJavaStringNode, shortZoneName, Encodings.UTF_8);
            }
            Shape shape = this.getLanguage().timeShape;
            RubyTime instance = new RubyTime(timeClass, shape, dt, zoneToStore, utcoffset, relativeOffset, isutc);
            AllocationTracing.trace(instance, this);
            return instance;
        }

        private ZoneOffset getZoneOffset(int offset) {
            try {
                return ZoneOffset.ofTotalSeconds(offset);
            }
            catch (DateTimeException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }
    }

    @Primitive(name="time_strftime")
    @ReportPolymorphism
    public static abstract class TimeStrftimePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"equalNode.execute(node, libFormat, format, cachedFormat, cachedEncoding)"}, limit="getLanguage().options.TIME_FORMAT_CACHE")
        static RubyString timeStrftimeCached(RubyTime time, Object format, @Cached @Cached.Shared RubyStringLibrary libFormat, @Cached(value="asTruffleStringUncached(format)") TruffleString cachedFormat, @Cached(value="libFormat.getEncoding(format)") RubyEncoding cachedEncoding, @Cached(value="compilePattern(cachedFormat, cachedEncoding)", dimensions=1) RubyDateFormatter.Token[] pattern, @Cached StringHelperNodes.EqualSameEncodingNode equalNode, @Cached(value="formatCanBeFast(pattern)") boolean canUseFast, @Cached InlinedConditionProfile yearIsFastProfile, @Cached @Cached.Shared TruffleString.ConcatNode concatNode, @Cached @Cached.Shared TruffleString.FromLongNode fromLongNode, @Cached @Cached.Shared TruffleString.CodePointLengthNode codePointLengthNode, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode, @Cached @Cached.Shared ErrnoErrorNode errnoErrorNode, @Bind(value="this") Node node) {
            if (canUseFast && yearIsFastProfile.profile(node, TimeStrftimePrimitiveNode.yearIsFast(time))) {
                TruffleString tstring = RubyDateFormatter.formatToTStringFast(pattern, time.dateTime, concatNode, fromLongNode, codePointLengthNode);
                return TimeStrftimePrimitiveNode.createString(node, tstring, Encodings.UTF_8);
            }
            TStringBuilder tstringBuilder = TimeStrftimePrimitiveNode.formatTime(node, time, pattern, errnoErrorNode);
            return TimeStrftimePrimitiveNode.createString(node, tstringBuilder.toTStringUnsafe(fromByteArrayNode), cachedEncoding);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"libFormat.isRubyString(format)"}, replaces={"timeStrftimeCached"})
        RubyString timeStrftime(RubyTime time, Object format, @Cached @Cached.Shared RubyStringLibrary libFormat, @Cached @Cached.Shared TruffleString.ConcatNode concatNode, @Cached @Cached.Shared TruffleString.FromLongNode fromLongNode, @Cached @Cached.Shared TruffleString.CodePointLengthNode codePointLengthNode, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode, @Cached @Cached.Shared ErrnoErrorNode errnoErrorNode) {
            RubyEncoding rubyEncoding = libFormat.getEncoding(format);
            RubyDateFormatter.Token[] pattern = this.compilePattern(libFormat.getTString(format), rubyEncoding);
            if (this.formatCanBeFast(pattern) && TimeStrftimePrimitiveNode.yearIsFast(time)) {
                TruffleString tstring = RubyDateFormatter.formatToTStringFast(pattern, time.dateTime, concatNode, fromLongNode, codePointLengthNode);
                return this.createString(tstring, Encodings.UTF_8);
            }
            TStringBuilder tstringBuilder = TimeStrftimePrimitiveNode.formatTime(this, time, pattern, errnoErrorNode);
            return this.createString(tstringBuilder.toTStringUnsafe(fromByteArrayNode), rubyEncoding);
        }

        protected boolean formatCanBeFast(RubyDateFormatter.Token[] pattern) {
            return RubyDateFormatter.formatCanBeFast(pattern);
        }

        protected static boolean yearIsFast(RubyTime time) {
            int year = time.dateTime.getYear();
            return year >= 1000 && year <= 9999;
        }

        protected RubyDateFormatter.Token[] compilePattern(AbstractTruffleString format, RubyEncoding encoding) {
            return RubyDateFormatter.compilePattern(format, encoding, false, this.getContext(), this);
        }

        private static TStringBuilder formatTime(Node node, RubyTime time, RubyDateFormatter.Token[] pattern, ErrnoErrorNode errnoErrorNode) {
            return RubyDateFormatter.formatToTStringBuilder(pattern, time.dateTime, time.zone, time.isUtc, TimeStrftimePrimitiveNode.getContext(node), TimeStrftimePrimitiveNode.getLanguage(node), node, errnoErrorNode);
        }
    }

    @Primitive(name="time_set_zone")
    public static abstract class TimeSetZoneNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"strings.isRubyString(zone)"}, limit="1")
        Object timeSetZone(RubyTime time, Object zone, @Cached RubyStringLibrary strings) {
            time.zone = zone;
            return zone;
        }
    }

    @Primitive(name="time_zone")
    public static abstract class TimeZoneNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object timeZone(RubyTime time) {
            return time.zone;
        }
    }

    @CoreMethod(names={"utc?", "gmt?"})
    public static abstract class IsUTCNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isUTC(RubyTime time) {
            return time.isUtc;
        }
    }

    @CoreMethod(names={"dst?", "isdst"})
    public static abstract class TimeIsDSTNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean timeIsDST(RubyTime time) {
            ZonedDateTime dateTime = time.dateTime;
            return dateTime.getZone().getRules().isDaylightSavings(dateTime.toInstant());
        }
    }

    @CoreMethod(names={"yday"})
    public static abstract class TimeYearDayNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int timeYeayDay(RubyTime time) {
            return time.dateTime.getDayOfYear();
        }
    }

    @CoreMethod(names={"wday"})
    public static abstract class TimeWeekDayNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int timeWeekDay(RubyTime time) {
            int wday = time.dateTime.getDayOfWeek().getValue();
            if (wday == 7) {
                wday = 0;
            }
            return wday;
        }
    }

    @CoreMethod(names={"year"})
    public static abstract class TimeYearNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int timeYear(RubyTime time) {
            return time.dateTime.getYear();
        }
    }

    @CoreMethod(names={"mon", "month"})
    public static abstract class TimeMonthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int timeMonth(RubyTime time) {
            return time.dateTime.getMonthValue();
        }
    }

    @CoreMethod(names={"day", "mday"})
    public static abstract class TimeDayNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int timeDay(RubyTime time) {
            return time.dateTime.getDayOfMonth();
        }
    }

    @CoreMethod(names={"hour"})
    public static abstract class TimeHourNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int timeHour(RubyTime time) {
            return time.dateTime.getHour();
        }
    }

    @CoreMethod(names={"min"})
    public static abstract class TimeMinNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int timeMin(RubyTime time) {
            return time.dateTime.getMinute();
        }
    }

    @CoreMethod(names={"sec"})
    public static abstract class TimeSecNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int timeSec(RubyTime time) {
            return time.dateTime.getSecond();
        }
    }

    @CoreMethod(names={"utc_offset", "gmt_offset", "gmtoff"})
    public static abstract class TimeUTCOffsetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int timeUTCOffset(RubyTime time) {
            return time.dateTime.getOffset().getTotalSeconds();
        }
    }

    @Primitive(name="time_set_nseconds", lowerFixnum={1})
    public static abstract class TimeSetNSecondsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        long timeSetNSeconds(RubyTime time, int nanoseconds) {
            ZonedDateTime dateTime = time.dateTime;
            time.dateTime = dateTime.plusNanos(nanoseconds - dateTime.getNano());
            return nanoseconds;
        }
    }

    @CoreMethod(names={"nsec", "tv_nsec"})
    public static abstract class TimeNanoSecondsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int timeNSec(RubyTime time) {
            return time.dateTime.getNano();
        }
    }

    @CoreMethod(names={"usec", "tv_usec"})
    public static abstract class TimeMicroSecondsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int timeUSec(RubyTime time) {
            return time.dateTime.getNano() / 1000;
        }
    }

    @CoreMethod(names={"to_i", "tv_sec"})
    public static abstract class TimeSecondsSinceEpochNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        long timeSeconds(RubyTime time) {
            return time.dateTime.toInstant().getEpochSecond();
        }
    }

    @Primitive(name="time_at", lowerFixnum={2})
    public static abstract class TimeAtPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization
        RubyTime timeAt(RubyClass timeClass, long seconds, int nanoseconds) {
            TimeZoneAndName zoneAndName = this.getTimeZoneNode.executeGetTimeZone();
            ZonedDateTime dateTime = this.getDateTime(seconds, nanoseconds, zoneAndName.getZone());
            String shortZoneName = zoneAndName.getName(dateTime);
            RubyString zone = this.createString(this.fromJavaStringNode, shortZoneName, Encodings.UTF_8);
            Shape shape = this.getLanguage().timeShape;
            RubyTime instance = new RubyTime(timeClass, shape, dateTime, (Object)zone, nil, false, false);
            AllocationTracing.trace(instance, this);
            return instance;
        }

        @Specialization
        RubyTime timeAt(RubyClass timeClass, RubyBignum seconds, int nanoseconds) {
            throw this.outOfRange(seconds);
        }

        @CompilerDirectives.TruffleBoundary
        private ZonedDateTime getDateTime(long seconds, int nanoseconds, ZoneId timeZone) {
            try {
                return ZonedDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanoseconds), timeZone);
            }
            catch (DateTimeException e) {
                throw this.outOfRange(seconds);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private RaiseException outOfRange(Object seconds) {
            String message = StringUtils.format("UNIX epoch + %s seconds out of range for Time (java.time limitation)", seconds);
            return new RaiseException(this.getContext(), this.coreExceptions().rangeError(message, (Node)this));
        }
    }

    @Primitive(name="time_now")
    public static abstract class TimeNowNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization
        RubyTime timeNow(RubyClass timeClass) {
            TimeZoneAndName zoneAndName = this.getTimeZoneNode.executeGetTimeZone();
            ZonedDateTime dt = this.now(zoneAndName.getZone());
            String shortZoneName = zoneAndName.getName(dt);
            RubyString zone = this.createString(this.fromJavaStringNode, shortZoneName, Encodings.UTF_8);
            RubyTime instance = new RubyTime(timeClass, this.getLanguage().timeShape, dt, (Object)zone, nil, false, false);
            AllocationTracing.trace(instance, this);
            return instance;
        }

        @CompilerDirectives.TruffleBoundary
        private ZonedDateTime now(ZoneId timeZone) {
            return ZonedDateTime.now(timeZone);
        }
    }

    @CoreMethod(names={"gmtime", "utc"})
    public static abstract class GmTimeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyTime gmtime(RubyTime time, @Cached InlinedBranchProfile errorProfile, @Cached InlinedBranchProfile notModifiedProfile, @Cached IsFrozenNode isFrozenNode) {
            if (time.isUtc) {
                notModifiedProfile.enter((Node)this);
                return time;
            }
            if (isFrozenNode.execute((Object)time)) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().frozenError((Object)time, this));
            }
            ZonedDateTime dateTime = time.dateTime;
            time.isUtc = true;
            time.relativeOffset = false;
            time.zone = this.coreStrings().UTC.createInstance(this.getContext());
            time.dateTime = this.inUTC(dateTime);
            return time;
        }

        @CompilerDirectives.TruffleBoundary
        private ZonedDateTime inUTC(ZonedDateTime dateTime) {
            return dateTime.withZoneSameInstant(GetTimeZoneNode.UTC);
        }
    }

    @Primitive(name="time_add")
    public static abstract class TimeAddNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyTime add(RubyTime time, long seconds, long nanoSeconds) {
            ZonedDateTime dateTime = time.dateTime;
            time.dateTime = dateTime.plusSeconds(seconds).plusNanos(nanoSeconds);
            return time;
        }
    }

    @Primitive(name="time_utctime")
    public static abstract class UtcTimeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyTime utc(RubyTime time) {
            time.isUtc = true;
            time.relativeOffset = false;
            time.zone = this.coreStrings().UTC.createInstance(this.getContext());
            time.dateTime = this.inUTC(time.dateTime);
            return time;
        }

        @CompilerDirectives.TruffleBoundary
        private ZonedDateTime inUTC(ZonedDateTime dateTime) {
            return dateTime.withZoneSameInstant(GetTimeZoneNode.UTC);
        }
    }

    @Primitive(name="time_localtime")
    public static abstract class LocalTimeNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();

        @Specialization
        RubyTime localtime(RubyTime time, Nil offset, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            TimeZoneAndName timeZoneAndName = this.getTimeZoneNode.executeGetTimeZone();
            ZonedDateTime newDateTime = this.withZone(time.dateTime, timeZoneAndName.getZone());
            String shortZoneName = timeZoneAndName.getName(newDateTime);
            RubyString zone = this.createString(fromJavaStringNode, shortZoneName, Encodings.UTF_8);
            time.isUtc = false;
            time.relativeOffset = false;
            time.zone = zone;
            time.dateTime = newDateTime;
            return time;
        }

        @Specialization
        RubyTime localtime(RubyTime time, long offset) {
            ZoneId zone = this.getDateTimeZone((int)offset);
            ZonedDateTime dateTime = this.withZone(time.dateTime, zone);
            time.isUtc = false;
            time.relativeOffset = true;
            time.zone = nil;
            time.dateTime = dateTime;
            return time;
        }

        @CompilerDirectives.TruffleBoundary
        public ZoneId getDateTimeZone(int offset) {
            try {
                return ZoneId.ofOffset("", ZoneOffset.ofTotalSeconds(offset));
            }
            catch (DateTimeException e) {
                throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().argumentError(e.getMessage(), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private ZonedDateTime withZone(ZonedDateTime dateTime, ZoneId zone) {
            return dateTime.withZoneSameInstant(zone);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyTime initializeCopy(RubyTime self, RubyTime from) {
            self.dateTime = from.dateTime;
            self.offset = from.offset;
            self.zone = from.zone;
            self.relativeOffset = from.relativeOffset;
            self.isUtc = from.isUtc;
            return self;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        private static final ZonedDateTime ZERO = ZonedDateTime.ofInstant(Instant.EPOCH, GetTimeZoneNode.UTC);

        @Specialization
        RubyTime allocate(RubyClass rubyClass) {
            RubyTime instance = new RubyTime(rubyClass, this.getLanguage().timeShape, ZERO, nil, 0, false, false);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

