/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.time;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.core.time.TimeZoneAndName;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;

public abstract class GetTimeZoneNode
extends RubyBaseNode {
    public static final ZoneId UTC = ZoneId.of("UTC");
    protected static final CyclicAssumption TZ_UNCHANGED = new CyclicAssumption("ENV['TZ'] is unmodified");
    @Node.Child
    private DispatchNode lookupEnvNode = DispatchNode.create();
    private static final Map<String, String> LONG_TZNAME = GetTimeZoneNode.map("MET", "CET", "ROC", "Asia/Taipei", "WET", "Europe/Lisbon");
    private static final Pattern TZ_PATTERN = Pattern.compile("([a-zA-Z]{3,}+)([\\+-]?)(\\d+)(?::(\\d+))?(?::(\\d+))?");

    public static void invalidateTZ() {
        TZ_UNCHANGED.invalidate();
    }

    public abstract TimeZoneAndName executeGetTimeZone();

    @Specialization(assumptions={"TZ_UNCHANGED.getAssumption()"})
    TimeZoneAndName getTimeZone(@Cached(value="getTZ()") Object tzValue, @Cached(value="getTimeZone(tzValue)") TimeZoneAndName zone) {
        return zone;
    }

    @NeverDefault
    protected Object getTZ() {
        if (this.getContext().getOptions().NATIVE_PLATFORM) {
            return this.lookupEnvNode.call((Object)this.coreLibrary().getENV(), "[]", FrozenStrings.TZ);
        }
        return nil;
    }

    @CompilerDirectives.TruffleBoundary
    @NeverDefault
    protected TimeZoneAndName getTimeZone(Object tz) {
        String tzString = "";
        RubyStringLibrary libString = RubyStringLibrary.getUncached();
        if (libString.isRubyString(tz)) {
            tzString = RubyGuards.getJavaString(tz);
        }
        if (tz == nil) {
            return new TimeZoneAndName(this.getContext().getEnv().getTimeZone());
        }
        if (libString.isRubyString(tz)) {
            return this.parse(tzString);
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private static Map<String, String> map(String ... keyValues) {
        HashMap<String, String> map = new HashMap<String, String>(keyValues.length / 2);
        int i = 0;
        while (i < keyValues.length) {
            map.put(keyValues[i++], keyValues[i++]);
        }
        return map;
    }

    private TimeZoneAndName parse(String zone) {
        ZoneId zoneID;
        Matcher tzMatcher = TZ_PATTERN.matcher(zone);
        if (tzMatcher.matches()) {
            String name = tzMatcher.group(1);
            String sign = tzMatcher.group(2);
            String hours = tzMatcher.group(3);
            String minutes = tzMatcher.group(4);
            String seconds = tzMatcher.group(5);
            return this.getTimeZoneFromHHMM(name, sign.equals("-"), hours, minutes, seconds);
        }
        String expandedZone = this.expandZoneName(zone);
        try {
            zoneID = ZoneId.of(expandedZone);
        }
        catch (IllegalArgumentException | DateTimeException e) {
            zoneID = UTC;
        }
        return new TimeZoneAndName(zoneID);
    }

    private String expandZoneName(String zone) {
        String upZone = zone.toUpperCase(Locale.ENGLISH);
        if (LONG_TZNAME.containsKey(upZone)) {
            return LONG_TZNAME.get(upZone);
        }
        if (upZone.equals("UTC") || upZone.equals("GMT")) {
            return "Etc/" + upZone;
        }
        return zone;
    }

    private TimeZoneAndName getTimeZoneFromHHMM(String name, boolean positive, String hours, String minutes, String seconds) {
        ZoneOffset zoneOffset;
        int s;
        int h = Integer.parseInt(hours);
        int m = minutes != null ? Integer.parseInt(minutes) : 0;
        int n = s = seconds != null ? Integer.parseInt(seconds) : 0;
        if (h > 23 || m > 59) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("utc_offset out of range", this));
        }
        int offset = (positive ? 1 : -1) * (h * 3600 + m * 60 + s);
        try {
            zoneOffset = ZoneOffset.ofTotalSeconds(offset);
        }
        catch (DateTimeException e) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(e.getMessage(), this));
        }
        return new TimeZoneAndName(zoneOffset, name);
    }
}

