/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.thread.RubyBacktraceLocation;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.parser.RubySource;

@CoreModule(value="Thread::Backtrace::Location", isClass=true)
public abstract class ThreadBacktraceLocationNodes {
    @CompilerDirectives.TruffleBoundary
    private static SourceSection getAvailableSourceSection(RubyContext context, RubyBacktraceLocation threadBacktraceLocation) {
        Backtrace backtrace = threadBacktraceLocation.backtrace;
        int activationIndex = threadBacktraceLocation.activationIndex;
        return BacktraceFormatter.nextAvailableSourceSection(backtrace.getStackTrace(), activationIndex);
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization
        RubyString toS(RubyBacktraceLocation threadBacktraceLocation) {
            Backtrace backtrace = threadBacktraceLocation.backtrace;
            int index = threadBacktraceLocation.activationIndex;
            String description = this.getContext().getUserBacktraceFormatter().formatLine(backtrace.getStackTrace(), index, null);
            return this.createString(this.fromJavaStringNode, description, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"lineno"})
    public static abstract class LinenoNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int lineno(RubyBacktraceLocation threadBacktraceLocation) {
            SourceSection sourceSection = ThreadBacktraceLocationNodes.getAvailableSourceSection(this.getContext(), threadBacktraceLocation);
            return RubySource.getStartLineAdjusted(this.getContext(), sourceSection);
        }
    }

    @CoreMethod(names={"base_label"})
    public static abstract class BaseLabelNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString label(RubyBacktraceLocation threadBacktraceLocation, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            Backtrace backtrace = threadBacktraceLocation.backtrace;
            int index = threadBacktraceLocation.activationIndex;
            TruffleStackTraceElement element = backtrace.getStackTrace()[index];
            String baseLabel = Backtrace.baseLabelFor(element);
            return this.createString(fromJavaStringNode, baseLabel, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"label"})
    public static abstract class LabelNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString label(RubyBacktraceLocation threadBacktraceLocation, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            Backtrace backtrace = threadBacktraceLocation.backtrace;
            int index = threadBacktraceLocation.activationIndex;
            TruffleStackTraceElement element = backtrace.getStackTrace()[index];
            String label = Backtrace.labelFor(element);
            return this.createString(fromJavaStringNode, label, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"path"})
    public static abstract class PathNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString path(RubyBacktraceLocation threadBacktraceLocation) {
            SourceSection sourceSection = ThreadBacktraceLocationNodes.getAvailableSourceSection(this.getContext(), threadBacktraceLocation);
            if (sourceSection == null) {
                return this.coreStrings().UNKNOWN.createInstance(this.getContext());
            }
            TruffleString path = this.getLanguage().getPathToTStringCache().getCachedPath(sourceSection.getSource());
            return this.createString(path, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"absolute_path"})
    public static abstract class AbsolutePathNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object absolutePath(RubyBacktraceLocation threadBacktraceLocation) {
            SourceSection sourceSection = ThreadBacktraceLocationNodes.getAvailableSourceSection(this.getContext(), threadBacktraceLocation);
            return AbsolutePathNode.getAbsolutePath(sourceSection, this);
        }

        @CompilerDirectives.TruffleBoundary
        public static Object getAbsolutePath(SourceSection sourceSection, RubyBaseNode node) {
            RubyContext context = node.getContext();
            RubyLanguage language = node.getLanguage();
            if (sourceSection == null) {
                return language.coreStrings.UNKNOWN.createInstance(context);
            }
            Source source = sourceSection.getSource();
            if (BacktraceFormatter.isRubyCore(language, source)) {
                return nil;
            }
            if (source.getPath() != null) {
                String path = language.getSourcePath(source);
                String canonicalPath = context.getFeatureLoader().canonicalize(path, source);
                TruffleString cachedTString = language.tstringCache.getTString(TStringUtils.utf8TString(canonicalPath), Encodings.UTF_8);
                return node.createString(cachedTString, Encodings.UTF_8);
            }
            TruffleString cachedPath = language.getPathToTStringCache().getCachedPath(source);
            return node.createString(cachedPath, Encodings.UTF_8);
        }
    }
}

