/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.lang.invoke.VarHandle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.InterruptMode;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.fiber.RubyFiber;
import org.truffleruby.core.hash.HashOperations;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.support.PRNGRandomizerNodes;
import org.truffleruby.core.support.RubyPRNGRandomizer;
import org.truffleruby.core.thread.ThreadLocalBuffer;
import org.truffleruby.core.thread.ThreadStatus;
import org.truffleruby.core.tracepoint.TracePointState;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

public final class RubyThread
extends RubyDynamicObject
implements ObjectGraphNode {
    public Object processStatus = RubyBaseNode.nil;
    public InterruptMode interruptMode = InterruptMode.IMMEDIATE;
    public volatile ThreadStatus status = ThreadStatus.RUN;
    public final List<ReentrantLock> ownedLocks = new ArrayList<ReentrantLock>();
    private final RubyFiber rootFiber;
    private RubyFiber currentFiber;
    public final Set<RubyFiber> runningFibers = RubyThread.newFiberSet();
    CountDownLatch finishedLatch = new CountDownLatch(1);
    final RubyHash threadLocalVariables;
    final RubyHash recursiveObjects;
    final RubyHash recursiveObjectsSingle;
    final RubyPRNGRandomizer randomizer;
    public final TracePointState tracePointState = new TracePointState();
    boolean reportOnException;
    boolean abortOnException;
    public volatile Thread thread = null;
    public volatile Object nativeThreadId = RubyBaseNode.nil;
    volatile RubyException exception = null;
    volatile Object value = RubyBaseNode.nil;
    public final AtomicBoolean wakeUp = new AtomicBoolean(false);
    volatile int priority = 5;
    ThreadLocalBuffer ioBuffer;
    Object threadGroup;
    public String sourceLocation;
    Object name = RubyBaseNode.nil;
    public DecimalFormat noExpFormat;
    public DecimalFormat smallExpFormat;
    public DecimalFormat largeExpFormat;
    public DecimalFormat formatFFloat;
    public DecimalFormat formatEFloat;
    public DecimalFormat formatGFloatSimple;
    public DecimalFormat formatGFloatExponential;

    public RubyThread(RubyClass rubyClass, Shape shape, RubyContext context, RubyLanguage language, boolean reportOnException, boolean abortOnException, Object threadGroup, String sourceLocation) {
        super(rubyClass, shape);
        this.threadLocalVariables = HashOperations.newEmptyHash(context, language);
        this.recursiveObjects = HashOperations.newEmptyHash(context, language);
        this.recursiveObjectsSingle = HashOperations.newEmptyHash(context, language);
        this.recursiveObjectsSingle.compareByIdentity = true;
        this.randomizer = PRNGRandomizerNodes.newRandomizer(context, language, false);
        this.reportOnException = reportOnException;
        this.abortOnException = abortOnException;
        this.threadGroup = threadGroup;
        this.sourceLocation = sourceLocation;
        VarHandle.storeStoreFence();
        this.currentFiber = this.rootFiber = new RubyFiber(context.getCoreLibrary().fiberClass, language.fiberShape, context, language, this, RubyFiber.FiberStatus.RESUMED, "root");
    }

    public RubyFiber getRootFiber() {
        return this.rootFiber;
    }

    public RubyFiber getCurrentFiber() {
        assert (RubyLanguage.getCurrentLanguage().getCurrentThread() == this) : "Trying to read the current Fiber of another Thread which is inherently racy";
        return this.currentFiber;
    }

    public RubyFiber getCurrentFiberRacy() {
        return this.currentFiber;
    }

    public void setCurrentFiber(RubyFiber fiber) {
        this.currentFiber = fiber;
    }

    public ThreadLocalBuffer getIoBuffer(RubyContext context) {
        Pointer.checkNativeAccess(context);
        return this.ioBuffer;
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        ObjectGraph.addProperty(reachable, this.threadLocalVariables);
        ObjectGraph.addProperty(reachable, this.name);
        reachable.addAll(this.runningFibers);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.sourceLocation;
    }

    @CompilerDirectives.TruffleBoundary
    private static Set<RubyFiber> newFiberSet() {
        return ConcurrentHashMap.newKeySet();
    }
}

