/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import java.util.Timer;
import java.util.TimerTask;
import org.truffleruby.signal.LibRubySignal;

final class NativeCallInterrupter
implements TruffleSafepoint.Interrupter {
    private final Timer timer;
    private final long threadID;
    private Task currentTask = null;

    NativeCallInterrupter(Timer timer, long threadID) {
        this.timer = timer;
        this.threadID = threadID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt(Thread thread) {
        NativeCallInterrupter nativeCallInterrupter = this;
        synchronized (nativeCallInterrupter) {
            Task task;
            Task previousTask = this.currentTask;
            if (previousTask != null) {
                previousTask.cancel();
            }
            this.currentTask = task = new Task(this.threadID);
            this.timer.schedule((TimerTask)task, 0L, 100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInterrupted() {
        NativeCallInterrupter nativeCallInterrupter = this;
        synchronized (nativeCallInterrupter) {
            Task task = this.currentTask;
            if (task != null) {
                task.cancel();
            }
        }
    }

    static final class Task
    extends TimerTask {
        private static final int PERIOD = 100;
        private static final int MAX_TIME = 5000;
        private static final int MAX_EXECUTIONS = 50;
        private final long threadID;
        private int executed = 0;
        private boolean cancelled = false;

        Task(long threadID) {
            this.threadID = threadID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            Task task = this;
            synchronized (task) {
                this.cancelled = true;
                return super.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Task task = this;
            synchronized (task) {
                if (this.cancelled) {
                    return;
                }
                if (this.executed < 50) {
                    ++this.executed;
                    int result = LibRubySignal.sendSIGVTALRMToThread((long)this.threadID);
                    if (result != 0) {
                        throw CompilerDirectives.shouldNotReachHere((String)String.format("pthread_kill(%x, SIGVTALRM) failed with result=%d", this.threadID, result));
                    }
                } else {
                    this.cancel();
                }
            }
        }
    }
}

