/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.ArrayList;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.basicobject.ReferenceEqualNode;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.cast.ToIntNode;
import org.truffleruby.core.cast.ToLongNode;
import org.truffleruby.core.cast.ToRubyIntegerNode;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.support.TypeNodesFactory;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.FreezeNode;
import org.truffleruby.language.objects.IsANode;
import org.truffleruby.language.objects.IsFrozenNode;
import org.truffleruby.language.objects.LogicalClassNode;
import org.truffleruby.language.objects.MetaClassNode;
import org.truffleruby.language.objects.SingletonClassNode;
import org.truffleruby.language.objects.WriteObjectFieldNode;

@CoreModule(value="Truffle::Type")
public abstract class TypeNodes {

    @Primitive(name="as_boolean")
    public static abstract class AsBooleanNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean asBoolean(Object value, @Cached BooleanCastNode booleanCastNode) {
            return booleanCastNode.execute(this, value);
        }
    }

    @Primitive(name="undefined?")
    public static abstract class IsUndefinedNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isUndefined(Object value) {
            return value == NotProvided.INSTANCE;
        }
    }

    @Primitive(name="check_real?")
    public static abstract class CheckRealNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean check(int value) {
            return true;
        }

        @Specialization
        boolean check(long value) {
            return true;
        }

        @Specialization
        boolean check(double value) {
            return true;
        }

        @Fallback
        static boolean other(Object value, @Cached IsANode isANode, @Cached InlinedConditionProfile numericProfile, @Cached DispatchNode isRealNode, @Cached BooleanCastNode booleanCastNode, @Bind(value="this") Node node) {
            return numericProfile.profile(node, isANode.executeIsA(value, CheckRealNode.coreLibrary((Node)node).numericClass)) && booleanCastNode.execute(node, isRealNode.call(value, "real?"));
        }
    }

    @Primitive(name="check_mutable_string")
    public static abstract class CheckMutableStringNode
    extends PrimitiveArrayArgumentsNode {
        public static CheckMutableStringNode create(RubyNode node) {
            return TypeNodesFactory.CheckMutableStringNodeFactory.create(new RubyNode[]{node});
        }

        @Specialization
        Object check(RubyString value, @Cached InlinedBranchProfile errorProfile) {
            if (value.locked) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("can't modify string; temporarily locked", this));
            }
            if (value.frozen) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().frozenError((Object)value, this));
            }
            return value;
        }

        @Specialization
        Object checkImmutable(ImmutableRubyString value) {
            throw new RaiseException(this.getContext(), this.coreExceptions().frozenError(value, this));
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CheckFrozenNode
    extends RubyBaseNode {
        public abstract void execute(Node var1, Object var2);

        @Specialization
        static void check(Node node, Object value, @Cached(inline=false) IsFrozenNode isFrozenNode, @Cached InlinedBranchProfile errorProfile) {
            if (isFrozenNode.execute(value)) {
                errorProfile.enter(node);
                throw new RaiseException(CheckFrozenNode.getContext(node), CheckFrozenNode.coreExceptions(node).frozenError(value, node));
            }
        }
    }

    @Primitive(name="check_frozen")
    public static abstract class TypeCheckFrozenNode
    extends PrimitiveArrayArgumentsNode {
        @NeverDefault
        public static TypeCheckFrozenNode create(RubyNode rubyNode) {
            return TypeNodesFactory.TypeCheckFrozenNodeFactory.create(new RubyNode[]{rubyNode});
        }

        @Specialization
        Object check(Object value, @Cached CheckFrozenNode checkFrozenNode) {
            checkFrozenNode.execute(this, value);
            return value;
        }
    }

    @Primitive(name="rb_to_int")
    public static abstract class RbToIntNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object toRubyInteger(Object value, @Cached ToRubyIntegerNode toRubyInteger) {
            return toRubyInteger.execute(this, value);
        }
    }

    @Primitive(name="rb_num2int")
    public static abstract class RbNum2IntPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int numToInt(Object value, @Cached ToIntNode toIntNode) {
            return toIntNode.execute(value);
        }
    }

    @Primitive(name="rb_num2long")
    public static abstract class RbNum2LongPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long numToLong(Object value, @Cached ToLongNode toLongNode) {
            return toLongNode.execute(this, value);
        }
    }

    @Primitive(name="module_name")
    public static abstract class ModuleNameNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object moduleName(RubyModule module) {
            return module.fields.getRubyStringName();
        }
    }

    @Primitive(name="rb_any_to_s")
    public static abstract class ObjectToSNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString toS(Object obj, @Cached KernelNodes.ToSNode kernelToSNode) {
            return kernelToSNode.execute(obj);
        }
    }

    @Primitive(name="object_hidden_var_set")
    public static abstract class ObjectHiddenVarSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object objectHiddenVarSet(RubyDynamicObject object, Object identifier, Object value, @Cached WriteObjectFieldNode writeNode) {
            writeNode.execute(this, object, identifier, value);
            return value;
        }
    }

    @Primitive(name="object_hidden_var_get")
    public static abstract class ObjectHiddenVarGetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="getDynamicObjectCacheLimit()")
        Object objectHiddenVarGet(RubyDynamicObject object, Object identifier, @CachedLibrary(value="object") DynamicObjectLibrary objectLibrary) {
            return objectLibrary.getOrDefault((DynamicObject)object, identifier, (Object)nil);
        }

        @Fallback
        Object immutable(Object object, Object identifier) {
            return nil;
        }
    }

    @Primitive(name="object_hidden_var_defined?")
    public static abstract class ObjectHiddenVarDefinedNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="getDynamicObjectCacheLimit()")
        boolean objectHiddenVarDefined(RubyDynamicObject object, Object identifier, @CachedLibrary(value="object") DynamicObjectLibrary objectLibrary) {
            return objectLibrary.containsKey((DynamicObject)object, identifier);
        }

        @Fallback
        boolean immutable(Object object, Object identifier) {
            return false;
        }
    }

    @Primitive(name="object_hidden_var_create")
    public static abstract class ObjectHiddenVarCreateNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        HiddenKey createHiddenVar(RubySymbol identifier) {
            return new HiddenKey(identifier.getString());
        }
    }

    @Primitive(name="object_ivar_set")
    public static abstract class ObjectIVarSetPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object ivarSet(RubyDynamicObject object, RubySymbol name, Object value, @Cached WriteObjectFieldNode writeNode) {
            writeNode.execute(this, object, name.getString(), value);
            return value;
        }
    }

    @Primitive(name="object_ivar_get")
    public static abstract class ObjectIVarGetPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="getDynamicObjectCacheLimit()")
        Object ivarGet(RubyDynamicObject object, RubySymbol name, @CachedLibrary(value="object") DynamicObjectLibrary objectLibrary) {
            return objectLibrary.getOrDefault((DynamicObject)object, (Object)name.getString(), (Object)nil);
        }
    }

    @Primitive(name="object_ivar_defined?")
    public static abstract class ObjectIVarIsDefinedNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="getDynamicObjectCacheLimit()")
        boolean ivarIsDefined(RubyDynamicObject object, RubySymbol name, @CachedLibrary(value="object") DynamicObjectLibrary objectLibrary) {
            return objectLibrary.containsKey((DynamicObject)object, (Object)name.getString());
        }

        @Fallback
        boolean ivarIsDefinedNonDynamic(Object object, Object name) {
            return false;
        }
    }

    @Primitive(name="object_ivars")
    public static abstract class ObjectInstanceVariablesNode
    extends PrimitiveArrayArgumentsNode {
        @NeverDefault
        public static ObjectInstanceVariablesNode create() {
            return TypeNodesFactory.ObjectInstanceVariablesNodeFactory.create(null);
        }

        public abstract RubyArray executeGetIVars(Object var1);

        @Specialization(limit="getDynamicObjectCacheLimit()")
        static RubyArray instanceVariables(RubyDynamicObject object, @CachedLibrary(value="object") DynamicObjectLibrary objectLibrary, @Cached InlinedConditionProfile noPropertiesProfile, @Bind(value="this") Node node) {
            Shape shape = objectLibrary.getShape((DynamicObject)object);
            if (noPropertiesProfile.profile(node, shape.getPropertyCount() == 0)) {
                return ObjectInstanceVariablesNode.createEmptyArray(node);
            }
            return ObjectInstanceVariablesNode.createIVarNameArray(node, objectLibrary.getKeyArray((DynamicObject)object));
        }

        @Specialization(guards={"!isRubyDynamicObject(object)"})
        RubyArray instanceVariablesNotDynamic(Object object) {
            return this.createEmptyArray();
        }

        @CompilerDirectives.TruffleBoundary
        private static RubyArray createIVarNameArray(Node node, Object[] keys) {
            ArrayList<String> names = new ArrayList<String>(keys.length);
            for (Object name : keys) {
                if (!(name instanceof String)) continue;
                names.add((String)name);
            }
            int size = names.size();
            Object[] nameSymbols = new Object[size];
            for (int i = 0; i < size; ++i) {
                nameSymbols[i] = ObjectInstanceVariablesNode.getSymbol(node, (String)names.get(i));
            }
            return ObjectInstanceVariablesNode.createArray(node, nameSymbols);
        }
    }

    @Primitive(name="false?")
    public static abstract class IsFalse
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean bool(boolean value) {
            return !value;
        }

        @Fallback
        boolean other(Object value) {
            return false;
        }
    }

    @Primitive(name="true?")
    public static abstract class IsTrue
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean bool(boolean value) {
            return value;
        }

        @Fallback
        boolean other(Object value) {
            return false;
        }
    }

    @Primitive(name="boolean_or_nil?")
    public static abstract class IsBooleanOrNilNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean bool(boolean value) {
            return true;
        }

        @Specialization
        boolean nil(Nil value) {
            return true;
        }

        @Fallback
        boolean other(Object value) {
            return false;
        }
    }

    @Primitive(name="nil?")
    public static abstract class IsNilNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isNil(Object value) {
            return value == nil;
        }
    }

    @Primitive(name="immediate_value?")
    public static abstract class IsImmediateValueNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean doBoolean(boolean value) {
            return true;
        }

        @Specialization
        boolean doInt(int value) {
            return true;
        }

        @Specialization
        boolean doLong(long value) {
            return true;
        }

        @Specialization
        boolean doFloat(double value) {
            return true;
        }

        @Specialization
        boolean doSymbol(RubySymbol value) {
            return true;
        }

        @Specialization
        boolean doNil(Nil value) {
            return true;
        }

        @Fallback
        boolean doFallback(Object value) {
            return false;
        }
    }

    @Primitive(name="freeze")
    public static abstract class FreezePrimitive
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object freeze(Object self, @Cached ObjectFreezeNode objectFreezeNode) {
            return objectFreezeNode.execute(self);
        }
    }

    public static abstract class ObjectFreezeNode
    extends RubyBaseNode {
        public abstract Object execute(Object var1);

        @Specialization(guards={"!isRubyDynamicObject(self)"})
        Object freeze(Object self, @Cached @Cached.Exclusive FreezeNode freezeNode) {
            freezeNode.execute(this, self);
            return self;
        }

        @Specialization
        static Object freezeSingletonObject(RubyDynamicObject self, @Cached @Cached.Exclusive FreezeNode freezeNode, @Cached MetaClassNode metaClassNode, @Cached InlinedConditionProfile singletonClassUnfrozenProfile, @Cached IsFrozenNode isFrozenMetaClassNode, @Cached @Cached.Exclusive FreezeNode freezeMetaClasNode, @Bind(value="this") Node node) {
            RubyClass metaClass = metaClassNode.execute(node, (Object)self);
            if (metaClass.isSingleton && singletonClassUnfrozenProfile.profile(node, !RubyGuards.isSingletonClass((Object)self) && !isFrozenMetaClassNode.execute(metaClass))) {
                freezeMetaClasNode.execute(node, metaClass);
            }
            freezeNode.execute(node, (Object)self);
            return self;
        }
    }

    @Primitive(name="equal?")
    public static abstract class EqualPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean equal(Object a, Object b, @Cached ReferenceEqualNode referenceEqualNode) {
            return referenceEqualNode.execute(this, a, b);
        }
    }

    @Primitive(name="singleton_class")
    public static abstract class SingletonClassPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyClass singletonClass(Object object, @Cached SingletonClassNode singletonClassNode) {
            return singletonClassNode.execute(object);
        }
    }

    @Primitive(name="metaclass")
    public static abstract class MetaClassPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyClass metaClass(Object object, @Cached MetaClassNode metaClassNode) {
            return metaClassNode.execute(this, object);
        }
    }

    @Primitive(name="class")
    public static abstract class ClassPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyClass objectClass(Object object, @Cached LogicalClassNode logicalClassNode) {
            return logicalClassNode.execute(object);
        }
    }

    @Primitive(name="respond_to?")
    public static abstract class RespondToPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean respondTo(Object object, RubySymbol name, boolean includePrivate, @Cached KernelNodes.RespondToNode respondToNode) {
            return respondToNode.executeDoesRespondTo(object, name, includePrivate);
        }
    }

    @Primitive(name="is_a?")
    public static abstract class IsAPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isA(Object object, RubyModule module, @Cached IsANode isANode) {
            return isANode.executeIsA(object, module);
        }
    }
}

