/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigInteger;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.FixnumOrBignumNode;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.support.GetRandomIntNode;
import org.truffleruby.core.support.RubyRandomizer;

@CoreModule(value="Truffle::Randomizer", isClass=true)
public abstract class RandomizerNodes {

    @CoreMethod(names={"random_integer"}, required=1)
    public static abstract class RandomIntNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GetRandomIntNode getRandomIntNode = GetRandomIntNode.create();

        @Specialization
        int randomizerRandInt(RubyRandomizer randomizer, int limit) {
            return (int)this.randLimitedFixnumInner(randomizer, limit);
        }

        @Specialization
        long randomizerRandInt(RubyRandomizer randomizer, long limit) {
            return this.randLimitedFixnumInner(randomizer, limit);
        }

        @Specialization
        Object randomizerRandInt(RubyRandomizer randomizer, RubyBignum limit, @Cached FixnumOrBignumNode fixnumOrBignum) {
            return fixnumOrBignum.execute(this, this.randLimitedBignum(randomizer, limit.value));
        }

        @CompilerDirectives.TruffleBoundary
        public long randLimitedFixnumInner(RubyRandomizer randomizer, long limit) {
            long val;
            if (limit == 0L) {
                val = 0L;
            } else {
                long mask = RandomIntNode.makeMask(limit);
                block0: while (true) {
                    val = 0L;
                    for (int i = 1; 0 <= i; --i) {
                        if ((mask >>> i * 32 & 0xFFFFFFFFL) != 0L) {
                            val |= ((long)this.getRandomIntNode.execute((Object)randomizer) & 0xFFFFFFFFL) << i * 32;
                            val &= mask;
                        }
                        if (limit < val) continue block0;
                    }
                    break;
                }
            }
            return val;
        }

        @CompilerDirectives.TruffleBoundary
        private BigInteger randLimitedBignum(RubyRandomizer randomizer, BigInteger limit) {
            byte[] buf = BigIntegerOps.toByteArray(limit);
            byte[] bytes = new byte[buf.length];
            int len = (buf.length + 3) / 4;
            block0: while (true) {
                long mask = 0L;
                boolean boundary = true;
                for (int idx = len - 1; 0 <= idx; --idx) {
                    long rnd;
                    long lim = (long)RandomIntNode.getIntBigIntegerBuffer(buf, idx) & 0xFFFFFFFFL;
                    long l = mask = mask != 0L ? 0xFFFFFFFFL : RandomIntNode.makeMask(lim);
                    if (mask != 0L) {
                        rnd = (long)this.getRandomIntNode.execute((Object)randomizer) & 0xFFFFFFFFL & mask;
                        if (boundary) {
                            if (lim < rnd) continue block0;
                            if (rnd < lim) {
                                boundary = false;
                            }
                        }
                    } else {
                        rnd = 0L;
                    }
                    RandomIntNode.setIntBigIntegerBuffer(bytes, idx, (int)rnd);
                }
                break;
            }
            return BigIntegerOps.create(bytes);
        }

        private static int getIntBigIntegerBuffer(byte[] src, int loc) {
            int v = 0;
            int idx = src.length - loc * 4 - 1;
            if (idx >= 0) {
                v |= src[idx--] & 0xFF;
                if (idx >= 0) {
                    v |= (src[idx--] & 0xFF) << 8;
                    if (idx >= 0) {
                        v |= (src[idx--] & 0xFF) << 16;
                        if (idx >= 0) {
                            v |= (src[idx--] & 0xFF) << 24;
                        }
                    }
                }
            }
            return v;
        }

        private static void setIntBigIntegerBuffer(byte[] dest, int loc, int value) {
            int idx = dest.length - loc * 4 - 1;
            if (idx >= 0) {
                dest[idx--] = (byte)(value & 0xFF);
                if (idx >= 0) {
                    dest[idx--] = (byte)(value >> 8 & 0xFF);
                    if (idx >= 0) {
                        dest[idx--] = (byte)(value >> 16 & 0xFF);
                        if (idx >= 0) {
                            dest[idx--] = (byte)(value >> 24 & 0xFF);
                        }
                    }
                }
            }
        }

        private static long makeMask(long x) {
            x |= x >>> 1;
            x |= x >>> 2;
            x |= x >>> 4;
            x |= x >>> 8;
            x |= x >>> 16;
            x |= x >>> 32;
            return x;
        }
    }

    @CoreMethod(names={"random_float"})
    public static abstract class RandomFloatNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        double randomFloat(RubyRandomizer randomizer, @Cached GetRandomIntNode getRandomIntNode) {
            int a = getRandomIntNode.execute((Object)randomizer) >>> 5;
            int b = getRandomIntNode.execute((Object)randomizer) >>> 6;
            return ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
        }
    }
}

