/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.algorithms.Randomizer;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.numeric.BignumOperations;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.support.RubyPRNGRandomizer;

@CoreModule(value="Truffle::PRNGRandomizer", isClass=true)
public abstract class PRNGRandomizerNodes {
    public static RubyPRNGRandomizer newRandomizer(RubyContext context, RubyLanguage language, boolean threadSafe) {
        RubyBignum seed = RandomizerGenSeedNode.randomSeedBignum(context);
        Randomizer randomizer = RandomizerSetSeedNode.randomFromBignum(seed);
        return new RubyPRNGRandomizer(context.getCoreLibrary().prngRandomizerClass, language.prngRandomizerShape, randomizer, threadSafe);
    }

    public static void resetSeed(RubyContext context, RubyPRNGRandomizer random) {
        RubyBignum seed = RandomizerGenSeedNode.randomSeedBignum(context);
        Randomizer randomizer = RandomizerSetSeedNode.randomFromBignum(seed);
        random.setRandomizer(randomizer);
    }

    @CoreMethod(names={"generate_seed"}, needsSelf=false)
    public static abstract class RandomizerGenSeedNode
    extends CoreMethodArrayArgumentsNode {
        private static final int DEFAULT_SEED_CNT = 4;

        @Specialization
        RubyBignum generateSeed() {
            return RandomizerGenSeedNode.randomSeedBignum(this.getContext());
        }

        @CompilerDirectives.TruffleBoundary
        public static RubyBignum randomSeedBignum(RubyContext context) {
            byte[] seed = context.getRandomSeedBytes(16);
            BigInteger bigInteger = new BigInteger(seed).abs();
            return BignumOperations.createBignum(bigInteger);
        }
    }

    @CoreMethod(names={"seed="}, required=1)
    public static abstract class RandomizerSetSeedNode
    extends CoreMethodArrayArgumentsNode {
        private static final int N = 624;

        @Specialization
        RubyPRNGRandomizer setSeed(RubyPRNGRandomizer randomizer, long seed) {
            randomizer.setRandomizer(RandomizerSetSeedNode.randomFromLong(seed));
            return randomizer;
        }

        @Specialization
        RubyPRNGRandomizer setSeed(RubyPRNGRandomizer randomizer, RubyBignum seed) {
            randomizer.setRandomizer(RandomizerSetSeedNode.randomFromBignum(seed));
            return randomizer;
        }

        @CompilerDirectives.TruffleBoundary
        static Randomizer randomFromLong(long seed) {
            long v = Math.abs(seed);
            if (v == (v & 0xFFFFFFFFL)) {
                return new Randomizer((Object)seed, (int)v);
            }
            int[] ints = new int[]{(int)v, (int)(v >> 32)};
            return new Randomizer((Object)seed, ints);
        }

        @CompilerDirectives.TruffleBoundary
        static Randomizer randomFromBignum(RubyBignum seed) {
            BigInteger big = seed.value;
            if (big.signum() < 0) {
                big = big.abs();
            }
            byte[] buf = big.toByteArray();
            int buflen = buf.length;
            if (buf[0] == 0) {
                --buflen;
            }
            int len = Math.min((buflen + 3) / 4, 624);
            int[] ints = RandomizerSetSeedNode.bigEndianToInts(buf, len);
            if (len <= 1) {
                return new Randomizer((Object)seed, ints[0]);
            }
            return new Randomizer((Object)seed, ints);
        }

        private static int[] bigEndianToInts(byte[] buf, int initKeyLen) {
            int[] initKey = new int[initKeyLen];
            for (int idx = 0; idx < initKey.length; ++idx) {
                initKey[idx] = RandomizerSetSeedNode.getIntBigIntegerBuffer(buf, idx);
            }
            return initKey;
        }

        static int getIntBigIntegerBuffer(byte[] src, int loc) {
            int v = 0;
            int idx = src.length - loc * 4 - 1;
            if (idx >= 0) {
                v |= src[idx--] & 0xFF;
                if (idx >= 0) {
                    v |= (src[idx--] & 0xFF) << 8;
                    if (idx >= 0) {
                        v |= (src[idx--] & 0xFF) << 16;
                        if (idx >= 0) {
                            v |= (src[idx--] & 0xFF) << 24;
                        }
                    }
                }
            }
            return v;
        }
    }

    @Primitive(name="randomizer_bytes", lowerFixnum={1})
    public static abstract class RandomizerBytesPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString genRandBytes(RubyPRNGRandomizer randomizer, int length, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
            int i;
            int r;
            byte[] bytes = new byte[length];
            int idx = 0;
            while (length >= 4) {
                r = randomizer.genrandInt32();
                for (i = 0; i < 4; ++i) {
                    bytes[idx++] = (byte)(r & 0xFF);
                    r >>>= 8;
                }
                length -= 4;
            }
            if (length > 0) {
                r = randomizer.genrandInt32();
                for (i = 0; i < length; ++i) {
                    bytes[idx++] = (byte)(r & 0xFF);
                    r >>>= 8;
                }
            }
            return this.createString(fromByteArrayNode, bytes, Encodings.BINARY);
        }
    }

    @CoreMethod(names={"seed"})
    public static abstract class RandomizerSeedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object seed(RubyPRNGRandomizer randomizer) {
            return randomizer.getSeed();
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyPRNGRandomizer randomizerAllocate(RubyClass randomizerClass) {
            boolean threadSafe = true;
            return new RubyPRNGRandomizer(this.coreLibrary().prngRandomizerClass, this.getLanguage().prngRandomizerShape, new Randomizer(), true);
        }
    }
}

