/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.support.RubyIO;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.extra.ffi.RubyPointer;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="IO", isClass=true)
public abstract class IONodes {

    @Primitive(name="io_thread_buffer_free")
    public static abstract class IOThreadBufferFreeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getThreadBuffer(RubyPointer pointer, @Cached InlinedConditionProfile freeProfile) {
            RubyThread thread = this.getLanguage().getCurrentThread();
            thread.getIoBuffer(this.getContext()).free(this, thread, pointer.pointer, freeProfile);
            return nil;
        }
    }

    @Primitive(name="io_thread_buffer_allocate")
    public static abstract class IOThreadBufferAllocateNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyPointer getThreadBuffer(long size, @Cached InlinedConditionProfile sizeProfile) {
            RubyThread thread = this.getLanguage().getCurrentThread();
            RubyPointer instance = new RubyPointer(this.coreLibrary().truffleFFIPointerClass, this.getLanguage().truffleFFIPointerShape, IOThreadBufferAllocateNode.getBuffer(this, this.getContext(), thread, size, sizeProfile));
            AllocationTracing.trace(instance, this);
            return instance;
        }

        public static Pointer getBuffer(Node node, RubyContext context, RubyThread rubyThread, long size, InlinedConditionProfile sizeProfile) {
            return rubyThread.getIoBuffer(context).allocate(node, context, rubyThread, size, sizeProfile);
        }
    }

    @Primitive(name="io_write_polyglot", lowerFixnum={0})
    public static abstract class IOWritePolyglotNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(string)"}, limit="1")
        int write(int fd, Object string, @Cached RubyStringLibrary strings) {
            OutputStream stream = switch (fd) {
                case 1 -> this.getContext().getEnv().out();
                case 2 -> this.getContext().getEnv().err();
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            InternalByteArray byteArray = strings.getTString(string).getInternalByteArrayUncached(strings.getTEncoding(string));
            this.getContext().getThreadManager().runUntilResult(this, () -> {
                try {
                    stream.write(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
                }
                catch (IOException e) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().ioError(e, (Node)this));
                }
                return true;
            });
            return byteArray.getLength();
        }
    }

    @Primitive(name="io_read_polyglot", lowerFixnum={0})
    public static abstract class IOReadPolyglotNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object read(int length, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
            InputStream stream = this.getContext().getEnv().in();
            byte[] buffer = new byte[length];
            int bytesRead = this.getContext().getThreadManager().runUntilResult(this, () -> {
                try {
                    return stream.read(buffer, 0, length);
                }
                catch (IOException e) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().ioError(e, (Node)this));
                }
            });
            if (bytesRead < 0) {
                return nil;
            }
            byte[] bytes = bytesRead == buffer.length ? buffer : Arrays.copyOf(buffer, bytesRead);
            return this.createString(fromByteArrayNode, bytes, Encodings.BINARY);
        }
    }

    @CoreMethod(names={"ensure_open"}, visibility=Visibility.PRIVATE)
    public static abstract class IOEnsureOpenPrimitiveNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object ensureOpen(RubyIO io, @Cached InlinedBranchProfile errorProfile) {
            int fd = io.getDescriptor();
            if (fd == -1) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().ioError("closed stream", (Node)this));
            }
            assert (fd >= 0);
            return nil;
        }
    }

    @Primitive(name="file_fnmatch", lowerFixnum={2})
    public static abstract class FileFNMatchPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        private static final int FNM_NOESCAPE = 1;
        private static final int FNM_PATHNAME = 2;
        private static final int FNM_DOTMATCH = 4;
        private static final int FNM_CASEFOLD = 8;
        public static final int FNM_NOMATCH = 1;

        @Specialization(guards={"stringsPattern.isRubyString(pattern)", "stringsPath.isRubyString(path)"}, limit="1")
        boolean fnmatch(Object pattern, Object path, int flags, @Cached RubyStringLibrary stringsPattern, @Cached RubyStringLibrary stringsPath, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayPatternNode, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayPathNode) {
            InternalByteArray patternByteArray = getInternalByteArrayPatternNode.execute(stringsPattern.getTString(pattern), stringsPattern.getTEncoding(pattern));
            InternalByteArray pathByteArray = getInternalByteArrayPathNode.execute(stringsPath.getTString(path), stringsPath.getTEncoding(path));
            return FileFNMatchPrimitiveNode.fnmatch(patternByteArray.getArray(), patternByteArray.getOffset(), patternByteArray.getEnd(), pathByteArray.getArray(), pathByteArray.getOffset(), pathByteArray.getEnd(), flags) != 1;
        }

        private static boolean isdirsep(char c) {
            return c == '/';
        }

        private static boolean isdirsep(byte c) {
            return FileFNMatchPrimitiveNode.isdirsep((char)(c & 0xFF));
        }

        private static int rb_path_next(byte[] _s, int s, int send) {
            while (s < send && !FileFNMatchPrimitiveNode.isdirsep(_s[s])) {
                ++s;
            }
            return s;
        }

        private static int fnmatch_helper(byte[] bytes, int pstart, int pend, byte[] string, int sstart, int send, int flags) {
            boolean nocase;
            int s = sstart;
            int pat = pstart;
            boolean escape = (flags & 1) == 0;
            boolean pathname = (flags & 2) != 0;
            boolean period = (flags & 4) == 0;
            boolean bl = nocase = (flags & 8) != 0;
            block6: while (pat < pend) {
                int c = bytes[pat++] & 0xFF;
                switch (c) {
                    case 63: {
                        if (s >= send || pathname && FileFNMatchPrimitiveNode.isdirsep(string[s]) || period && string[s] == 46 && (s == sstart || pathname && FileFNMatchPrimitiveNode.isdirsep(string[s - 1]))) {
                            return 1;
                        }
                        ++s;
                        continue block6;
                    }
                    case 42: {
                        while (pat < pend) {
                            char c2 = (char)(bytes[pat++] & 0xFF);
                            c = c2;
                            if (c2 == '*') continue;
                        }
                        if (s < send && period && string[s] == 46 && (s == sstart || pathname && FileFNMatchPrimitiveNode.isdirsep(string[s - 1]))) {
                            return 1;
                        }
                        if (pat > pend || pat == pend && c == 42) {
                            if (pathname && FileFNMatchPrimitiveNode.rb_path_next(string, s, send) < send) {
                                return 1;
                            }
                            return 0;
                        }
                        if (pathname && FileFNMatchPrimitiveNode.isdirsep((char)c)) {
                            if ((s = FileFNMatchPrimitiveNode.rb_path_next(string, s, send)) < send) {
                                ++s;
                                continue block6;
                            }
                            return 1;
                        }
                        char test = (char)(escape && c == 92 && pat < pend ? bytes[pat] & 0xFF : c);
                        test = Character.toLowerCase(test);
                        --pat;
                        while (s < send) {
                            if ((c == 63 || c == 91 || Character.toLowerCase((char)string[s]) == test) && FileFNMatchPrimitiveNode.fnmatch(bytes, pat, pend, string, s, send, flags | 4) == 0) {
                                return 0;
                            }
                            if (pathname && FileFNMatchPrimitiveNode.isdirsep(string[s])) break;
                            ++s;
                        }
                        return 1;
                    }
                    case 91: {
                        if (s >= send || pathname && FileFNMatchPrimitiveNode.isdirsep(string[s]) || period && string[s] == 46 && (s == sstart || pathname && FileFNMatchPrimitiveNode.isdirsep(string[s - 1]))) {
                            return 1;
                        }
                        if ((pat = FileFNMatchPrimitiveNode.range(bytes, pat, pend, (char)(string[s] & 0xFF), flags)) == -1) {
                            return 1;
                        }
                        ++s;
                        continue block6;
                    }
                    case 92: {
                        if (!escape) break;
                        c = pat >= pend ? 92 : (int)((char)(bytes[pat++] & 0xFF));
                    }
                }
                if (s >= send) {
                    return 1;
                }
                if (nocase ? Character.toLowerCase((char)c) != Character.toLowerCase((char)string[s]) : c != (char)(string[s] & 0xFF)) {
                    return 1;
                }
                ++s;
            }
            return s >= send ? 0 : 1;
        }

        @CompilerDirectives.TruffleBoundary
        public static int fnmatch(byte[] bytes, int pstart, int pend, byte[] string, int sstart, int send, int flags) {
            boolean period = (flags & 4) == 0;
            boolean pathname = (flags & 2) != 0;
            int pat_pos = pstart;
            int str_pos = sstart;
            int ptmp = -1;
            int stmp = -1;
            if (pathname) {
                while (true) {
                    int strSlashIdx;
                    int patSlashIdx;
                    if (FileFNMatchPrimitiveNode.isDoubleStarAndSlash(bytes, pat_pos)) {
                        while (FileFNMatchPrimitiveNode.isDoubleStarAndSlash(bytes, pat_pos += 3)) {
                        }
                        ptmp = pat_pos;
                        stmp = str_pos;
                    }
                    if (FileFNMatchPrimitiveNode.fnmatch_helper(bytes, pat_pos, patSlashIdx = FileFNMatchPrimitiveNode.nextSlashIndex(bytes, pat_pos, pend), string, str_pos, strSlashIdx = FileFNMatchPrimitiveNode.nextSlashIndex(string, str_pos, send), flags) == 0) {
                        if (patSlashIdx < pend && strSlashIdx < send) {
                            pat_pos = ++patSlashIdx;
                            str_pos = ++strSlashIdx;
                            continue;
                        }
                        if (patSlashIdx == pend && strSlashIdx == send) {
                            return 0;
                        }
                    }
                    if (ptmp == -1 || stmp == -1 || period && stmp < string.length && string[stmp] == 46 || (stmp = FileFNMatchPrimitiveNode.nextSlashIndex(string, stmp, send)) >= send) break;
                    pat_pos = ptmp;
                    str_pos = ++stmp;
                }
                return 1;
            }
            return FileFNMatchPrimitiveNode.fnmatch_helper(bytes, pstart, pend, string, sstart, send, flags);
        }

        private static boolean isDoubleStarAndSlash(byte[] bytes, int pos) {
            if (bytes.length - pos <= 2) {
                return false;
            }
            return bytes[pos] == 42 && bytes[pos + 1] == 42 && bytes[pos + 2] == 47;
        }

        private static int nextSlashIndex(byte[] bytes, int start, int end) {
            int idx;
            for (idx = start; idx < end && idx < bytes.length && bytes[idx] != 47; ++idx) {
            }
            return idx;
        }

        private static int range(byte[] _pat, int pat, int pend, char test, int flags) {
            boolean not;
            boolean ok = false;
            boolean nocase = (flags & 8) != 0;
            boolean escape = (flags & 1) == 0;
            boolean bl = not = _pat[pat] == 33 || _pat[pat] == 94;
            if (not) {
                ++pat;
            }
            if (nocase) {
                test = Character.toLowerCase(test);
            }
            while (_pat[pat] != 93) {
                char cend;
                if (escape && _pat[pat] == 92) {
                    ++pat;
                }
                if (pat >= pend) {
                    return -1;
                }
                char cstart = cend = (char)(_pat[pat++] & 0xFF);
                if (pat < pend - 1 && _pat[pat] == 45 && _pat[pat + 1] != 93) {
                    if (escape && _pat[++pat] == 92) {
                        ++pat;
                    }
                    if (pat >= pend) {
                        return -1;
                    }
                    cend = (char)(_pat[pat++] & 0xFF);
                }
                if (nocase) {
                    if (Character.toLowerCase(cstart) <= test && test <= Character.toLowerCase(cend)) {
                        ok = true;
                    }
                } else if (cstart <= test && test <= cend) {
                    ok = true;
                }
                if (pat < pend) continue;
                return -1;
            }
            return ok == not ? -1 : pat + 1;
        }
    }

    @Primitive(name="io_set_fd", lowerFixnum={1})
    public static abstract class IOSetFDNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyIO fd(RubyIO io, int fd) {
            io.setDescriptor(fd);
            return io;
        }
    }

    @Primitive(name="io_fd")
    public static abstract class IOFDNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int fd(RubyIO io) {
            return io.getDescriptor();
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyIO allocate(RubyClass rubyClass) {
            RubyIO instance = new RubyIO(rubyClass, this.getLanguage().ioShape, -1);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

