/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.Objects;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.StringGuards;
import org.truffleruby.core.string.TStringWithEncoding;

abstract class TStringWithEncodingBase {
    public final AbstractTruffleString tstring;
    public final RubyEncoding encoding;

    protected TStringWithEncodingBase(AbstractTruffleString tstring, RubyEncoding encoding) {
        assert (tstring.isCompatibleToUncached(encoding.tencoding));
        this.tstring = tstring;
        this.encoding = encoding;
    }

    public abstract TStringWithEncoding asImmutable();

    public final RubyEncoding getEncoding() {
        return this.encoding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TStringWithEncodingBase that = (TStringWithEncodingBase)o;
        return this.encoding == that.encoding && this.tstring.equals((Object)that.tstring);
    }

    public int hashCode() {
        return Objects.hash(this.tstring, this.encoding);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.tstring.toStringDebug();
    }

    public int byteLength() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.byteLength(this.encoding.tencoding);
    }

    public int characterLength() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.codePointLengthUncached(this.encoding.tencoding);
    }

    public InternalByteArray getInternalByteArray() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.getInternalByteArrayUncached(this.encoding.tencoding);
    }

    public TruffleString.CodeRange getCodeRange() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.getByteCodeRangeUncached(this.encoding.tencoding);
    }

    public TStringWithEncoding forceEncoding(RubyEncoding newEncoding) {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return new TStringWithEncoding(this.tstring.forceEncodingUncached(this.encoding.tencoding, newEncoding.tencoding), newEncoding);
    }

    public boolean isAsciiOnly() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return StringGuards.is7BitUncached(this.tstring, this.encoding);
    }

    public int get(int index) {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.readByteUncached(index, this.encoding.tencoding);
    }

    public byte getByte(int index) {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return (byte)this.tstring.readByteUncached(index, this.encoding.tencoding);
    }

    public TStringWithEncoding substring(int byteOffset, int length) {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return new TStringWithEncoding(this.tstring.substringByteIndexUncached(byteOffset, length, this.encoding.tencoding, true), this.encoding);
    }

    public TruffleString substringAsTString(int byteOffset, int length) {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.substringByteIndexUncached(byteOffset, length, this.encoding.tencoding, true);
    }

    public String toJavaString() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.toJavaStringUncached();
    }

    public String toJavaStringOrThrow() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return TStringUtils.toJavaStringOrThrow(this.tstring, this.encoding);
    }

    public TruffleStringIterator createCodePointIterator() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return TruffleString.CreateCodePointIteratorNode.getUncached().execute(this.tstring, this.encoding.tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
    }

    public boolean isSingleByteOptimizable() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.isAsciiOnly() || this.encoding.isSingleByte;
    }

    public byte[] getBytesCopy() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.copyToByteArrayUncached(this.encoding.tencoding);
    }

    public byte[] getBytesOrCopy() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return TStringUtils.getBytesOrCopy(this.tstring, this.encoding);
    }

    public int characterLength(int byteOffset) {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.tstring.byteLengthOfCodePointUncached(byteOffset, this.encoding.tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
    }
}

