/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.Arrays;
import org.graalvm.collections.Pair;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.IntHolder;
import org.graalvm.shadowed.org.jcodings.ascii.AsciiTables;
import org.graalvm.shadowed.org.jcodings.specific.ASCIIEncoding;
import org.graalvm.shadowed.org.jcodings.specific.UTF8Encoding;
import org.graalvm.shadowed.org.jcodings.util.IntHash;
import org.truffleruby.RubyContext;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.collections.IntHashMap;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.ATStringWithEncoding;
import org.truffleruby.core.string.EncodingUtils;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.utils.Utils;

public final class StringSupport {
    public static final int TRANS_SIZE = 256;
    private static final int CASE_MAP_BUFFER_SIZE = 32;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final byte[] NON_ASCII_NEEDLE = new byte[]{-1};
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final byte[] NON_ASCII_MASK = new byte[]{127};
    private static final Object DUMMY_VALUE = "";
    private static final byte[] FORCE_ENCODING_BYTES = StringOperations.encodeAsciiBytes(".force_encoding(\"");
    private static final byte[] HEXDIGIT = StringOperations.encodeAsciiBytes("0123456789abcdef0123456789ABCDEF");
    private static final String INVALID_FORMAT_MESSAGE = "invalid dumped string; not wrapped with '\"' nor '\"...\".force_encoding(\"...\")' form";

    private static int characterLength(Encoding encoding, TruffleString.CodeRange codeRange, byte[] bytes, int byteOffset, int byteEnd) {
        assert (byteOffset >= 0 && byteOffset < byteEnd && byteEnd <= bytes.length);
        if (codeRange == null) {
            return StringSupport.preciseLength(encoding, bytes, byteOffset, byteEnd);
        }
        switch (codeRange) {
            case ASCII: {
                return 1;
            }
            case VALID: {
                return StringSupport.characterLengthValid(encoding, bytes, byteOffset, byteEnd);
            }
            case BROKEN: {
                return StringSupport.preciseLength(encoding, bytes, byteOffset, byteEnd);
            }
        }
        throw Utils.unsupportedOperation("unknown code range value: ", codeRange);
    }

    public static int characterLength(RubyEncoding encoding, byte[] bytes, int byteOffset, int byteEnd) {
        assert (byteOffset >= 0 && byteOffset < byteEnd && byteEnd <= bytes.length);
        return StringSupport.preciseLength(encoding.jcoding, bytes, byteOffset, byteEnd);
    }

    private static int characterLengthValid(Encoding encoding, byte[] bytes, int byteOffset, int byteEnd) {
        if (encoding.isUTF8()) {
            return StringSupport.utf8CharWidth(bytes[byteOffset]);
        }
        if (encoding.isAsciiCompatible()) {
            if (bytes[byteOffset] >= 0) {
                return 1;
            }
            return StringSupport.encLength(encoding, bytes, byteOffset, byteEnd);
        }
        if (encoding.isFixedWidth()) {
            int width = encoding.minLength();
            assert (byteEnd - byteOffset >= width);
            return width;
        }
        return StringSupport.encLength(encoding, bytes, byteOffset, byteEnd);
    }

    public static int utf8CharWidth(byte b) {
        if (b >= 0) {
            return 1;
        }
        switch (b & 0xF0) {
            case 224: {
                return 3;
            }
            case 240: {
                return 4;
            }
        }
        return 2;
    }

    @CompilerDirectives.TruffleBoundary
    private static int encLength(Encoding enc, byte[] bytes, int p, int e) {
        return enc.length(bytes, p, e);
    }

    public static int length(Encoding enc, byte[] bytes, int p, int end) {
        int n = StringSupport.encLength(enc, bytes, p, end);
        if (StringSupport.MBCLEN_CHARFOUND_P(n) && StringSupport.MBCLEN_CHARFOUND_LEN(n) <= end - p) {
            return StringSupport.MBCLEN_CHARFOUND_LEN(n);
        }
        int min = enc.minLength();
        return min <= end - p ? min : end - p;
    }

    private static int preciseLength(Encoding enc, byte[] bytes, int p, int end) {
        if (p >= end) {
            return StringSupport.MBCLEN_NEEDMORE(1);
        }
        int n = StringSupport.encLength(enc, bytes, p, end);
        if (n > end - p) {
            return StringSupport.MBCLEN_NEEDMORE(n - (end - p));
        }
        return n;
    }

    public static boolean MBCLEN_NEEDMORE_P(int r) {
        return r < -1;
    }

    public static int MBCLEN_NEEDMORE_LEN(int r) {
        return -1 - r;
    }

    public static int MBCLEN_NEEDMORE(int n) {
        return -1 - n;
    }

    public static boolean MBCLEN_INVALID_P(int r) {
        return r == -1;
    }

    public static int MBCLEN_CHARFOUND_LEN(int r) {
        assert (StringSupport.MBCLEN_CHARFOUND_P(r));
        return r;
    }

    public static boolean MBCLEN_CHARFOUND_P(int r) {
        return 0 < r;
    }

    public static int searchNonAscii(InternalByteArray byteArray, int start) {
        int offset = byteArray.getOffset();
        return StringSupport.searchNonAscii(byteArray.getArray(), offset + start, byteArray.getEnd()) - offset;
    }

    public static int searchNonAscii(byte[] bytes, int p, int end) {
        return com.oracle.truffle.api.ArrayUtils.indexOfWithOrMask((byte[])bytes, (int)p, (int)(end - p), (byte[])NON_ASCII_NEEDLE, (byte[])NON_ASCII_MASK);
    }

    @CompilerDirectives.TruffleBoundary
    public static int strLength(RubyEncoding encoding, byte[] bytes, int p, int e) {
        TruffleString tstring = TruffleString.FromByteArrayNode.getUncached().execute(bytes, p, e - p, encoding.tencoding, false);
        return tstring.codePointLengthUncached(encoding.tencoding);
    }

    public static int codePoint(Encoding enc, byte[] bytes, int p, int end, Node node) {
        return StringSupport.codePoint(enc, null, bytes, p, end, node);
    }

    @CompilerDirectives.TruffleBoundary
    public static int codePoint(Encoding enc, TruffleString.CodeRange codeRange, byte[] bytes, int p, int end, Node node) {
        if (p >= end) {
            RubyContext context = RubyContext.get(node);
            throw new RaiseException(context, context.getCoreExceptions().argumentError("empty string", node));
        }
        int cl = StringSupport.characterLength(enc, codeRange, bytes, p, end);
        if (cl <= 0) {
            RubyContext context = RubyContext.get(node);
            throw new RaiseException(context, context.getCoreExceptions().argumentError("invalid byte sequence in " + String.valueOf(enc), node));
        }
        return enc.mbcToCode(bytes, p, end);
    }

    @CompilerDirectives.TruffleBoundary
    public static int codeLength(Encoding enc, int c) {
        return enc.codeToMbcLength(c);
    }

    @CompilerDirectives.TruffleBoundary
    public static int mbcToCode(Encoding encoding, byte[] bytes, int p, int end) {
        return encoding.mbcToCode(bytes, p, end);
    }

    public static int offset(int start, int end, int charEnd) {
        return charEnd == -1 ? end - start : Math.min(end, charEnd) - start;
    }

    public static int scanHex(byte[] bytes, int p, int len) {
        return StringSupport.scanHex(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    @CompilerDirectives.TruffleBoundary
    public static int scanHex(byte[] bytes, int p, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isXDigit(c = bytes[p++] & 0xFF)) {
            v = (v << 4) + enc.xdigitVal(c);
        }
        return v;
    }

    public static int hexLength(byte[] bytes, int p, int len) {
        return StringSupport.hexLength(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    @CompilerDirectives.TruffleBoundary
    public static int hexLength(byte[] bytes, int p, int len, Encoding enc) {
        int hlen = 0;
        while (len-- > 0 && enc.isXDigit(bytes[p++] & 0xFF)) {
            ++hlen;
        }
        return hlen;
    }

    public static int scanOct(byte[] bytes, int p, int len) {
        return StringSupport.scanOct(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    @CompilerDirectives.TruffleBoundary
    public static int scanOct(byte[] bytes, int p, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isDigit(c = bytes[p++] & 0xFF) && c < 56) {
            v = (v << 3) + Encoding.digitVal((int)c);
        }
        return v;
    }

    public static int octLength(byte[] bytes, int p, int len) {
        return StringSupport.octLength(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    @CompilerDirectives.TruffleBoundary
    public static int octLength(byte[] bytes, int p, int len, Encoding enc) {
        int c;
        int olen = 0;
        while (len-- > 0 && enc.isDigit(c = bytes[p++] & 0xFF) && c < 56) {
            ++olen;
        }
        return olen;
    }

    public static String escapedCharFormat(int c, boolean isUnicode) {
        String format = isUnicode ? (((long)c & 0xFFFFFFFFL) < 127L && Encoding.isAscii((int)c) && ASCIIEncoding.INSTANCE.isPrint(c) ? "%c" : (c < 65536 ? "\\u%04X" : "\\u{%X}")) : (((long)c & 0xFFFFFFFFL) < 256L ? "\\x%02X" : "\\x{%X}");
        return format;
    }

    @CompilerDirectives.TruffleBoundary
    public static int strCount(InternalByteArray byteArray, TruffleString.CodeRange codeRange, boolean[] table, TrTables tables, Encoding enc, Node node) {
        byte[] bytes = byteArray.getArray();
        int p = byteArray.getOffset();
        int end = byteArray.getEnd();
        boolean asciiCompat = enc.isAsciiCompatible();
        int count = 0;
        while (p < end) {
            int c;
            if (asciiCompat && (c = bytes[p] & 0xFF) < 128) {
                if (table[c]) {
                    ++count;
                }
                ++p;
                continue;
            }
            c = StringSupport.codePoint(enc, codeRange, bytes, p, end, node);
            int cl = StringSupport.codeLength(enc, c);
            if (StringSupport.trFind(c, table, tables)) {
                ++count;
            }
            p += cl;
        }
        return count;
    }

    public static char[] bytesToChars(InternalByteArray byteArray) {
        int byteLength = byteArray.getLength();
        char[] chars = new char[byteLength];
        for (int n = 0; n < byteLength; ++n) {
            chars[n] = (char)byteArray.get(n);
        }
        return chars;
    }

    private static int encAscget(byte[] pBytes, int p, int e, int[] len, Encoding enc, TruffleString.CodeRange codeRange) {
        if (e <= p) {
            return -1;
        }
        if (EncodingUtils.encAsciicompat(enc)) {
            int c = pBytes[p] & 0xFF;
            if (!Encoding.isAscii((byte)((byte)c))) {
                return -1;
            }
            if (len != null) {
                len[0] = 1;
            }
            return c;
        }
        int l = StringSupport.characterLength(enc, codeRange, pBytes, p, e);
        if (!StringSupport.MBCLEN_CHARFOUND_P(l)) {
            return -1;
        }
        int c = enc.mbcToCode(pBytes, p, e);
        if (!Encoding.isAscii((int)c)) {
            return -1;
        }
        if (len != null) {
            len[0] = l;
        }
        return c;
    }

    @CompilerDirectives.TruffleBoundary
    private static int encCodepointLength(byte[] pBytes, int p, int e, int[] len_p, Encoding enc, TruffleString.CodeRange codeRange, Node node) {
        if (e <= p) {
            RubyContext context = RubyContext.get(node);
            throw new RaiseException(context, context.getCoreExceptions().argumentError("empty string", node));
        }
        int r = StringSupport.characterLength(enc, codeRange, pBytes, p, e);
        if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
            RubyContext context = RubyContext.get(node);
            throw new RaiseException(context, context.getCoreExceptions().argumentError("invalid byte sequence in " + String.valueOf(enc), node));
        }
        if (len_p != null) {
            len_p[0] = StringSupport.MBCLEN_CHARFOUND_LEN(r);
        }
        return StringSupport.codePoint(enc, codeRange, pBytes, p, e, node);
    }

    @CompilerDirectives.TruffleBoundary
    public static TrTables trSetupTable(AbstractTruffleString str, RubyEncoding encoding, boolean[] stable, TrTables tables, boolean first, Encoding enc, Node node) {
        int c;
        int i;
        boolean cflag;
        int[] l = new int[]{0};
        TR tr = new TR(str, encoding);
        TruffleString.CodeRange codeRange = str.getByteCodeRangeUncached(encoding.tencoding);
        if (str.byteLength(encoding.tencoding) > 1 && StringSupport.encAscget(tr.buf, tr.p, tr.pend, l, enc, codeRange) == 94) {
            cflag = true;
            tr.p += l[0];
        } else {
            cflag = false;
        }
        if (first) {
            for (i = 0; i < 256; ++i) {
                stable[i] = true;
            }
            stable[256] = cflag;
        } else if (stable[256] && !cflag) {
            stable[256] = false;
        }
        if (tables == null) {
            tables = new TrTables();
        }
        byte[] buf = null;
        IntHashMap<Object> table = null;
        IntHashMap<Object> ptable = null;
        while ((c = StringSupport.trNext(tr, enc, codeRange, node)) != -1) {
            if (c < 256) {
                if (buf == null) {
                    buf = new byte[256];
                    for (i = 0; i < 256; ++i) {
                        buf[i] = (byte)(cflag ? 1 : 0);
                    }
                }
                buf[c & 0xFF] = (byte)(!cflag ? 1 : 0);
                continue;
            }
            if (table == null && (first || tables.del != null || stable[256])) {
                if (cflag) {
                    ptable = tables.noDel;
                    table = ptable != null ? ptable : new IntHashMap<Object>(8);
                    tables.noDel = table;
                } else {
                    table = new IntHashMap<Object>(8);
                    ptable = tables.del;
                    tables.del = table;
                }
            }
            if (table == null) continue;
            int key = c;
            if (ptable == null) {
                table.put(key, DUMMY_VALUE);
                continue;
            }
            if (cflag) {
                table.put(key, DUMMY_VALUE);
                continue;
            }
            boolean val = ptable.get(key) != null;
            table.put(key, val ? DUMMY_VALUE : null);
        }
        if (buf != null) {
            for (i = 0; i < 256; ++i) {
                stable[i] = stable[i] && buf[i] != 0;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                stable[i] = stable[i] && cflag;
            }
        }
        if (table == null && !cflag) {
            tables.del = null;
        }
        return tables;
    }

    public static boolean trFind(int c, boolean[] table, TrTables tables) {
        if (c < 256) {
            return table[c];
        }
        IntHashMap<Object> del = tables.del;
        IntHashMap<Object> noDel = tables.noDel;
        if (del != null) {
            if (del.get(c) != null && (noDel == null || noDel.get(c) == null)) {
                return true;
            }
        } else if (noDel != null && noDel.get(c) != null) {
            return false;
        }
        return table[256];
    }

    @CompilerDirectives.TruffleBoundary
    public static int trNext(TR tr, Encoding enc, TruffleString.CodeRange codeRange, Node node) {
        if (!tr.gen) {
            return StringSupport.trNext_nextpart(tr, enc, codeRange, node);
        }
        while (enc.codeToMbcLength(++tr.now) <= 0) {
            if (tr.now != tr.max) continue;
            tr.gen = false;
            return StringSupport.trNext_nextpart(tr, enc, codeRange, node);
        }
        if (tr.now < tr.max) {
            return tr.now;
        }
        tr.gen = false;
        return tr.max;
    }

    private static int trNext_nextpart(TR tr, Encoding enc, TruffleString.CodeRange codeRange, Node node) {
        int[] n = new int[]{0};
        if (tr.p == tr.pend) {
            return -1;
        }
        if (StringSupport.encAscget(tr.buf, tr.p, tr.pend, n, enc, codeRange) == 92 && tr.p + n[0] < tr.pend) {
            tr.p += n[0];
        }
        tr.now = StringSupport.encCodepointLength(tr.buf, tr.p, tr.pend, n, enc, codeRange, node);
        tr.p += n[0];
        if (StringSupport.encAscget(tr.buf, tr.p, tr.pend, n, enc, codeRange) == 45 && tr.p + n[0] < tr.pend) {
            tr.p += n[0];
            if (tr.p < tr.pend) {
                int c = StringSupport.encCodepointLength(tr.buf, tr.p, tr.pend, n, enc, codeRange, node);
                tr.p += n[0];
                if (tr.now > c) {
                    RubyContext context = RubyContext.get(node);
                    if (tr.now < 128 && c < 128) {
                        String message = "invalid range \"" + (char)tr.now + "-" + (char)c + "\" in string transliteration";
                        throw new RaiseException(context, context.getCoreExceptions().argumentError(message, node));
                    }
                    throw new RaiseException(context, context.getCoreExceptions().argumentError("invalid range in string transliteration", node));
                }
                tr.gen = true;
                tr.max = c;
            }
        }
        return tr.now;
    }

    @CompilerDirectives.TruffleBoundary
    public static TStringBuilder succCommon(RubyString original, Node node) {
        int end;
        byte[] carry = new byte[7];
        int carryP = 0;
        carry[0] = 1;
        int carryLen = 1;
        RubyEncoding encoding = original.getEncodingUncached();
        Encoding enc = encoding.jcoding;
        TStringBuilder valueCopy = TStringBuilder.create(original);
        int p = 0;
        int s = end = p + valueCopy.getLength();
        byte[] bytes = valueCopy.getUnsafeBytes();
        NeighborChar neighbor = NeighborChar.FOUND;
        int lastAlnum = -1;
        boolean alnumSeen = false;
        block5: while ((s = enc.prevCharHead(bytes, p, s, end)) != -1) {
            ASCIIEncoding ascii;
            if (neighbor == NeighborChar.NOT_CHAR && lastAlnum != -1 && ((ascii = ASCIIEncoding.INSTANCE).isAlpha(bytes[lastAlnum] & 0xFF) ? ascii.isDigit(bytes[s] & 0xFF) : ascii.isDigit(bytes[lastAlnum] & 0xFF) && ascii.isAlpha(bytes[s] & 0xFF))) {
                s = lastAlnum;
                break;
            }
            int cl = StringSupport.characterLength(encoding, bytes, s, end);
            if (cl <= 0) continue;
            neighbor = StringSupport.succAlnumChar(encoding, bytes, s, cl, carry, 0, node);
            switch (neighbor.ordinal()) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    return valueCopy;
                }
                case 2: {
                    lastAlnum = s;
                }
            }
            alnumSeen = true;
            carryP = s - p;
            carryLen = cl;
        }
        if (!alnumSeen) {
            s = end;
            while ((s = enc.prevCharHead(bytes, p, s, end)) != -1) {
                int cl = StringSupport.characterLength(encoding, bytes, s, end);
                if (cl <= 0) continue;
                neighbor = StringSupport.succChar(encoding, bytes, s, cl, node);
                if (neighbor == NeighborChar.FOUND) {
                    return valueCopy;
                }
                if (StringSupport.characterLength(encoding, bytes, s, s + 1) != cl) {
                    StringSupport.succChar(encoding, bytes, s, cl, node);
                }
                if (!encoding.isAsciiCompatible) {
                    System.arraycopy(bytes, s, carry, 0, cl);
                    carryLen = cl;
                }
                carryP = s - p;
            }
        }
        valueCopy.unsafeEnsureSpace(valueCopy.getLength() + carryLen);
        s = carryP;
        System.arraycopy(valueCopy.getUnsafeBytes(), s, valueCopy.getUnsafeBytes(), s + carryLen, valueCopy.getLength() - carryP);
        System.arraycopy(carry, 0, valueCopy.getUnsafeBytes(), s, carryLen);
        valueCopy.setLength(valueCopy.getLength() + carryLen);
        return valueCopy;
    }

    /*
     * Unable to fully structure code
     */
    public static NeighborChar succChar(RubyEncoding encoding, byte[] bytes, int p, int len, Node node) {
        enc = encoding.jcoding;
        if (enc.minLength() > 1) {
            r = StringSupport.characterLength(encoding, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            c = StringSupport.codePoint(enc, bytes, p, p + len, node) + 1;
            l = StringSupport.codeLength(enc, c);
            if (l == 0) {
                return NeighborChar.NOT_CHAR;
            }
            if (l != len) {
                return NeighborChar.WRAPPED;
            }
            enc.codeToMbc(c, bytes, p);
            r = StringSupport.characterLength(encoding, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            return NeighborChar.FOUND;
        }
        while (true) {
            for (i = len - 1; i >= 0 && bytes[p + i] == -1; --i) {
                bytes[p + i] = 0;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) + 1);
            l = StringSupport.characterLength(encoding, bytes, p, p + len);
            if (StringSupport.MBCLEN_CHARFOUND_P(l)) {
                if ((l = StringSupport.MBCLEN_CHARFOUND_LEN(l)) == len) {
                    return NeighborChar.FOUND;
                }
                start = p + l;
                end = start + (len - l);
                Arrays.fill(bytes, start, end, (byte)-1);
            }
            if (!StringSupport.MBCLEN_INVALID_P(l) || i >= len - 1) ** continue;
            for (len2 = len - 1; 0 < len2 && StringSupport.MBCLEN_INVALID_P(l2 = StringSupport.characterLength(encoding, bytes, p, p + len2)); --len2) {
            }
            start = p + len2 + 1;
            end = start + len - (len2 + 1);
            Arrays.fill(bytes, start, end, (byte)-1);
        }
    }

    private static NeighborChar succAlnumChar(RubyEncoding encoding, byte[] bytes, int p, int len, byte[] carry, int carryP, Node node) {
        int cType;
        Encoding enc = encoding.jcoding;
        byte[] save = new byte[7];
        int c = enc.mbcToCode(bytes, p, p + len);
        if (enc.isDigit(c)) {
            cType = 4;
        } else if (enc.isAlpha(c)) {
            cType = 1;
        } else {
            return NeighborChar.NOT_CHAR;
        }
        System.arraycopy(bytes, p, save, 0, len);
        NeighborChar ret = StringSupport.succChar(encoding, bytes, p, len, node);
        if (ret == NeighborChar.FOUND && enc.isCodeCType(c = enc.mbcToCode(bytes, p, p + len), cType)) {
            return NeighborChar.FOUND;
        }
        System.arraycopy(save, 0, bytes, p, len);
        int range = 1;
        while (true) {
            System.arraycopy(bytes, p, save, 0, len);
            ret = StringSupport.predChar(encoding, bytes, p, len, node);
            if (ret == NeighborChar.FOUND) {
                c = enc.mbcToCode(bytes, p, p + len);
                if (!enc.isCodeCType(c, cType)) {
                    System.arraycopy(save, 0, bytes, p, len);
                    break;
                }
            } else {
                System.arraycopy(save, 0, bytes, p, len);
                break;
            }
            ++range;
        }
        if (range == 1) {
            return NeighborChar.NOT_CHAR;
        }
        if (cType != 4) {
            System.arraycopy(bytes, p, carry, carryP, len);
            return NeighborChar.WRAPPED;
        }
        System.arraycopy(bytes, p, carry, carryP, len);
        StringSupport.succChar(encoding, carry, carryP, len, node);
        return NeighborChar.WRAPPED;
    }

    /*
     * Unable to fully structure code
     */
    private static NeighborChar predChar(RubyEncoding encoding, byte[] bytes, int p, int len, Node node) {
        enc = encoding.jcoding;
        if (enc.minLength() > 1) {
            r = StringSupport.characterLength(encoding, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            c = StringSupport.codePoint(enc, bytes, p, p + len, node);
            if (c == 0) {
                return NeighborChar.NOT_CHAR;
            }
            if ((l = StringSupport.codeLength(enc, --c)) == 0) {
                return NeighborChar.NOT_CHAR;
            }
            if (l != len) {
                return NeighborChar.WRAPPED;
            }
            enc.codeToMbc(c, bytes, p);
            r = StringSupport.characterLength(encoding, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            return NeighborChar.FOUND;
        }
        while (true) {
            for (i = len - 1; i >= 0 && bytes[p + i] == 0; --i) {
                bytes[p + i] = -1;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) - 1);
            l = StringSupport.characterLength(encoding, bytes, p, p + len);
            if (StringSupport.MBCLEN_CHARFOUND_P(l)) {
                if ((l = StringSupport.MBCLEN_CHARFOUND_LEN(l)) == len) {
                    return NeighborChar.FOUND;
                }
                start = p + l;
                end = start + (len - l);
                Arrays.fill(bytes, start, end, (byte)0);
            }
            if (StringSupport.MBCLEN_CHARFOUND_P(l) || i >= len - 1) ** continue;
            for (len2 = len - 1; 0 < len2 && StringSupport.MBCLEN_INVALID_P(l2 = StringSupport.characterLength(encoding, bytes, p, p + len2)); --len2) {
            }
            start = p + len2 + 1;
            end = start + (len - (len2 + 1));
            Arrays.fill(bytes, start, end, (byte)0);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString delete_bangCommon19(ATStringWithEncoding rubyString, boolean[] squeeze, TrTables tables, RubyEncoding encoding, Node node) {
        TruffleString.CodeRange cr;
        int s;
        Encoding enc = encoding.jcoding;
        int t = s = 0;
        int send = s + rubyString.byteLength();
        byte[] bytes = rubyString.getBytesCopy();
        boolean modified = false;
        boolean asciiCompatible = encoding.isAsciiCompatible;
        TruffleString.CodeRange codeRange = cr = asciiCompatible ? TruffleString.CodeRange.ASCII : TruffleString.CodeRange.VALID;
        while (s < send) {
            int c;
            if (asciiCompatible && Encoding.isAscii((int)(c = bytes[s] & 0xFF))) {
                if (squeeze[c]) {
                    modified = true;
                } else {
                    if (t != s) {
                        bytes[t] = (byte)c;
                    }
                    ++t;
                }
                ++s;
                continue;
            }
            c = StringSupport.codePoint(enc, rubyString.getCodeRange(), bytes, s, send, node);
            int cl = StringSupport.codeLength(enc, c);
            if (StringSupport.trFind(c, squeeze, tables)) {
                modified = true;
            } else {
                if (t != s) {
                    enc.codeToMbc(c, bytes, t);
                }
                t += cl;
                if (cr == TruffleString.CodeRange.ASCII) {
                    cr = TruffleString.CodeRange.VALID;
                }
            }
            s += cl;
        }
        return modified ? TStringUtils.fromByteArray(ArrayUtils.extractRange(bytes, 0, t), encoding) : null;
    }

    private static TruffleString.CodeRange CHECK_IF_ASCII(int c, TruffleString.CodeRange currentCodeRange) {
        if (currentCodeRange == TruffleString.CodeRange.ASCII && !Encoding.isAscii((int)c)) {
            return TruffleString.CodeRange.VALID;
        }
        return currentCodeRange;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString trTransHelper(ATStringWithEncoding self, ATStringWithEncoding srcStr, ATStringWithEncoding replStr, Encoding e1, RubyEncoding rubyEncoding, boolean sflag, Node node) {
        TruffleString ret;
        int c;
        Encoding enc = rubyEncoding.jcoding;
        TruffleString.CodeRange cr = self.getCodeRange();
        TR trSrc = new TR(srcStr.tstring, srcStr.encoding);
        boolean cflag = false;
        int[] l = new int[]{0};
        if (srcStr.byteLength() > 1 && StringSupport.encAscget(trSrc.buf, trSrc.p, trSrc.pend, l, enc, srcStr.getCodeRange()) == 94 && trSrc.p + 1 < trSrc.pend) {
            cflag = true;
            ++trSrc.p;
        }
        int last = 0;
        int[] trans = new int[256];
        TR trRepl = new TR(replStr.tstring, replStr.encoding);
        boolean modified = false;
        IntHash hash = null;
        boolean singlebyte = self.isSingleByteOptimizable();
        if (cflag) {
            for (i = 0; i < 256; ++i) {
                trans[i] = 1;
            }
            while ((c = StringSupport.trNext(trSrc, enc, srcStr.getCodeRange(), node)) != -1) {
                if (c < 256) {
                    trans[c] = -1;
                    continue;
                }
                if (hash == null) {
                    hash = new IntHash();
                }
                hash.put(c, (Object)1);
            }
            while ((c = StringSupport.trNext(trRepl, enc, replStr.getCodeRange(), node)) != -1) {
            }
            last = trRepl.now;
            for (i = 0; i < 256; ++i) {
                if (trans[i] == -1) continue;
                trans[i] = last;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                trans[i] = -1;
            }
            while ((c = StringSupport.trNext(trSrc, enc, srcStr.getCodeRange(), node)) != -1) {
                int r = StringSupport.trNext(trRepl, enc, replStr.getCodeRange(), node);
                if (r == -1) {
                    r = trRepl.now;
                }
                if (c < 256) {
                    trans[c] = r;
                    if (StringSupport.codeLength(enc, r) == 1) continue;
                    singlebyte = false;
                    continue;
                }
                if (hash == null) {
                    hash = new IntHash();
                }
                hash.put(c, (Object)r);
            }
        }
        if (cr == TruffleString.CodeRange.VALID && rubyEncoding.isAsciiCompatible) {
            cr = TruffleString.CodeRange.ASCII;
        }
        int send = self.byteLength();
        if (sflag) {
            byte[] sbytes = self.getBytesOrCopy();
            int max = self.byteLength();
            int save = -1;
            byte[] buf = new byte[max];
            int t = 0;
            while (s < send) {
                Integer tmp;
                boolean mayModify = false;
                int c0 = c = StringSupport.codePoint(e1, sbytes, s, send, node);
                int clen = StringSupport.codeLength(e1, c);
                int tlen = enc == e1 ? clen : StringSupport.codeLength(enc, c);
                s += clen;
                c = c < 256 ? StringSupport.trCode(c, trans, (IntHash<Integer>)hash, cflag, last, false) : (hash != null ? ((tmp = (Integer)hash.get(c)) == null ? (cflag ? last : -1) : (cflag ? -1 : tmp)) : -1);
                if (c != -1) {
                    if (save == c) {
                        cr = StringSupport.CHECK_IF_ASCII(c, cr);
                        continue;
                    }
                    save = c;
                    tlen = StringSupport.codeLength(enc, c);
                    modified = true;
                } else {
                    save = -1;
                    c = c0;
                    if (enc != e1) {
                        mayModify = true;
                    }
                }
                while (t + tlen >= max) {
                    buf = Arrays.copyOf(buf, max *= 2);
                }
                enc.codeToMbc(c, buf, t);
                if (mayModify && (s >= send || !ArrayUtils.regionEquals(sbytes, s, buf, t, tlen))) {
                    modified = true;
                }
                cr = StringSupport.CHECK_IF_ASCII(c, cr);
                t += tlen;
            }
            ret = TStringUtils.fromByteArray(ArrayUtils.extractRange(buf, 0, t), rubyEncoding);
        } else if (rubyEncoding.isSingleByte || singlebyte && hash == null) {
            byte[] sbytes = self.getBytesCopy();
            for (s = 0; s < send; ++s) {
                c = sbytes[s] & 0xFF;
                if (trans[c] != -1) {
                    if (!cflag) {
                        c = trans[c];
                        sbytes[s] = (byte)c;
                    } else {
                        sbytes[s] = (byte)last;
                    }
                    modified = true;
                }
                cr = StringSupport.CHECK_IF_ASCII(c, cr);
            }
            ret = TStringUtils.fromByteArray(sbytes, rubyEncoding);
        } else {
            byte[] sbytes = self.getBytesOrCopy();
            int max = (int)((double)self.byteLength() * 1.2);
            byte[] buf = new byte[max];
            int t = 0;
            while (s < send) {
                int tlen;
                boolean mayModify = false;
                int c0 = c = StringSupport.codePoint(e1, sbytes, s, send, node);
                int clen = StringSupport.codeLength(e1, c);
                int n = tlen = enc == e1 ? clen : StringSupport.codeLength(enc, c);
                if (c < 256) {
                    c = trans[c];
                } else if (hash != null) {
                    Integer tmp = (Integer)hash.get(c);
                    c = tmp == null ? (cflag ? last : -1) : (cflag ? -1 : tmp);
                } else {
                    int n2 = c = cflag ? last : -1;
                }
                if (c != -1) {
                    tlen = StringSupport.codeLength(enc, c);
                    modified = true;
                } else {
                    c = c0;
                    if (enc != e1) {
                        mayModify = true;
                    }
                }
                while (t + tlen >= max) {
                    buf = Arrays.copyOf(buf, max <<= 1);
                }
                enc.codeToMbc(c, buf, t);
                if (mayModify && !ArrayUtils.regionEquals(sbytes, s, buf, t, tlen)) {
                    modified = true;
                }
                cr = StringSupport.CHECK_IF_ASCII(c, cr);
                s += clen;
                t += tlen;
            }
            ret = TStringUtils.fromByteArray(ArrayUtils.extractRange(buf, 0, t), rubyEncoding);
        }
        if (modified) {
            return ret;
        }
        return null;
    }

    private static int trCode(int c, int[] trans, IntHash<Integer> hash, boolean cflag, int last, boolean set) {
        if (c < 256) {
            return trans[c];
        }
        if (hash != null) {
            Integer tmp = (Integer)hash.get(c);
            if (tmp == null) {
                return cflag ? last : -1;
            }
            return cflag ? -1 : tmp;
        }
        return cflag && set ? last : -1;
    }

    @CompilerDirectives.TruffleBoundary
    public static int multiByteCasecmp(RubyEncoding enc, AbstractTruffleString selfTString, TruffleString.Encoding selfEncoding, AbstractTruffleString otherTString, TruffleString.Encoding otherEncoding) {
        TruffleStringIterator selfIterator = TruffleString.CreateCodePointIteratorNode.getUncached().execute(selfTString, selfEncoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
        TruffleStringIterator otherIterator = TruffleString.CreateCodePointIteratorNode.getUncached().execute(otherTString, otherEncoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
        while (selfIterator.hasNext() && otherIterator.hasNext()) {
            int ocl;
            int selfPos = selfIterator.getByteIndex();
            int c = selfIterator.nextUncached();
            int otherPos = otherIterator.getByteIndex();
            int oc = otherIterator.nextUncached();
            if (enc.isAsciiCompatible && c >= 0 && Encoding.isAscii((int)c) && oc >= 0 && Encoding.isAscii((int)oc)) {
                byte uc = AsciiTables.ToUpperCaseTable[c];
                byte uoc = AsciiTables.ToUpperCaseTable[oc];
                if (uc == uoc) continue;
                return uc < uoc ? -1 : 1;
            }
            int cl = selfIterator.getByteIndex() - selfPos;
            int ret = StringSupport.caseCmp(selfTString, selfEncoding, otherTString, otherEncoding, selfPos, otherPos, Math.min(cl, ocl = otherIterator.getByteIndex() - otherPos));
            if (ret != 0) {
                return ret < 0 ? -1 : 1;
            }
            if (cl == ocl) continue;
            return cl < ocl ? -1 : 1;
        }
        if (!selfIterator.hasNext() && !otherIterator.hasNext()) {
            return 0;
        }
        return selfIterator.hasNext() ? 1 : -1;
    }

    private static int caseCmp(AbstractTruffleString a, TruffleString.Encoding aEncoding, AbstractTruffleString b, TruffleString.Encoding bEncoding, int aPos, int bPos, int len) {
        int i;
        for (i = 0; i < len && a.readByteUncached(aPos + i, aEncoding) == b.readByteUncached(bPos + i, bEncoding); ++i) {
        }
        if (i < len) {
            return a.readByteUncached(aPos + i, aEncoding) > b.readByteUncached(bPos + i, bEncoding) ? 1 : -1;
        }
        return 0;
    }

    public static boolean singleByteSqueeze(TStringBuilder value, boolean[] squeeze) {
        int s;
        int t = s = 0;
        int send = s + value.getLength();
        byte[] bytes = value.getUnsafeBytes();
        int save = -1;
        while (s < send) {
            int c;
            if ((c = bytes[s++] & 0xFF) == save && squeeze[c]) continue;
            int n = t++;
            save = c;
            bytes[n] = (byte)save;
        }
        if (t != value.getLength()) {
            value.setLength(t);
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean multiByteSqueeze(TStringBuilder value, TruffleString.CodeRange originalCodeRange, boolean[] squeeze, TrTables tables, Encoding enc, boolean isArg, Node node) {
        int s;
        int t = s = 0;
        int send = s + value.getLength();
        byte[] bytes = value.getUnsafeBytes();
        int save = -1;
        while (s < send) {
            int c;
            if (enc.isAsciiCompatible() && (c = bytes[s] & 0xFF) < 128) {
                if (c != save || isArg && !squeeze[c]) {
                    int n = t++;
                    save = c;
                    bytes[n] = (byte)save;
                }
                ++s;
                continue;
            }
            c = StringSupport.codePoint(enc, originalCodeRange, bytes, s, send, node);
            int cl = StringSupport.codeLength(enc, c);
            if (c != save || isArg && !StringSupport.trFind(c, squeeze, tables)) {
                if (t != s) {
                    enc.codeToMbc(c, bytes, t);
                }
                save = c;
                t += cl;
            }
            s += cl;
        }
        if (t != value.getLength()) {
            value.setLength(t);
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private static int caseMapChar(int codePoint, Encoding enc, byte[] stringBytes, int stringByteOffset, ByteArrayBuilder builder, IntHolder flags, byte[] workBuffer) {
        int newByteLength;
        IntHolder fromP = new IntHolder();
        fromP.value = stringByteOffset;
        int clen = enc.codeToMbcLength(codePoint);
        if (clen == (newByteLength = enc.caseMap(flags, stringBytes, fromP, fromP.value + clen, workBuffer, 0, workBuffer.length))) {
            System.arraycopy(workBuffer, 0, stringBytes, stringByteOffset, newByteLength);
        } else {
            int tailLength = stringBytes.length - (stringByteOffset + clen);
            int newBufferLength = stringByteOffset + newByteLength + tailLength;
            byte[] newBuffer = Arrays.copyOf(stringBytes, newBufferLength);
            System.arraycopy(workBuffer, 0, newBuffer, stringByteOffset, newByteLength);
            System.arraycopy(stringBytes, stringByteOffset + clen, newBuffer, stringByteOffset + newByteLength, tailLength);
            builder.unsafeReplace(newBuffer, newBufferLength);
        }
        return newByteLength;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean swapCaseMultiByteComplex(Encoding enc, TruffleString.CodeRange originalCodeRange, ByteArrayBuilder builder, int caseMappingOptions, Node node) {
        byte[] buf = new byte[32];
        IntHolder flagP = new IntHolder();
        flagP.value = caseMappingOptions | 0x2000 | 0x4000;
        boolean modified = false;
        int s = 0;
        byte[] bytes = builder.getUnsafeBytes();
        while (s < bytes.length) {
            int c = StringSupport.codePoint(enc, originalCodeRange, bytes, s, bytes.length, node);
            if (enc.isUpper(c) || enc.isLower(c)) {
                s += StringSupport.caseMapChar(c, enc, bytes, s, builder, flagP, buf);
                modified = true;
                if (bytes == builder.getUnsafeBytes()) continue;
                bytes = builder.getUnsafeBytes();
                continue;
            }
            s += StringSupport.codeLength(enc, c);
        }
        return modified;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean downcaseMultiByteComplex(Encoding enc, TruffleString.CodeRange originalCodeRange, ByteArrayBuilder builder, int caseMappingOptions, Node node) {
        byte[] buf = new byte[32];
        IntHolder flagP = new IntHolder();
        flagP.value = caseMappingOptions | 0x4000;
        boolean isFold = (caseMappingOptions & 0x80000) != 0;
        boolean isTurkic = (caseMappingOptions & 0x100000) != 0;
        boolean modified = false;
        int s = 0;
        byte[] bytes = builder.getUnsafeBytes();
        while (s < bytes.length) {
            if (!isTurkic && enc.isAsciiCompatible() && StringSupport.isAsciiUppercase(bytes[s])) {
                int n = s++;
                bytes[n] = (byte)(bytes[n] ^ 0x20);
                modified = true;
                continue;
            }
            int c = StringSupport.codePoint(enc, originalCodeRange, bytes, s, bytes.length, node);
            if (isFold || enc.isUpper(c)) {
                s += StringSupport.caseMapChar(c, enc, bytes, s, builder, flagP, buf);
                modified = true;
                if (bytes == builder.getUnsafeBytes()) continue;
                bytes = builder.getUnsafeBytes();
                continue;
            }
            s += StringSupport.codeLength(enc, c);
        }
        return modified;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean upcaseMultiByteComplex(Encoding enc, TruffleString.CodeRange originalCodeRange, ByteArrayBuilder builder, int caseMappingOptions, Node node) {
        byte[] buf = new byte[32];
        IntHolder flagP = new IntHolder();
        flagP.value = caseMappingOptions | 0x2000;
        boolean isTurkic = (caseMappingOptions & 0x100000) != 0;
        boolean modified = false;
        int s = 0;
        byte[] bytes = builder.getUnsafeBytes();
        while (s < bytes.length) {
            if (!isTurkic && enc.isAsciiCompatible() && StringSupport.isAsciiLowercase(bytes[s])) {
                int n = s++;
                bytes[n] = (byte)(bytes[n] ^ 0x20);
                modified = true;
                continue;
            }
            int c = StringSupport.codePoint(enc, originalCodeRange, bytes, s, bytes.length, node);
            if (enc.isLower(c)) {
                s += StringSupport.caseMapChar(c, enc, bytes, s, builder, flagP, buf);
                modified = true;
                if (bytes == builder.getUnsafeBytes()) continue;
                bytes = builder.getUnsafeBytes();
                continue;
            }
            s += StringSupport.codeLength(enc, c);
        }
        return modified;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean capitalizeMultiByteComplex(Encoding enc, TruffleString.CodeRange originalCodeRange, ByteArrayBuilder builder, int caseMappingOptions, Node node) {
        byte[] buf = new byte[32];
        IntHolder flagP = new IntHolder();
        flagP.value = caseMappingOptions | 0x2000 | 0x8000;
        boolean isTurkic = (caseMappingOptions & 0x100000) != 0;
        boolean modified = false;
        int s = 0;
        byte[] bytes = builder.getUnsafeBytes();
        boolean upcasing = true;
        while (s < bytes.length) {
            if (!isTurkic && enc.isAsciiCompatible() && (upcasing && StringSupport.isAsciiLowercase(bytes[s]) || !upcasing && StringSupport.isAsciiUppercase(bytes[s]))) {
                int n = s++;
                bytes[n] = (byte)(bytes[n] ^ 0x20);
                modified = true;
            } else {
                int c = StringSupport.codePoint(enc, originalCodeRange, bytes, s, bytes.length, node);
                if (upcasing && enc.isLower(c) || !upcasing && enc.isUpper(c)) {
                    s += StringSupport.caseMapChar(c, enc, bytes, s, builder, flagP, buf);
                    modified = true;
                    if (bytes != builder.getUnsafeBytes()) {
                        bytes = builder.getUnsafeBytes();
                    }
                } else {
                    s += StringSupport.codeLength(enc, c);
                }
            }
            if (!upcasing) continue;
            upcasing = false;
            flagP.value = caseMappingOptions | 0x4000;
        }
        return modified;
    }

    public static boolean isAscii(int c) {
        return c >= 0 && c < 128;
    }

    public static boolean isAsciiLowercase(int c) {
        return c >= 97 && c <= 122;
    }

    public static boolean isAsciiLowercase(byte c) {
        return c >= 97 && c <= 122;
    }

    public static boolean isAsciiUppercase(int c) {
        return c >= 65 && c <= 90;
    }

    public static boolean isAsciiUppercase(byte c) {
        return c >= 65 && c <= 90;
    }

    public static boolean isAsciiSpace(int c) {
        return c == 32 || 9 <= c && c <= 13;
    }

    static boolean isAsciiSpaceOrNull(int c) {
        return c == 0 || StringSupport.isAsciiSpace(c);
    }

    public static boolean isAsciiPrintable(int c) {
        return c >= 32 && c <= 126;
    }

    @CompilerDirectives.TruffleBoundary
    public static Pair<TStringBuilder, RubyEncoding> undump(ATStringWithEncoding tstring, RubyEncoding encoding, RubyContext context, Node currentNode) {
        InternalByteArray byteArray = tstring.getInternalByteArray();
        byte[] bytes = byteArray.getArray();
        int start = byteArray.getOffset();
        int end = byteArray.getEnd();
        RubyEncoding resultEncoding = encoding;
        Encoding[] enc = new Encoding[]{encoding.jcoding};
        boolean[] utf8 = new boolean[]{false};
        boolean[] binary = new boolean[]{false};
        TStringBuilder undumped = new TStringBuilder();
        undumped.setEncoding(encoding);
        TruffleString.CodeRange cr = tstring.getCodeRange();
        if (cr != TruffleString.CodeRange.ASCII) {
            throw new RaiseException(context, context.getCoreExceptions().runtimeError("non-ASCII character detected", currentNode));
        }
        if (ArrayUtils.memchr(bytes, start, byteArray.getLength(), (byte)0) != -1) {
            throw new RaiseException(context, context.getCoreExceptions().runtimeError("string contains null byte", currentNode));
        }
        if (end - start < 2) {
            throw new RaiseException(context, context.getCoreExceptions().runtimeError(INVALID_FORMAT_MESSAGE, currentNode));
        }
        if (bytes[start] != 34) {
            throw new RaiseException(context, context.getCoreExceptions().runtimeError(INVALID_FORMAT_MESSAGE, currentNode));
        }
        ++start;
        while (true) {
            if (start >= end) {
                throw new RaiseException(context, context.getCoreExceptions().runtimeError("unterminated dumped string", currentNode));
            }
            if (bytes[start] == 34) {
                if (++start == end) break;
                if (utf8[0]) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError("dumped string contained Unicode escape but used force_encoding", currentNode));
                }
                int size = FORCE_ENCODING_BYTES.length;
                if (end - start <= size) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError(INVALID_FORMAT_MESSAGE, currentNode));
                }
                if (!ArrayUtils.regionEquals(bytes, start, FORCE_ENCODING_BYTES, 0, size)) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError(INVALID_FORMAT_MESSAGE, currentNode));
                }
                int encname = start += size;
                start = ArrayUtils.memchr(bytes, start, end - start, (byte)34);
                size = start - encname;
                if (start == -1) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError(INVALID_FORMAT_MESSAGE, currentNode));
                }
                if (end - start != 2) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError(INVALID_FORMAT_MESSAGE, currentNode));
                }
                if (bytes[start] != 34 || bytes[start + 1] != 41) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError(INVALID_FORMAT_MESSAGE, currentNode));
                }
                String encnameString = TStringUtils.bytesToJavaStringOrThrow(bytes, encname, size, encoding);
                RubyEncoding enc2 = context.getEncodingManager().getRubyEncoding(encnameString);
                if (enc2 == null) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError("dumped string has unknown encoding name", currentNode));
                }
                undumped.setEncoding(enc2);
                resultEncoding = enc2;
                break;
            }
            if (bytes[start] == 92) {
                if (++start >= end) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError("invalid escape", currentNode));
                }
                Pair<Integer, RubyEncoding> undumpAfterBackslashResult = StringSupport.undumpAfterBackslash(undumped, resultEncoding, bytes, start, end, enc, utf8, binary, context, currentNode);
                start = (Integer)undumpAfterBackslashResult.getLeft();
                resultEncoding = (RubyEncoding)undumpAfterBackslashResult.getRight();
                continue;
            }
            undumped.append(bytes, start++, 1);
        }
        return Pair.create((Object)undumped, (Object)resultEncoding);
    }

    private static Pair<Integer, RubyEncoding> undumpAfterBackslash(TStringBuilder out, RubyEncoding encoding, byte[] bytes, int start, int end, Encoding[] enc, boolean[] utf8, boolean[] binary, RubyContext context, Node currentNode) {
        int[] hexlen = new int[]{0};
        byte[] buf = new byte[6];
        RubyEncoding resultEncoding = encoding;
        block0 : switch (bytes[start]) {
            case 34: 
            case 35: 
            case 92: {
                out.append(bytes, start, 1);
                ++start;
                break;
            }
            case 97: 
            case 98: 
            case 101: 
            case 102: 
            case 110: 
            case 114: 
            case 116: 
            case 118: {
                buf[0] = StringSupport.unescapeAscii(bytes[start]);
                out.append(buf, 0, 1);
                ++start;
                break;
            }
            case 117: {
                if (binary[0]) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError("hex escape and Unicode escape are mixed", currentNode));
                }
                utf8[0] = true;
                if (++start >= end) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError("invalid Unicode escape", currentNode));
                }
                if (enc[0] != UTF8Encoding.INSTANCE) {
                    enc[0] = UTF8Encoding.INSTANCE;
                    out.setEncoding(Encodings.UTF_8);
                    resultEncoding = Encodings.UTF_8;
                }
                if (bytes[start] == 123) {
                    ++start;
                    while (true) {
                        if (start >= end) {
                            throw new RaiseException(context, context.getCoreExceptions().runtimeError("unterminated Unicode escape", currentNode));
                        }
                        if (bytes[start] == 125) {
                            ++start;
                            break block0;
                        }
                        if (Character.isSpaceChar(bytes[start])) {
                            ++start;
                            continue;
                        }
                        long c = StringSupport.scanHex(bytes, start, end - start, hexlen);
                        if (hexlen[0] == 0 || hexlen[0] > 6) {
                            throw new RaiseException(context, context.getCoreExceptions().runtimeError("invalid Unicode escape", currentNode));
                        }
                        if (c > 0x10FFFFL) {
                            throw new RaiseException(context, context.getCoreExceptions().runtimeError("invalid Unicode codepoint (too large)", currentNode));
                        }
                        if (55296L <= c && c <= 57343L) {
                            throw new RaiseException(context, context.getCoreExceptions().runtimeError("invalid Unicode codepoint", currentNode));
                        }
                        int codelen = enc[0].codeToMbc((int)c, buf, 0);
                        out.append(buf, 0, codelen);
                        start += hexlen[0];
                    }
                }
                long c = StringSupport.scanHex(bytes, start, 4, hexlen);
                if (hexlen[0] != 4) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError("invalid Unicode escape", currentNode));
                }
                if (55296L <= c && c <= 57343L) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError("invalid Unicode codepoint", currentNode));
                }
                int codelen = enc[0].codeToMbc((int)c, buf, 0);
                out.append(buf, 0, codelen);
                start += hexlen[0];
                break;
            }
            case 120: {
                if (utf8[0]) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError("hex escape and Unicode escape are mixed", currentNode));
                }
                binary[0] = true;
                if (++start >= end) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError("invalid hex escape", currentNode));
                }
                buf[0] = (byte)StringSupport.scanHex(bytes, start, 2, hexlen);
                if (hexlen[0] != 2) {
                    throw new RaiseException(context, context.getCoreExceptions().runtimeError("invalid hex escape", currentNode));
                }
                out.append(buf, 0, 1);
                start += hexlen[0];
                break;
            }
            default: {
                out.append(bytes, start - 1, 2);
                ++start;
            }
        }
        return Pair.create((Object)start, (Object)resultEncoding);
    }

    private static long scanHex(byte[] bytes, int start, int len, int[] retlen) {
        int tmp;
        int s;
        long retval = 0L;
        for (s = start; len-- > 0 && s < bytes.length && (tmp = ArrayUtils.memchr(HEXDIGIT, 0, HEXDIGIT.length, bytes[s])) != -1; ++s) {
            retval <<= 4;
            retval |= (long)(tmp & 0xF);
        }
        retlen[0] = s - start;
        return retval;
    }

    private static byte unescapeAscii(byte c) {
        switch (c) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 102: {
                return 12;
            }
            case 118: {
                return 11;
            }
            case 98: {
                return 8;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
        }
        return -1;
    }

    public static final class TrTables {
        IntHashMap<Object> del;
        IntHashMap<Object> noDel;
    }

    public static final class TR {
        final byte[] buf;
        int p;
        int pend;
        int now;
        int max;
        boolean gen;

        public TR(AbstractTruffleString string, RubyEncoding encoding) {
            InternalByteArray bytes = string.getInternalByteArrayUncached(encoding.tencoding);
            this.p = bytes.getOffset();
            this.pend = bytes.getEnd();
            this.buf = bytes.getArray();
            this.max = 0;
            this.now = 0;
            this.gen = false;
        }
    }

    public static enum NeighborChar {
        NOT_CHAR,
        FOUND,
        WRAPPED;

    }
}

