/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import org.truffleruby.Layouts;
import org.truffleruby.core.encoding.EncodingNodes;
import org.truffleruby.core.encoding.EncodingNodesFactory;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.ATStringWithEncoding;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringGuards;
import org.truffleruby.core.string.StringHelperNodesFactory;
import org.truffleruby.core.string.StringSupport;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;

public abstract class StringHelperNodes {
    @CompilerDirectives.TruffleBoundary
    static Object trTransHelper(Node node, EncodingNodes.CheckEncodingNode checkEncodingNode, RubyString self, RubyStringLibrary libFromStr, Object fromStr, RubyStringLibrary libToStr, Object toStr, boolean sFlag) {
        ATStringWithEncoding toStrTStringWithEnc;
        ATStringWithEncoding fromStrTStringWithEnc;
        RubyEncoding e2;
        RubyEncoding e1 = checkEncodingNode.execute(node, (Object)self, fromStr);
        RubyEncoding enc = e1 == (e2 = checkEncodingNode.execute(node, (Object)self, toStr)) ? e1 : checkEncodingNode.execute(node, fromStr, toStr);
        ATStringWithEncoding selfTStringWithEnc = new ATStringWithEncoding(self.tstring, self.getEncodingUncached());
        TruffleString ret = StringSupport.trTransHelper(selfTStringWithEnc, fromStrTStringWithEnc = new ATStringWithEncoding(libFromStr, fromStr), toStrTStringWithEnc = new ATStringWithEncoding(libToStr, toStr), e1.jcoding, enc, sFlag, node);
        if (ret == null) {
            return Nil.INSTANCE;
        }
        self.setTString((AbstractTruffleString)ret, enc);
        return self;
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class StringToTruffleStringInplaceNode
    extends RubyBaseNode {
        public abstract TruffleString execute(Node var1, Object var2);

        @Specialization
        static TruffleString immutable(ImmutableRubyString string) {
            return string.tstring;
        }

        @Specialization
        static TruffleString mutable(RubyString string, @Cached RubyStringLibrary libString, @Cached(inline=false) TruffleString.AsTruffleStringNode asTruffleStringNode) {
            TruffleString tstring = asTruffleStringNode.execute(string.tstring, libString.getTEncoding((Object)string));
            string.setTString((AbstractTruffleString)tstring);
            return tstring;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class StringAppendNode
    extends RubyBaseNode {
        public abstract RubyString executeStringAppend(Node var1, Object var2, Object var3);

        @Specialization(guards={"libOther.isRubyString(other)"}, limit="1")
        static RubyString stringAppend(Node node, Object string, Object other, @Cached RubyStringLibrary libString, @Cached RubyStringLibrary libOther, @Cached EncodingNodes.CheckStringEncodingNode checkEncodingNode, @Cached(inline=false) TruffleString.ConcatNode concatNode) {
            AbstractTruffleString left = libString.getTString(string);
            RubyEncoding leftEncoding = libString.getEncoding(string);
            AbstractTruffleString right = libOther.getTString(other);
            RubyEncoding rightEncoding = libOther.getEncoding(other);
            RubyEncoding compatibleEncoding = checkEncodingNode.executeCheckEncoding(node, left, leftEncoding, right, rightEncoding);
            TruffleString result = concatNode.execute(left, right, compatibleEncoding.tencoding, true);
            return StringAppendNode.createString(node, result, compatibleEncoding);
        }
    }

    @ImportStatic(value={StringGuards.class})
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class GetCodePointNode
    extends RubyBaseNode {
        public abstract int executeGetCodePoint(Node var1, AbstractTruffleString var2, RubyEncoding var3, int var4);

        @Specialization
        static int getCodePoint(Node node, AbstractTruffleString string, RubyEncoding encoding, int byteIndex, @Cached(inline=false) TruffleString.CodePointAtByteIndexNode getCodePointNode, @Cached InlinedBranchProfile badCodePointProfile) {
            int codePoint = getCodePointNode.execute(string, byteIndex, encoding.tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            if (codePoint == -1) {
                badCodePointProfile.enter(node);
                throw new RaiseException(GetCodePointNode.getContext(node), GetCodePointNode.coreExceptions(node).argumentErrorInvalidByteSequence(encoding, node));
            }
            return codePoint;
        }
    }

    public static abstract class InvertAsciiCaseNode
    extends RubyBaseNode {
        @Node.Child
        private InvertAsciiCaseHelperNode invertNode;

        @NeverDefault
        public static InvertAsciiCaseNode createLowerToUpper() {
            return StringHelperNodesFactory.InvertAsciiCaseNodeGen.create(InvertAsciiCaseHelperNode.createLowerToUpper());
        }

        @NeverDefault
        public static InvertAsciiCaseNode createUpperToLower() {
            return StringHelperNodesFactory.InvertAsciiCaseNodeGen.create(InvertAsciiCaseHelperNode.createUpperToLower());
        }

        @NeverDefault
        public static InvertAsciiCaseNode createSwapCase() {
            return StringHelperNodesFactory.InvertAsciiCaseNodeGen.create(InvertAsciiCaseHelperNode.createSwapCase());
        }

        public InvertAsciiCaseNode(InvertAsciiCaseHelperNode invertNode) {
            this.invertNode = invertNode;
        }

        public abstract Object executeInvert(RubyString var1);

        @Specialization
        Object invert(RubyString string, @Cached RubyStringLibrary libString, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached InlinedConditionProfile noopProfile) {
            TruffleString.Encoding tencoding = libString.getTEncoding((Object)string);
            TruffleStringIterator iterator = createCodePointIteratorNode.execute(string.tstring, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            byte[] modified = this.invertNode.executeInvert(string, iterator, null);
            if (noopProfile.profile((Node)this, modified == null)) {
                return nil;
            }
            string.setTString((AbstractTruffleString)fromByteArrayNode.execute(modified, tencoding, false));
            return string;
        }
    }

    public static abstract class InvertAsciiCaseHelperNode
    extends RubyBaseNode {
        private final boolean lowerToUpper;
        private final boolean upperToLower;

        @NeverDefault
        public static InvertAsciiCaseHelperNode createLowerToUpper() {
            return StringHelperNodesFactory.InvertAsciiCaseHelperNodeGen.create(true, false);
        }

        @NeverDefault
        public static InvertAsciiCaseHelperNode createUpperToLower() {
            return StringHelperNodesFactory.InvertAsciiCaseHelperNodeGen.create(false, true);
        }

        @NeverDefault
        public static InvertAsciiCaseHelperNode createSwapCase() {
            return StringHelperNodesFactory.InvertAsciiCaseHelperNodeGen.create(true, true);
        }

        protected InvertAsciiCaseHelperNode(boolean lowerToUpper, boolean upperToLower) {
            this.lowerToUpper = lowerToUpper;
            this.upperToLower = upperToLower;
        }

        public abstract byte[] executeInvert(RubyString var1, TruffleStringIterator var2, byte[] var3);

        @Specialization
        byte[] invert(RubyString string, TruffleStringIterator iterator, byte[] initialBytes, @Cached RubyStringLibrary libString, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached InlinedBranchProfile caseSwapProfile) {
            AbstractTruffleString tstring = string.tstring;
            TruffleString.Encoding encoding = libString.getTEncoding((Object)string);
            byte[] modified = initialBytes;
            while (iterator.hasNext()) {
                int p = iterator.getByteIndex();
                int c = nextNode.execute(iterator);
                if ((!this.lowerToUpper || !StringSupport.isAsciiLowercase(c)) && (!this.upperToLower || !StringSupport.isAsciiUppercase(c))) continue;
                caseSwapProfile.enter((Node)this);
                if (modified == null) {
                    modified = copyToByteArrayNode.execute(tstring, encoding);
                }
                int n = p;
                modified[n] = (byte)(modified[n] ^ 0x20);
            }
            return modified;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class NormalizeIndexNode
    extends RubyBaseNode {
        public abstract int executeNormalize(Node var1, int var2, int var3);

        @Specialization
        static int normalizeIndex(Node node, int index, int length, @Cached InlinedConditionProfile negativeIndexProfile) {
            if (negativeIndexProfile.profile(node, index < 0)) {
                return index + length;
            }
            return index;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CheckIndexNode
    extends RubyBaseNode {
        public abstract int execute(Node var1, int var2, int var3);

        @Specialization
        static int checkIndex(Node node, int index, int length, @Cached InlinedConditionProfile negativeIndexProfile, @Cached InlinedBranchProfile errorProfile) {
            if (index >= length) {
                errorProfile.enter(node);
                throw new RaiseException(CheckIndexNode.getContext(node), CheckIndexNode.getContext(node).getCoreExceptions().indexErrorOutOfString(index, node));
            }
            if (negativeIndexProfile.profile(node, index < 0) && (index += length) < 0) {
                errorProfile.enter(node);
                throw new RaiseException(CheckIndexNode.getContext(node), CheckIndexNode.getContext(node).getCoreExceptions().indexErrorOutOfString(index, node));
            }
            return index;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class StringGetAssociatedNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, Object var2);

        @Specialization(limit="getDynamicObjectCacheLimit()")
        static Object getAssociated(RubyString string, @CachedLibrary(value="string") DynamicObjectLibrary objectLibrary) {
            return objectLibrary.getOrDefault((DynamicObject)string, (Object)Layouts.ASSOCIATED_IDENTIFIER, null);
        }

        @Specialization
        static Object getAssociatedImmutable(ImmutableRubyString string) {
            return null;
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class HashStringNode
    extends RubyBaseNode {
        protected static final int CLASS_SALT = 54008340;

        public abstract long execute(Node var1, Object var2);

        @Specialization
        static long hash(Node node, Object string, @Cached RubyStringLibrary strings, @Cached(inline=false) TruffleString.HashCodeNode hashCodeNode) {
            int hashCode = hashCodeNode.execute(strings.getTString(string), strings.getTEncoding(string));
            return HashStringNode.getContext(node).getHashing(node).hash(54008340L, hashCode);
        }
    }

    @ImportStatic(value={StringGuards.class})
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class DeleteBangStringsNode
    extends TrTableNode {
        public abstract Object execute(Node var1, RubyString var2, TStringWithEncoding[] var3);

        @Specialization(guards={"string.tstring.isEmpty()"})
        Object deleteBangEmpty(RubyString string, TStringWithEncoding[] args) {
            return nil;
        }

        @Specialization(guards={"cachedArgs.length > 0", "!string.tstring.isEmpty()", "cachedArgs.length == args.length", "argsMatch(cachedArgs, args, equalNode)", "libString.getEncoding(string) == cachedEncoding"}, limit="getDefaultCacheLimit()")
        static Object deleteBangFast(Node node, RubyString string, TStringWithEncoding[] args, @Cached(value="args", dimensions=1) TStringWithEncoding[] cachedArgs, @Cached(inline=false) TruffleString.EqualNode equalNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached(value="libString.getEncoding(string)") RubyEncoding cachedEncoding, @Cached(value="squeeze()", dimensions=1) boolean[] squeeze, @Cached(value="findEncoding(node, libString.getTString(string), libString.getEncoding(string), cachedArgs, UNCACHED_CHECK_ENCODING_NODE)") RubyEncoding compatEncoding, @Cached(value="makeTables(node, cachedArgs, squeeze, compatEncoding)") StringSupport.TrTables tables, @Cached @Cached.Exclusive InlinedBranchProfile nullProfile) {
            TruffleString processedTString = DeleteBangStringsNode.processStr(node, string, squeeze, compatEncoding, tables);
            if (processedTString == null) {
                nullProfile.enter(node);
                return nil;
            }
            string.setTString((AbstractTruffleString)processedTString);
            return string;
        }

        @Specialization(guards={"!string.tstring.isEmpty()"}, replaces={"deleteBangFast"})
        static Object deleteBangSlow(Node node, RubyString string, TStringWithEncoding[] args, @Cached @Cached.Shared RubyStringLibrary libString, @Cached EncodingNodes.CheckStringEncodingNode checkEncodingNode, @Cached @Cached.Exclusive InlinedBranchProfile errorProfile) {
            if (args.length == 0) {
                errorProfile.enter(node);
                throw new RaiseException(DeleteBangStringsNode.getContext(node), DeleteBangStringsNode.coreExceptions(node).argumentErrorEmptyVarargs(node));
            }
            RubyEncoding enc = DeleteBangStringsNode.findEncoding(node, string.tstring, libString.getEncoding((Object)string), args, checkEncodingNode);
            return DeleteBangStringsNode.deleteBangSlow(node, string, args, enc);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object deleteBangSlow(Node node, RubyString string, TStringWithEncoding[] tstringsWithEncs, RubyEncoding enc) {
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = DeleteBangStringsNode.makeTables(node, tstringsWithEncs, squeeze, enc);
            TruffleString processedTString = DeleteBangStringsNode.processStr(node, string, squeeze, enc, tables);
            if (processedTString == null) {
                return nil;
            }
            string.setTString((AbstractTruffleString)processedTString);
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString processStr(Node node, RubyString string, boolean[] squeeze, RubyEncoding enc, StringSupport.TrTables tables) {
            return StringSupport.delete_bangCommon19(new ATStringWithEncoding(string.tstring, string.getEncodingUncached()), squeeze, tables, enc, node);
        }
    }

    public static abstract class TrTableNode
    extends RubyBaseNode {
        static final EncodingNodes.CheckStringEncodingNode UNCACHED_CHECK_ENCODING_NODE = EncodingNodesFactory.CheckStringEncodingNodeGen.getUncached();

        protected boolean[] squeeze() {
            return new boolean[257];
        }

        protected static RubyEncoding findEncoding(Node node, AbstractTruffleString tstring, RubyEncoding encoding, TStringWithEncoding[] tstringsWithEncs, EncodingNodes.CheckStringEncodingNode checkEncodingNode) {
            RubyEncoding enc = checkEncodingNode.executeCheckEncoding(node, tstring, encoding, (AbstractTruffleString)tstringsWithEncs[0].tstring, tstringsWithEncs[0].encoding);
            for (int i = 1; i < tstringsWithEncs.length; ++i) {
                enc = checkEncodingNode.executeCheckEncoding(node, tstring, encoding, (AbstractTruffleString)tstringsWithEncs[i].tstring, tstringsWithEncs[i].encoding);
            }
            return enc;
        }

        protected static StringSupport.TrTables makeTables(Node node, TStringWithEncoding[] tstringsWithEncs, boolean[] squeeze, RubyEncoding enc) {
            StringSupport.TrTables tables = StringSupport.trSetupTable((AbstractTruffleString)tstringsWithEncs[0].tstring, tstringsWithEncs[0].encoding, squeeze, null, true, enc.jcoding, node);
            for (int i = 1; i < tstringsWithEncs.length; ++i) {
                tables = StringSupport.trSetupTable((AbstractTruffleString)tstringsWithEncs[i].tstring, tstringsWithEncs[i].encoding, squeeze, tables, false, enc.jcoding, node);
            }
            return tables;
        }

        @ExplodeLoop
        protected boolean argsMatch(TStringWithEncoding[] cachedStrings, TStringWithEncoding[] strings, TruffleString.EqualNode equalNode) {
            for (int i = 0; i < cachedStrings.length; ++i) {
                if (cachedStrings[i].encoding != strings[i].encoding) {
                    return false;
                }
                if (equalNode.execute((AbstractTruffleString)cachedStrings[i].tstring, (AbstractTruffleString)strings[i].tstring, cachedStrings[i].encoding.tencoding)) continue;
                return false;
            }
            return true;
        }
    }

    @ImportStatic(value={StringGuards.class})
    public static abstract class CountStringsNode
    extends TrTableNode {
        public abstract int execute(Object var1, TStringWithEncoding[] var2);

        @Specialization(guards={"libString.getTString(string).isEmpty()"})
        int count(Object string, TStringWithEncoding[] args, @Cached @Cached.Shared RubyStringLibrary libString) {
            return 0;
        }

        @Specialization(guards={"cachedArgs.length > 0", "!tstring.isEmpty()", "cachedArgs.length == args.length", "argsMatch(cachedArgs, args, equalNode)", "encoding == cachedEncoding"}, limit="getDefaultCacheLimit()")
        int countFast(Object string, TStringWithEncoding[] args, @Cached(value="args", dimensions=1) TStringWithEncoding[] cachedArgs, @Cached TruffleString.EqualNode equalNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared EncodingNodes.CheckStringEncodingNode checkEncodingNode, @Bind(value="libString.getTString(string)") AbstractTruffleString tstring, @Bind(value="libString.getEncoding(string)") RubyEncoding encoding, @Cached(value="libString.getEncoding(string)") RubyEncoding cachedEncoding, @Cached(value="squeeze()", dimensions=1) boolean[] squeeze, @Cached(value="findEncoding(this, libString.getTString(string), libString.getEncoding(string), cachedArgs, checkEncodingNode)") RubyEncoding compatEncoding, @Cached(value="makeTables(this, cachedArgs, squeeze, compatEncoding)") StringSupport.TrTables tables, @Cached @Cached.Shared TruffleString.GetInternalByteArrayNode byteArrayNode, @Cached @Cached.Shared TruffleString.GetByteCodeRangeNode getByteCodeRangeNode) {
            InternalByteArray byteArray = byteArrayNode.execute(tstring, encoding.tencoding);
            TruffleString.CodeRange codeRange = getByteCodeRangeNode.execute(tstring, encoding.tencoding);
            return StringSupport.strCount(byteArray, codeRange, squeeze, tables, compatEncoding.jcoding, this);
        }

        @Specialization(guards={"!libString.getTString(string).isEmpty()"})
        int count(Object string, TStringWithEncoding[] tstringsWithEncs, @Cached InlinedBranchProfile errorProfile, @Cached @Cached.Shared EncodingNodes.CheckStringEncodingNode checkEncodingNode, @Cached @Cached.Shared RubyStringLibrary libString, @Cached @Cached.Shared TruffleString.GetInternalByteArrayNode byteArrayNode, @Cached @Cached.Shared TruffleString.GetByteCodeRangeNode getByteCodeRangeNode) {
            if (tstringsWithEncs.length == 0) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorEmptyVarargs(this));
            }
            AbstractTruffleString tstring = libString.getTString(string);
            RubyEncoding encoding = libString.getEncoding(string);
            InternalByteArray byteArray = byteArrayNode.execute(tstring, encoding.tencoding);
            TruffleString.CodeRange codeRange = getByteCodeRangeNode.execute(tstring, encoding.tencoding);
            RubyEncoding enc = CountStringsNode.findEncoding(this, tstring, encoding, tstringsWithEncs, checkEncodingNode);
            return this.countSlow(byteArray, codeRange, tstringsWithEncs, enc);
        }

        @CompilerDirectives.TruffleBoundary
        private int countSlow(InternalByteArray byteArray, TruffleString.CodeRange codeRange, TStringWithEncoding[] tstringsWithEncs, RubyEncoding enc) {
            boolean[] table = this.squeeze();
            StringSupport.TrTables tables = CountStringsNode.makeTables(this, tstringsWithEncs, table, enc);
            return StringSupport.strCount(byteArray, codeRange, table, tables, enc.jcoding, this);
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class StringEqualInternalNode
    extends RubyBaseNode {
        public abstract boolean executeInternal(Node var1, AbstractTruffleString var2, AbstractTruffleString var3, RubyEncoding var4);

        @Specialization(guards={"a.isEmpty() || b.isEmpty()"})
        static boolean empty(AbstractTruffleString a, AbstractTruffleString b, RubyEncoding compatibleEncoding) {
            assert (compatibleEncoding != null);
            return a.isEmpty() && b.isEmpty();
        }

        @Specialization(guards={"compatibleEncoding != null", "!a.isEmpty()", "!b.isEmpty()"})
        static boolean equalBytes(AbstractTruffleString a, AbstractTruffleString b, RubyEncoding compatibleEncoding, @Cached(inline=false) TruffleString.EqualNode equalNode) {
            return equalNode.execute(a, b, compatibleEncoding.tencoding);
        }

        @Specialization(guards={"compatibleEncoding == null"})
        static boolean notComparable(AbstractTruffleString a, AbstractTruffleString b, RubyEncoding compatibleEncoding) {
            return false;
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class EqualSameEncodingNode
    extends RubyBaseNode {
        public final boolean execute(Node node, RubyStringLibrary libString, Object rubyString, TruffleString cachedString, RubyEncoding cachedEncoding) {
            return this.execute(node, libString.getTString(rubyString), libString.getEncoding(rubyString), cachedString, cachedEncoding);
        }

        public abstract boolean execute(Node var1, AbstractTruffleString var2, RubyEncoding var3, TruffleString var4, RubyEncoding var5);

        @Specialization(guards={"encA == encB"})
        static boolean same(Node node, AbstractTruffleString a, RubyEncoding encA, TruffleString b, RubyEncoding encB, @Cached StringEqualInternalNode stringEqualInternalNode) {
            return stringEqualInternalNode.executeInternal(node, a, (AbstractTruffleString)b, encA);
        }

        @Specialization(guards={"encA != encB"})
        static boolean diff(AbstractTruffleString a, RubyEncoding encA, TruffleString b, RubyEncoding encB) {
            return false;
        }
    }

    public static abstract class EqualNode
    extends RubyBaseNode {
        public final boolean execute(RubyStringLibrary libString, Object rubyString, TruffleString cachedString, RubyEncoding cachedEncoding) {
            return this.execute(libString.getTString(rubyString), libString.getEncoding(rubyString), cachedString, cachedEncoding);
        }

        public abstract boolean execute(AbstractTruffleString var1, RubyEncoding var2, TruffleString var3, RubyEncoding var4);

        @Specialization
        boolean equal(AbstractTruffleString a, RubyEncoding encA, TruffleString b, RubyEncoding encB, @Cached EncodingNodes.NegotiateCompatibleStringEncodingNode negotiateCompatibleStringEncodingNode, @Cached StringEqualInternalNode stringEqualInternalNode) {
            RubyEncoding compatibleEncoding = negotiateCompatibleStringEncodingNode.execute(this, a, encA, (AbstractTruffleString)b, encB);
            return stringEqualInternalNode.executeInternal(this, a, (AbstractTruffleString)b, compatibleEncoding);
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class SingleByteOptimizableNode
    extends RubyBaseNode {
        public abstract boolean execute(Node var1, AbstractTruffleString var2, RubyEncoding var3);

        @Specialization
        static boolean isSingleByteOptimizable(Node node, AbstractTruffleString string, RubyEncoding encoding, @Cached InlinedConditionProfile asciiOnlyProfile, @Cached(inline=false) TruffleString.GetByteCodeRangeNode getByteCodeRangeNode) {
            if (asciiOnlyProfile.profile(node, StringGuards.is7Bit(string, encoding, getByteCodeRangeNode))) {
                return true;
            }
            return encoding.isSingleByte;
        }
    }
}

