/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.truffleruby.collections.WeakValueCache;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.TStringCache;
import org.truffleruby.core.string.TStringWithEncoding;

public final class FrozenStringLiterals {
    private static final List<ImmutableRubyString> STRINGS_TO_CACHE = new ArrayList<ImmutableRubyString>();
    private final TStringCache tstringCache;
    private final WeakValueCache<TStringWithEncoding, ImmutableRubyString> values = new WeakValueCache();

    public FrozenStringLiterals(TStringCache tStringCache) {
        this.tstringCache = tStringCache;
        for (ImmutableRubyString name : STRINGS_TO_CACHE) {
            this.addFrozenStringToCache(name);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public ImmutableRubyString getFrozenStringLiteral(TruffleString tstring, RubyEncoding encoding) {
        return this.getFrozenStringLiteral(tstring.getInternalByteArrayUncached(encoding.tencoding), TStringUtils.hasImmutableInternalByteArray((AbstractTruffleString)tstring), encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public ImmutableRubyString getFrozenStringLiteral(InternalByteArray byteArray, boolean isImmutable, RubyEncoding encoding) {
        TruffleString cachedTString = this.tstringCache.getTString(byteArray, isImmutable, encoding);
        TStringWithEncoding tstringWithEncoding = new TStringWithEncoding(cachedTString, encoding);
        ImmutableRubyString string = this.values.get(tstringWithEncoding);
        if (string != null) {
            return string;
        }
        return this.values.addInCacheIfAbsent(tstringWithEncoding, new ImmutableRubyString(cachedTString, encoding));
    }

    @CompilerDirectives.TruffleBoundary
    public ImmutableRubyString getFrozenStringLiteral(byte[] bytes, RubyEncoding encoding) {
        TruffleString cachedTString = this.tstringCache.getTString(bytes, encoding);
        TStringWithEncoding tstringWithEncoding = new TStringWithEncoding(cachedTString, encoding);
        ImmutableRubyString string = this.values.get(tstringWithEncoding);
        if (string != null) {
            return string;
        }
        return this.values.addInCacheIfAbsent(tstringWithEncoding, new ImmutableRubyString(cachedTString, encoding));
    }

    public static ImmutableRubyString createStringAndCacheLater(TruffleString name, RubyEncoding encoding) {
        ImmutableRubyString string = new ImmutableRubyString(name, encoding);
        assert (!STRINGS_TO_CACHE.contains(string));
        STRINGS_TO_CACHE.add(string);
        return string;
    }

    private void addFrozenStringToCache(ImmutableRubyString string) {
        RubyEncoding encoding = string.getEncodingUncached();
        TruffleString cachedTString = this.tstringCache.getTString(string.tstring, encoding);
        assert (cachedTString == string.tstring);
        TStringWithEncoding tstringWithEncoding = new TStringWithEncoding(cachedTString, encoding);
        ImmutableRubyString existing = this.values.addInCacheIfAbsent(tstringWithEncoding, string);
        if (existing != string) {
            throw CompilerDirectives.shouldNotReachHere((String)("Duplicate ImmutableRubyString in FrozenStringLiterals: " + String.valueOf(existing)));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<ImmutableRubyString> allFrozenStrings() {
        return this.values.values();
    }
}

