/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.ascii.AsciiTables;
import org.graalvm.shadowed.org.jcodings.specific.ASCIIEncoding;

public final class EncodingUtils {
    public static boolean encAsciicompat(Encoding enc) {
        return enc.minLength() == 1 && !enc.isDummy();
    }

    public static boolean DECORATOR_P(byte[] sname, byte[] dname) {
        return sname == null || sname.length == 0 || sname[0] == 0;
    }

    public static List<String> encodingNames(byte[] name, int p, int end) {
        ArrayList<String> names = new ArrayList<String>();
        ASCIIEncoding enc = ASCIIEncoding.INSTANCE;
        int s = p;
        int code = name[s] & 0xFF;
        if (enc.isDigit(code)) {
            return names;
        }
        boolean hasUpper = false;
        boolean hasLower = false;
        if (enc.isUpper(code)) {
            hasUpper = true;
            while (++s < end && (enc.isAlnum(name[s] & 0xFF) || name[s] == 95)) {
                if (!enc.isLower(name[s] & 0xFF)) continue;
                hasLower = true;
            }
        }
        boolean isValid = false;
        if (s >= end) {
            isValid = true;
            names.add(new String(name, p, end - p, StandardCharsets.US_ASCII));
        }
        if (!isValid || hasLower) {
            if (!hasLower || !hasUpper) {
                do {
                    if (enc.isLower(code = name[s] & 0xFF)) {
                        hasLower = true;
                    }
                    if (!enc.isUpper(code)) continue;
                    hasUpper = true;
                } while (++s < end && (!hasLower || !hasUpper));
            }
            byte[] constName = new byte[end - p];
            System.arraycopy(name, p, constName, 0, end - p);
            s = 0;
            code = constName[s] & 0xFF;
            if (!isValid) {
                if (enc.isLower(code)) {
                    constName[s] = AsciiTables.ToUpperCaseTable[code];
                }
                while (s < constName.length) {
                    if (!enc.isAlnum(constName[s] & 0xFF)) {
                        constName[s] = 95;
                    }
                    ++s;
                }
                if (hasUpper) {
                    names.add(new String(constName, StandardCharsets.US_ASCII));
                }
            }
            if (hasLower) {
                for (s = 0; s < constName.length; ++s) {
                    code = constName[s] & 0xFF;
                    if (!enc.isLower(code)) continue;
                    constName[s] = AsciiTables.ToUpperCaseTable[code];
                }
                names.add(new String(constName, StandardCharsets.US_ASCII));
            }
        }
        return names;
    }
}

