/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.shadowed.org.joni.NameEntry;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.ToStrNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.regexp.ClassicRegexp;
import org.truffleruby.core.regexp.RegexpNodesFactory;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.string.ATStringWithEncoding;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.PerformanceWarningNode;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;

@CoreModule(value="Regexp", isClass=true)
public abstract class RegexpNodes {

    @CoreMethod(names={"options"})
    public static abstract class RegexpOptionsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int options(RubyRegexp regexp) {
            return regexp.options.toOptions();
        }
    }

    @Primitive(name="regexp_compile", lowerFixnum={1})
    public static abstract class RegexpCompileNode
    extends PrimitiveArrayArgumentsNode {
        static final InlinedBranchProfile UNCACHED_BRANCH_PROFILE = InlinedBranchProfile.getUncached();

        @Specialization(guards={"libPattern.isRubyString(pattern)", "patternEqualNode.execute(node, libPattern, pattern, cachedPattern, cachedPatternEnc)", "options == cachedOptions"}, limit="getDefaultCacheLimit()")
        static RubyRegexp fastCompiling(Object pattern, int options, @Cached @Cached.Shared TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached @Cached.Shared RubyStringLibrary libPattern, @Cached(value="asTruffleStringUncached(pattern)") TruffleString cachedPattern, @Cached(value="libPattern.getEncoding(pattern)") RubyEncoding cachedPatternEnc, @Cached(value="options") int cachedOptions, @Cached StringHelperNodes.EqualSameEncodingNode patternEqualNode, @Bind(value="this") Node node, @Cached(value="compile(pattern, options, node, libPattern, asTruffleStringNode, UNCACHED_BRANCH_PROFILE)") RubyRegexp regexp) {
            return regexp;
        }

        @Specialization(replaces={"fastCompiling"}, guards={"libPattern.isRubyString(pattern)"})
        RubyRegexp slowCompiling(Object pattern, int options, @Cached InlinedBranchProfile errorProfile, @Cached @Cached.Shared TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached @Cached.Shared RubyStringLibrary libPattern, @Cached PerformanceWarningNode performanceWarningNode) {
            performanceWarningNode.warn("unbounded creation of regexps causes deoptimization loops which hurt performance significantly, avoid creating regexps dynamically where possible or cache them to fix this");
            return this.compile(pattern, options, this, libPattern, asTruffleStringNode, errorProfile);
        }

        public RubyRegexp compile(Object pattern, int options, Node node, RubyStringLibrary libPattern, TruffleString.AsTruffleStringNode asTruffleStringNode, InlinedBranchProfile errorProfile) {
            RubyEncoding encoding = libPattern.getEncoding(pattern);
            try {
                return RubyRegexp.create(RegexpCompileNode.getLanguage(node), asTruffleStringNode.execute(libPattern.getTString(pattern), encoding.tencoding), encoding, RegexpOptions.fromEmbeddedOptions(options), node);
            }
            catch (DeferredRaiseException dre) {
                errorProfile.enter(node);
                throw dre.getException(RegexpCompileNode.getContext(node));
            }
        }
    }

    @CoreMethod(names={"fixed_encoding?"})
    public static abstract class RegexpIsFixedEncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean fixedEncoding(RubyRegexp regexp) {
            return regexp.options.isFixed();
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyRegexp allocate(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @Primitive(name="regexp_names")
    public static abstract class RegexpNamesNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray regexpNames(RubyRegexp regexp) {
            int size = regexp.regex.numberOfNames();
            if (size == 0) {
                return this.createEmptyArray();
            }
            Object[] names = new Object[size];
            int i = 0;
            Iterator iter = regexp.regex.namedBackrefIterator();
            while (iter.hasNext()) {
                NameEntry e = (NameEntry)iter.next();
                byte[] bytes = Arrays.copyOfRange(e.name, e.nameP, e.nameEnd);
                TruffleString tstring = TStringUtils.fromByteArray(bytes, Encodings.UTF_8);
                RubySymbol name = this.getSymbol((AbstractTruffleString)tstring, Encodings.UTF_8);
                int[] backrefs = e.getBackRefs();
                RubyArray backrefsRubyArray = this.createArray(backrefs);
                names[i++] = this.createArray(new Object[]{name, backrefsRubyArray});
            }
            return this.createArray(names);
        }
    }

    @CoreMethod(names={"to_s"}, split=Split.ALWAYS)
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public static ToSNode create() {
            return RegexpNodesFactory.ToSNodeFactory.create(null);
        }

        public abstract RubyString execute(RubyRegexp var1);

        @Specialization(guards={"regexp.regex == cachedRegexp.regex"}, limit="getDefaultCacheLimit()")
        RubyString toSCached(RubyRegexp regexp, @Cached(value="regexp") RubyRegexp cachedRegexp, @Cached(value="createTString(cachedRegexp)") TStringWithEncoding string) {
            return this.createString(string);
        }

        @Specialization
        RubyString toS(RubyRegexp regexp) {
            return this.createString(this.createTString(regexp));
        }

        @CompilerDirectives.TruffleBoundary
        protected TStringWithEncoding createTString(RubyRegexp regexp) {
            TStringWithEncoding sourceEnc = new TStringWithEncoding(regexp.source, regexp.encoding);
            return ClassicRegexp.toS(sourceEnc, regexp.options);
        }
    }

    @CoreMethod(names={"source"})
    public static abstract class SourceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString source(RubyRegexp regexp) {
            return this.createString(regexp.source, regexp.encoding);
        }
    }

    @CoreMethod(names={"quote", "escape"}, onSingleton=true, required=1, split=Split.ALWAYS)
    public static abstract class QuoteNode
    extends CoreMethodArrayArgumentsNode {
        public abstract RubyString execute(Object var1);

        @NeverDefault
        public static QuoteNode create() {
            return RegexpNodesFactory.QuoteNodeFactory.create(null);
        }

        @Specialization(guards={"libString.isRubyString(raw)", "equalNode.execute(node, libString, raw, cachedString, cachedEnc)"}, limit="getDefaultCacheLimit()")
        RubyString quoteStringCached(Object raw, @Cached @Cached.Shared RubyStringLibrary libString, @Cached(value="asTruffleStringUncached(raw)") TruffleString cachedString, @Cached(value="libString.getEncoding(raw)") RubyEncoding cachedEnc, @Cached StringHelperNodes.EqualSameEncodingNode equalNode, @Bind(value="this") Node node, @Cached(value="quote(libString, raw)") TStringWithEncoding quotedString) {
            return this.createString(quotedString);
        }

        @Specialization(replaces={"quoteStringCached"}, guards={"libString.isRubyString(raw)"})
        RubyString quoteString(Object raw, @Cached @Cached.Shared RubyStringLibrary libString) {
            return this.createString(this.quote(libString, raw));
        }

        @Specialization(guards={"raw == cachedSymbol"}, limit="getDefaultCacheLimit()")
        RubyString quoteSymbolCached(RubySymbol raw, @Cached(value="raw") RubySymbol cachedSymbol, @Cached(value="quote(cachedSymbol)") TStringWithEncoding quotedString) {
            return this.createString(quotedString);
        }

        @Specialization(replaces={"quoteSymbolCached"})
        RubyString quoteSymbol(RubySymbol raw) {
            return this.createString(this.quote(raw));
        }

        @Specialization(guards={"!libString.isRubyString(raw)", "!isRubySymbol(raw)"})
        static RubyString quoteGeneric(Object raw, @Cached @Cached.Shared RubyStringLibrary libString, @Cached ToStrNode toStrNode, @Cached QuoteNode recursive, @Bind(value="this") Node node) {
            return recursive.execute(toStrNode.execute(node, raw));
        }

        TStringWithEncoding quote(RubyStringLibrary strings, Object string) {
            return ClassicRegexp.quote19(new ATStringWithEncoding(strings, string));
        }

        TStringWithEncoding quote(RubySymbol symbol) {
            return ClassicRegexp.quote19(new ATStringWithEncoding((AbstractTruffleString)symbol.tstring, symbol.encoding));
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int hash(RubyRegexp regexp) {
            int options = regexp.regex.getOptions() & 0xFFFFFFDF;
            return options ^ regexp.source.hashCode();
        }
    }
}

