/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.specific.EUCJPEncoding;
import org.graalvm.shadowed.org.jcodings.specific.SJISEncoding;
import org.graalvm.shadowed.org.jcodings.specific.USASCIIEncoding;
import org.graalvm.shadowed.org.jcodings.specific.UTF8Encoding;
import org.graalvm.shadowed.org.joni.Regex;
import org.graalvm.shadowed.org.joni.Syntax;
import org.graalvm.shadowed.org.joni.WarnCallback;
import org.graalvm.shadowed.org.joni.exception.JOniException;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.regexp.RegexWarnCallback;
import org.truffleruby.core.regexp.RegexWarnDeferredCallback;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.regexp.RegexpSupport;
import org.truffleruby.core.string.ATStringWithEncoding;
import org.truffleruby.core.string.StringSupport;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.parser.RubyDeferredWarnings;

public final class ClassicRegexp {
    private static final int QUOTED_V = 11;

    public static Regex makeRegexp(RubyDeferredWarnings rubyDeferredWarnings, TStringBuilder processedSource, RegexpOptions options, RubyEncoding enc, AbstractTruffleString source, Node currentNode) throws DeferredRaiseException {
        try {
            return new Regex(processedSource.getUnsafeBytes(), 0, processedSource.getLength(), options.toJoniOptions(), enc.jcoding, Syntax.RUBY, (WarnCallback)(rubyDeferredWarnings == null ? new RegexWarnCallback() : new RegexWarnDeferredCallback(rubyDeferredWarnings)));
        }
        catch (Exception e) {
            String errorMessage = ClassicRegexp.getRegexErrorMessageForException(source, e, options);
            throw new DeferredRaiseException(c -> c.getCoreExceptions().regexpError(errorMessage, currentNode));
        }
    }

    private static String getRegexErrorMessageForException(AbstractTruffleString source, Exception e, RegexpOptions options) {
        String message = e.getMessage();
        if (message == null) {
            message = "<no message>";
        }
        return ClassicRegexp.formatRegexErrorMessage(message, source, options.toOptionsString());
    }

    private static String formatRegexErrorMessage(String error, AbstractTruffleString source, String options) {
        return error + ": /" + String.valueOf(source) + "/" + options;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean unescapeNonAscii(TStringBuilder to, TStringWithEncoding str, RubyEncoding enc, RubyEncoding[] encp, RegexpSupport.ErrorMode mode) throws DeferredRaiseException {
        int offset;
        boolean hasProperty = false;
        byte[] buf = null;
        InternalByteArray byteArray = str.getInternalByteArray();
        int p = offset = byteArray.getOffset();
        int end = byteArray.getEnd();
        byte[] bytes = byteArray.getArray();
        TStringWithEncoding strInEnc = str.forceEncoding(enc);
        block9: while (p < end) {
            int cl = strInEnc.characterLength(p - offset);
            if (cl <= 0) {
                ClassicRegexp.raisePreprocessError("invalid multibyte character", str, mode);
            }
            if (cl > 1 || (bytes[p] & 0x80) != 0) {
                if (to != null) {
                    to.append(bytes, p, cl);
                }
                p += cl;
                if (encp[0] == null) {
                    encp[0] = enc;
                    continue;
                }
                if (encp[0] == enc) continue;
                ClassicRegexp.raisePreprocessError("non ASCII character in UTF-8 regexp", str, mode);
                continue;
            }
            int c = bytes[p++] & 0xFF;
            switch (c) {
                case 92: {
                    if (p == end) {
                        ClassicRegexp.raisePreprocessError("too short escape sequence", str, mode);
                    }
                    c = bytes[p++] & 0xFF;
                    switch (c) {
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            if (StringSupport.scanOct(bytes, p - 1, end - (p - 1)) <= 127) {
                                if (to == null) continue block9;
                                to.append(92);
                                to.append(c);
                                break;
                            }
                        }
                        case 48: 
                        case 67: 
                        case 77: 
                        case 99: 
                        case 120: {
                            p -= 2;
                            if (enc == Encodings.US_ASCII) {
                                if (buf == null) {
                                    buf = new byte[1];
                                }
                                int pbeg = p;
                                p = ClassicRegexp.readEscapedByte(buf, 0, bytes, p, end, str, mode);
                                c = buf[0];
                                if (c == -1) {
                                    return false;
                                }
                                if (to == null) continue block9;
                                to.append(bytes, pbeg, p - pbeg);
                                break;
                            }
                            p = ClassicRegexp.unescapeEscapedNonAscii(to, bytes, p, end, enc, encp, str, mode);
                            break;
                        }
                        case 117: {
                            if (p == end) {
                                ClassicRegexp.raisePreprocessError("too short escape sequence", str, mode);
                            }
                            if (bytes[p] == 123) {
                                ++p;
                                if ((p = ClassicRegexp.unescapeUnicodeList(to, bytes, p, end, encp, str, mode)) != end && bytes[p++] == 125) continue block9;
                                ClassicRegexp.raisePreprocessError("invalid Unicode list", str, mode);
                                break;
                            }
                            p = ClassicRegexp.unescapeUnicodeBmp(to, bytes, p, end, encp, str, mode);
                            break;
                        }
                        case 80: 
                        case 112: {
                            if (encp[0] == null) {
                                hasProperty = true;
                            }
                            if (to == null) continue block9;
                            to.append(92);
                            to.append(c);
                            break;
                        }
                        default: {
                            if (to == null) continue block9;
                            to.append(92);
                            to.append(c);
                            break;
                        }
                    }
                    continue block9;
                }
                default: {
                    if (to == null) continue block9;
                    to.append(c);
                }
            }
        }
        return hasProperty;
    }

    private static int unescapeUnicodeBmp(TStringBuilder to, byte[] bytes, int p, int end, RubyEncoding[] encp, TStringWithEncoding source, RegexpSupport.ErrorMode mode) throws DeferredRaiseException {
        if (p + 4 > end) {
            ClassicRegexp.raisePreprocessError("invalid Unicode escape", source, mode);
        }
        int code = StringSupport.scanHex(bytes, p, 4);
        int len = StringSupport.hexLength(bytes, p, 4);
        if (len != 4) {
            ClassicRegexp.raisePreprocessError("invalid Unicode escape", source, mode);
        }
        ClassicRegexp.appendUtf8(to, code, encp, source, mode);
        return p + 4;
    }

    private static int unescapeUnicodeList(TStringBuilder to, byte[] bytes, int p, int end, RubyEncoding[] encp, TStringWithEncoding source, RegexpSupport.ErrorMode mode) throws DeferredRaiseException {
        while (p < end && StringSupport.isAsciiSpace(bytes[p] & 0xFF)) {
            ++p;
        }
        boolean hasUnicode = false;
        block1: while (true) {
            int code = StringSupport.scanHex(bytes, p, end - p);
            int len = StringSupport.hexLength(bytes, p, end - p);
            if (len == 0) break;
            if (len > 6) {
                ClassicRegexp.raisePreprocessError("invalid Unicode range", source, mode);
            }
            p += len;
            if (to != null) {
                ClassicRegexp.appendUtf8(to, code, encp, source, mode);
            }
            hasUnicode = true;
            while (true) {
                if (p >= end || !StringSupport.isAsciiSpace(bytes[p] & 0xFF)) continue block1;
                ++p;
            }
            break;
        }
        if (!hasUnicode) {
            ClassicRegexp.raisePreprocessError("invalid Unicode list", source, mode);
        }
        return p;
    }

    private static void appendUtf8(TStringBuilder to, int code, RubyEncoding[] enc, TStringWithEncoding source, RegexpSupport.ErrorMode mode) throws DeferredRaiseException {
        ClassicRegexp.checkUnicodeRange(code, source, mode);
        if (code < 128) {
            if (to != null) {
                to.append(StringUtils.formatASCIIBytes("\\x%02X", code));
            }
        } else {
            if (to != null) {
                to.unsafeEnsureSpace(to.getLength() + 6);
                to.setLength(to.getLength() + ClassicRegexp.utf8Decode(to.getUnsafeBytes(), to.getLength(), code));
            }
            if (enc[0] == null) {
                enc[0] = Encodings.UTF_8;
            } else if (enc[0] != Encodings.UTF_8) {
                ClassicRegexp.raisePreprocessError("UTF-8 character in non UTF-8 regexp", source, mode);
            }
        }
    }

    public static int utf8Decode(byte[] to, int p, int code) {
        if (code <= 127) {
            to[p] = (byte)code;
            return 1;
        }
        if (code <= 2047) {
            to[p + 0] = (byte)(code >>> 6 & 0xFF | 0xC0);
            to[p + 1] = (byte)(code & 0x3F | 0x80);
            return 2;
        }
        if (code <= 65535) {
            to[p + 0] = (byte)(code >>> 12 & 0xFF | 0xE0);
            to[p + 1] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p + 2] = (byte)(code & 0x3F | 0x80);
            return 3;
        }
        if (code <= 0x1FFFFF) {
            to[p + 0] = (byte)(code >>> 18 & 0xFF | 0xF0);
            to[p + 1] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p + 2] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p + 3] = (byte)(code & 0x3F | 0x80);
            return 4;
        }
        if (code <= 0x3FFFFFF) {
            to[p + 0] = (byte)(code >>> 24 & 0xFF | 0xF8);
            to[p + 1] = (byte)(code >>> 18 & 0x3F | 0x80);
            to[p + 2] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p + 3] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p + 4] = (byte)(code & 0x3F | 0x80);
            return 5;
        }
        to[p + 0] = (byte)(code >>> 30 & 0xFF | 0xFC);
        to[p + 1] = (byte)(code >>> 24 & 0x3F | 0x80);
        to[p + 2] = (byte)(code >>> 18 & 0x3F | 0x80);
        to[p + 3] = (byte)(code >>> 12 & 0x3F | 0x80);
        to[p + 4] = (byte)(code >>> 6 & 0x3F | 0x80);
        to[p + 5] = (byte)(code & 0x3F | 0x80);
        return 6;
    }

    private static void checkUnicodeRange(int code, TStringWithEncoding source, RegexpSupport.ErrorMode mode) throws DeferredRaiseException {
        if (55296 <= code && code <= 57343 || 0x10FFFF < code) {
            ClassicRegexp.raisePreprocessError("invalid Unicode range", source, mode);
        }
    }

    private static int unescapeEscapedNonAscii(TStringBuilder to, byte[] bytes, int p, int end, RubyEncoding enc, RubyEncoding[] encp, TStringWithEncoding source, RegexpSupport.ErrorMode mode) throws DeferredRaiseException {
        byte[] chBuf = new byte[enc.jcoding.maxLength()];
        int chLen = 0;
        p = ClassicRegexp.readEscapedByte(chBuf, chLen++, bytes, p, end, source, mode);
        while (chLen < enc.jcoding.maxLength() && StringSupport.MBCLEN_NEEDMORE_P(StringSupport.characterLength(enc, chBuf, 0, chLen))) {
            p = ClassicRegexp.readEscapedByte(chBuf, chLen++, bytes, p, end, source, mode);
        }
        int cl = StringSupport.characterLength(enc, chBuf, 0, chLen);
        if (cl == -1) {
            ClassicRegexp.raisePreprocessError("invalid multibyte escape", source, mode);
        }
        if (chLen > 1 || (chBuf[0] & 0x80) != 0) {
            if (to != null) {
                to.append(chBuf, 0, chLen);
            }
            if (encp[0] == null) {
                encp[0] = enc;
            } else if (encp[0] != enc) {
                ClassicRegexp.raisePreprocessError("escaped non ASCII character in UTF-8 regexp", source, mode);
            }
        } else if (to != null) {
            to.append(StringUtils.formatASCIIBytes("\\x%02X", chBuf[0] & 0xFF));
        }
        return p;
    }

    public static int raisePreprocessError(String err, TStringWithEncoding source, RegexpSupport.ErrorMode mode) throws DeferredRaiseException {
        switch (mode) {
            case RAISE: {
                String message = ClassicRegexp.formatRegexErrorMessage(err, (AbstractTruffleString)source.tstring, "");
                throw new DeferredRaiseException(context -> context.getCoreExceptions().regexpError(message, null));
            }
            case PREPROCESS: {
                throw new DeferredRaiseException(context -> context.getCoreExceptions().argumentError("regexp preprocess failed: " + err, null));
            }
        }
        return 0;
    }

    @SuppressFBWarnings(value={"SF"})
    public static int readEscapedByte(byte[] to, int toP, byte[] bytes, int p, int end, TStringWithEncoding source, RegexpSupport.ErrorMode mode) throws DeferredRaiseException {
        if (p == end || bytes[p++] != 92) {
            ClassicRegexp.raisePreprocessError("too short escaped multibyte character", source, mode);
        }
        boolean metaPrefix = false;
        boolean ctrlPrefix = false;
        int code = 0;
        block15: while (true) {
            if (p == end) {
                ClassicRegexp.raisePreprocessError("too short escape sequence", source, mode);
            }
            switch (bytes[p++]) {
                case 92: {
                    code = 92;
                    break block15;
                }
                case 110: {
                    code = 10;
                    break block15;
                }
                case 116: {
                    code = 9;
                    break block15;
                }
                case 114: {
                    code = 13;
                    break block15;
                }
                case 102: {
                    code = 12;
                    break block15;
                }
                case 118: {
                    code = 11;
                    break block15;
                }
                case 97: {
                    code = 7;
                    break block15;
                }
                case 101: {
                    code = 27;
                    break block15;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int olen = end < --p + 3 ? end - p : 3;
                    code = StringSupport.scanOct(bytes, p, olen);
                    p += StringSupport.octLength(bytes, p, olen);
                    break block15;
                }
                case 120: {
                    int hlen = end < p + 2 ? end - p : 2;
                    code = StringSupport.scanHex(bytes, p, hlen);
                    int len = StringSupport.hexLength(bytes, p, hlen);
                    if (len < 1) {
                        ClassicRegexp.raisePreprocessError("invalid hex escape", source, mode);
                    }
                    p += len;
                    break block15;
                }
                case 77: {
                    if (metaPrefix) {
                        ClassicRegexp.raisePreprocessError("duplicate meta escape", source, mode);
                    }
                    metaPrefix = true;
                    if (p + 1 < end && bytes[p++] == 45 && (bytes[p] & 0x80) == 0) {
                        if (bytes[p] == 92) {
                            ++p;
                            continue block15;
                        }
                        code = bytes[p++] & 0xFF;
                        break block15;
                    }
                    ClassicRegexp.raisePreprocessError("too short meta escape", source, mode);
                }
                case 67: {
                    if (p == end || bytes[p++] != 45) {
                        ClassicRegexp.raisePreprocessError("too short control escape", source, mode);
                    }
                }
                case 99: {
                    if (ctrlPrefix) {
                        ClassicRegexp.raisePreprocessError("duplicate control escape", source, mode);
                    }
                    ctrlPrefix = true;
                    if (p < end && (bytes[p] & 0x80) == 0) {
                        if (bytes[p] == 92) {
                            ++p;
                            continue block15;
                        }
                        code = bytes[p++] & 0xFF;
                        break block15;
                    }
                    ClassicRegexp.raisePreprocessError("too short control escape", source, mode);
                }
                default: {
                    ClassicRegexp.raisePreprocessError("unexpected escape sequence", source, mode);
                }
            }
            break;
        }
        if (code < 0 || code > 255) {
            ClassicRegexp.raisePreprocessError("invalid escape code", source, mode);
        }
        if (ctrlPrefix) {
            code &= 0x1F;
        }
        if (metaPrefix) {
            code |= 0x80;
        }
        to[toP] = (byte)code;
        return p;
    }

    public static void preprocessCheck(TStringWithEncoding tstringWithEncoding) throws DeferredRaiseException {
        ClassicRegexp.preprocess(tstringWithEncoding, tstringWithEncoding.getEncoding(), new RubyEncoding[]{null}, RegexpSupport.ErrorMode.RAISE);
    }

    public static TStringBuilder preprocess(TStringWithEncoding str, RubyEncoding enc, RubyEncoding[] fixedEnc, RegexpSupport.ErrorMode mode) throws DeferredRaiseException {
        TStringBuilder to = TStringBuilder.create(str.byteLength());
        if (enc.isAsciiCompatible) {
            fixedEnc[0] = null;
        } else {
            fixedEnc[0] = enc;
            to.setEncoding(enc);
        }
        boolean hasProperty = ClassicRegexp.unescapeNonAscii(to, str, enc, fixedEnc, mode);
        if (hasProperty && fixedEnc[0] == null) {
            fixedEnc[0] = enc;
        }
        if (fixedEnc[0] != null) {
            to.setEncoding(fixedEnc[0]);
        }
        return to;
    }

    private static void preprocessLight(TStringWithEncoding str, RubyEncoding enc, RubyEncoding[] fixedEnc) throws DeferredRaiseException {
        fixedEnc[0] = enc.isAsciiCompatible ? null : enc;
        boolean hasProperty = ClassicRegexp.unescapeNonAscii(null, str, enc, fixedEnc, RegexpSupport.ErrorMode.PREPROCESS);
        if (hasProperty && fixedEnc[0] == null) {
            fixedEnc[0] = enc;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static TStringWithEncoding preprocessDRegexp(RubyContext context, TStringWithEncoding[] strings, RegexpOptions options) throws DeferredRaiseException {
        assert (strings.length > 0);
        ByteArrayBuilder builder = ByteArrayBuilder.create(strings[0].getInternalByteArray());
        RubyEncoding regexpEnc = ClassicRegexp.processDRegexpElement(context, options, null, strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            TStringWithEncoding str = strings[i];
            regexpEnc = ClassicRegexp.processDRegexpElement(context, options, regexpEnc, str);
            builder.append(str);
        }
        if (options.isEncodingNone()) {
            regexpEnc = !ClassicRegexp.all7Bit(builder.getBytes()) ? Encodings.BINARY : Encodings.US_ASCII;
        }
        if (regexpEnc == null) {
            regexpEnc = strings[0].getEncoding();
        }
        return new TStringWithEncoding(builder.toTString(regexpEnc), regexpEnc);
    }

    @CompilerDirectives.TruffleBoundary
    private static RubyEncoding processDRegexpElement(RubyContext context, RegexpOptions options, RubyEncoding regexpEnc, TStringWithEncoding str) throws DeferredRaiseException {
        RubyEncoding strEnc = str.getEncoding();
        if (options.isEncodingNone() && strEnc != Encodings.BINARY) {
            if (!str.isAsciiOnly()) {
                throw new RaiseException(context, context.getCoreExceptions().regexpError("/.../n has a non escaped non ASCII character in non ASCII-8BIT script", null));
            }
            strEnc = Encodings.BINARY;
        }
        RubyEncoding[] fixedEnc = new RubyEncoding[]{null};
        ClassicRegexp.preprocessLight(str, strEnc, fixedEnc);
        if (fixedEnc[0] != null) {
            if (regexpEnc != null && regexpEnc != fixedEnc[0]) {
                throw new RaiseException(context, context.getCoreExceptions().regexpError("encoding mismatch in dynamic regexp: " + String.valueOf(regexpEnc) + " and " + String.valueOf(fixedEnc[0]), null));
            }
            regexpEnc = fixedEnc[0];
        }
        return regexpEnc;
    }

    private static boolean all7Bit(byte[] bytes) {
        for (int n = 0; n < bytes.length; ++n) {
            if (bytes[n] < 0) {
                return false;
            }
            if (bytes[n] != 92 || n + 1 >= bytes.length || bytes[n + 1] != 120) continue;
            boolean isSecondHex = n + 3 < bytes.length && Character.digit(bytes[n + 3], 16) != -1;
            String num = isSecondHex ? new String(Arrays.copyOfRange(bytes, n + 2, n + 4), StandardCharsets.UTF_8) : new String(Arrays.copyOfRange(bytes, n + 2, n + 3), StandardCharsets.UTF_8);
            int b = Integer.parseInt(num, 16);
            if (b > 127) {
                return false;
            }
            if (isSecondHex) {
                n += 3;
                continue;
            }
            n += 2;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static TStringWithEncoding quote19(ATStringWithEncoding bs) {
        boolean asciiOnly = bs.isAsciiOnly();
        boolean metaFound = false;
        TruffleStringIterator iterator = bs.createCodePointIterator();
        while (iterator.hasNext()) {
            int c = iterator.nextUncached();
            switch (c) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: 
                case 35: 
                case 36: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 63: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: {
                    metaFound = true;
                }
            }
        }
        if (!metaFound) {
            if (asciiOnly) {
                return bs.forceEncoding(Encodings.US_ASCII);
            }
            return bs.asImmutable();
        }
        RubyEncoding resultEncoding = asciiOnly ? Encodings.US_ASCII : bs.encoding;
        TruffleStringBuilder builder = TruffleStringBuilder.create((TruffleString.Encoding)resultEncoding.tencoding, (int)(bs.byteLength() * 2));
        iterator = bs.createCodePointIterator();
        block12: while (iterator.hasNext()) {
            int p = iterator.getByteIndex();
            int c = iterator.nextUncached();
            if (c == -1) {
                int after = iterator.getByteIndex();
                for (int i = p; i < after; ++i) {
                    builder.appendByteUncached(bs.getByte(i));
                }
                continue;
            }
            if (c < 0 || !Encoding.isAscii((int)c)) {
                builder.appendCodePointUncached(c);
                continue;
            }
            switch (c) {
                case 32: 
                case 35: 
                case 36: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 63: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: {
                    builder.appendCodePointUncached(92);
                    builder.appendCodePointUncached(c);
                    continue block12;
                }
                case 9: {
                    builder.appendCodePointUncached(92);
                    builder.appendCodePointUncached(116);
                    continue block12;
                }
                case 10: {
                    builder.appendCodePointUncached(92);
                    builder.appendCodePointUncached(110);
                    continue block12;
                }
                case 13: {
                    builder.appendCodePointUncached(92);
                    builder.appendCodePointUncached(114);
                    continue block12;
                }
                case 12: {
                    builder.appendCodePointUncached(92);
                    builder.appendCodePointUncached(102);
                    continue block12;
                }
                case 11: {
                    builder.appendCodePointUncached(92);
                    builder.appendCodePointUncached(118);
                    continue block12;
                }
            }
            builder.appendCodePointUncached(c);
        }
        return new TStringWithEncoding(builder.toStringUncached(), resultEncoding);
    }

    static RubyEncoding computeRegexpEncoding(RegexpOptions[] options, RubyEncoding enc, RubyEncoding[] fixedEnc) throws DeferredRaiseException {
        if (fixedEnc[0] != null) {
            if (fixedEnc[0] != enc && options[0].isFixed() || fixedEnc[0] != Encodings.BINARY && options[0].isEncodingNone()) {
                throw new DeferredRaiseException(context -> context.getCoreExceptions().regexpError("incompatible character encoding", null));
            }
            if (fixedEnc[0] != Encodings.BINARY) {
                options[0] = options[0].setFixed(true);
                enc = fixedEnc[0];
            }
        } else if (!options[0].isFixed()) {
            enc = Encodings.US_ASCII;
        }
        if (fixedEnc[0] != null) {
            options[0] = options[0].setFixed(true);
        }
        return enc;
    }

    public static void appendOptions(TStringBuilder to, RegexpOptions options) {
        if (options.isMultiline()) {
            to.append((byte)109);
        }
        if (options.isIgnorecase()) {
            to.append((byte)105);
        }
        if (options.isExtended()) {
            to.append((byte)120);
        }
    }

    public static TStringWithEncoding toS(TStringWithEncoding source, RegexpOptions options) {
        RegexpOptions newOptions = (RegexpOptions)options.clone();
        InternalByteArray byteArray = source.getInternalByteArray();
        int p = 0;
        int len = byteArray.getLength();
        TStringBuilder result = TStringBuilder.create(len);
        result.append((byte)40);
        result.append((byte)63);
        while (len >= 4 && byteArray.get(p) == 40 && byteArray.get(p + 1) == 63) {
            p += 2;
            len -= 2;
            do {
                if (byteArray.get(p) == 109) {
                    newOptions = newOptions.setMultiline(true);
                } else if (byteArray.get(p) == 105) {
                    newOptions = newOptions.setIgnorecase(true);
                } else {
                    if (byteArray.get(p) != 120) break;
                    newOptions = newOptions.setExtended(true);
                }
                ++p;
            } while (--len > 0);
            if (len > 1 && byteArray.get(p) == 45) {
                ++p;
                --len;
                do {
                    if (byteArray.get(p) == 109) {
                        newOptions = newOptions.setMultiline(false);
                    } else if (byteArray.get(p) == 105) {
                        newOptions = newOptions.setIgnorecase(false);
                    } else {
                        if (byteArray.get(p) != 120) break;
                        newOptions = newOptions.setExtended(false);
                    }
                    ++p;
                } while (--len > 0);
            }
            if (byteArray.get(p) == 41) {
                --len;
                ++p;
                continue;
            }
            boolean err = true;
            if (byteArray.get(p) == 58 && byteArray.get(p + len - 1) == 41) {
                ++p;
                try {
                    Regex regex = new Regex(byteArray.getArray(), p + byteArray.getOffset(), p + byteArray.getOffset() + (len -= 2), 0, source.encoding.jcoding, Syntax.DEFAULT, (WarnCallback)new RegexWarnCallback());
                    err = false;
                }
                catch (JOniException e) {
                    err = true;
                }
            }
            if (!err) break;
            newOptions = options;
            p = 0;
            len = source.byteLength();
            break;
        }
        ClassicRegexp.appendOptions(result, newOptions);
        if (!newOptions.isEmbeddable()) {
            result.append((byte)45);
            if (!newOptions.isMultiline()) {
                result.append((byte)109);
            }
            if (!newOptions.isIgnorecase()) {
                result.append((byte)105);
            }
            if (!newOptions.isExtended()) {
                result.append((byte)120);
            }
        }
        result.append((byte)58);
        ClassicRegexp.appendRegexpString(result, source, p, len);
        result.append((byte)41);
        result.setEncoding(source.encoding);
        return result.toTStringWithEnc();
    }

    @CompilerDirectives.TruffleBoundary
    public static void appendRegexpString(TStringBuilder to, TStringWithEncoding fullStr, int start, int len) {
        TStringWithEncoding str = fullStr.substring(start, len);
        Encoding enc = str.encoding.jcoding;
        TruffleStringIterator iterator = str.createCodePointIterator();
        boolean needEscape = false;
        while (iterator.hasNext()) {
            int c = iterator.nextUncached();
            if (c < 0 || !Encoding.isAscii((int)c) || c != 47 && enc.isPrint(c)) continue;
            needEscape = true;
            break;
        }
        if (!needEscape) {
            to.append(str);
        } else {
            iterator = str.createCodePointIterator();
            while (iterator.hasNext()) {
                int p = iterator.getByteIndex();
                int c = iterator.nextUncached();
                if (c == 92 && iterator.hasNext()) {
                    iterator.nextUncached();
                    to.append(str, p, iterator.getByteIndex() - p);
                    continue;
                }
                if (c == 47) {
                    to.append((byte)92);
                    to.append(str, p, iterator.getByteIndex() - p);
                    continue;
                }
                if (c < 0 || !Encoding.isAscii((int)c)) {
                    if (c == -1) {
                        to.append(StringUtils.formatASCIIBytes("\\x%02X", c));
                        continue;
                    }
                    to.append(str, p, iterator.getByteIndex() - p);
                    continue;
                }
                if (enc.isPrint(c)) {
                    to.append(str, p, iterator.getByteIndex() - p);
                    continue;
                }
                if (!enc.isSpace(c)) {
                    to.append(StringUtils.formatASCIIBytes("\\x%02X", c));
                    continue;
                }
                to.append(str, p, iterator.getByteIndex() - p);
            }
        }
    }

    public static TStringWithEncoding setRegexpEncoding(TStringWithEncoding value, RegexpOptions options, RubyEncoding lexerEncoding, Node currentNode) throws DeferredRaiseException {
        RubyEncoding optionsEncoding = (options = options.setup()).getEncoding() == null ? null : Encodings.getBuiltInEncoding(options.getEncoding());
        RubyEncoding encoding = value.encoding;
        if (optionsEncoding != null) {
            if (optionsEncoding != encoding && !value.isAsciiOnly()) {
                String message = "regexp encoding option '" + ClassicRegexp.optionsEncodingChar(optionsEncoding.jcoding) + "' differs from source encoding '" + String.valueOf(encoding) + "'";
                throw new DeferredRaiseException(context -> context.getCoreExceptions().syntaxError(message, currentNode, null));
            }
            value = value.forceEncoding(optionsEncoding);
        } else if (options.isEncodingNone()) {
            if (encoding == Encodings.BINARY && !value.isAsciiOnly()) {
                String message = "regexp encoding option ' ' differs from source encoding '" + String.valueOf(encoding) + "'";
                throw new DeferredRaiseException(context -> context.getCoreExceptions().syntaxError(message, currentNode, null));
            }
            value = value.forceEncoding(Encodings.BINARY);
        } else if (lexerEncoding == Encodings.US_ASCII) {
            value = !value.isAsciiOnly() ? value.forceEncoding(Encodings.US_ASCII) : value.forceEncoding(Encodings.BINARY);
        }
        return value;
    }

    private static char optionsEncodingChar(Encoding optionEncoding) {
        if (optionEncoding == USASCIIEncoding.INSTANCE) {
            return 'n';
        }
        if (optionEncoding == EUCJPEncoding.INSTANCE) {
            return 'e';
        }
        if (optionEncoding == SJISEncoding.INSTANCE) {
            return 's';
        }
        if (optionEncoding == UTF8Encoding.INSTANCE) {
            return 'u';
        }
        return ' ';
    }
}

