/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.range;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayBuilderNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.BooleanCastWithDefaultNode;
import org.truffleruby.core.cast.ToIntNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.range.RangeNodesFactory;
import org.truffleruby.core.range.RubyIntOrLongRange;
import org.truffleruby.core.range.RubyIntRange;
import org.truffleruby.core.range.RubyLongRange;
import org.truffleruby.core.range.RubyObjectRange;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="Range", isClass=true)
public abstract class RangeNodes {

    public static abstract class NormalizedStartLengthNode
    extends RubyBaseNode {
        private final BranchProfile overflow = BranchProfile.create();
        private final ConditionProfile notExcluded = ConditionProfile.create();
        private final ConditionProfile negativeBegin = ConditionProfile.create();
        private final ConditionProfile negativeEnd = ConditionProfile.create();

        @NeverDefault
        public static NormalizedStartLengthNode create() {
            return RangeNodesFactory.NormalizedStartLengthNodeGen.create();
        }

        public abstract int[] execute(Object var1, int var2);

        @Specialization
        int[] normalizeIntRange(RubyIntRange range, int size) {
            return this.normalize(range.begin, range.end, range.excludedEnd, size);
        }

        @Specialization
        int[] normalizeLongRange(RubyLongRange range, int size, @Cached @Cached.Exclusive ToIntNode toInt) {
            return this.normalize(toInt.execute(range.begin), toInt.execute(range.end), range.excludedEnd, size);
        }

        @Specialization(guards={"range.isEndless()"})
        int[] normalizeEndlessRange(RubyObjectRange range, int size, @Cached @Cached.Shared ToIntNode toInt) {
            int begin = toInt.execute(range.begin);
            return new int[]{begin >= 0 ? begin : begin + size, size - begin};
        }

        @Specialization(guards={"range.isBounded()"})
        int[] normalizeObjectRange(RubyObjectRange range, int size, @Cached @Cached.Shared ToIntNode toInt) {
            return this.normalize(toInt.execute(range.begin), toInt.execute(range.end), range.excludedEnd, size);
        }

        @Specialization(guards={"range.isBeginless()"})
        int[] normalizeBeginlessRange(RubyObjectRange range, int size, @Cached @Cached.Shared ToIntNode toInt) {
            return this.normalize(0, toInt.execute(range.end), range.excludedEnd, size);
        }

        @Specialization(guards={"range.isBoundless()"})
        int[] normalizeNilNilRange(RubyObjectRange range, int size) {
            return new int[]{0, size};
        }

        private int[] normalize(int begin, int end, boolean excludedEnd, int size) {
            int length;
            if (this.negativeBegin.profile(begin < 0)) {
                begin += size;
            }
            if (this.negativeEnd.profile(end < 0)) {
                end += size;
            }
            try {
                if (this.notExcluded.profile(!excludedEnd)) {
                    end = Math.incrementExact(end);
                }
                length = Math.subtractExact(end, begin);
            }
            catch (ArithmeticException e) {
                this.overflow.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().rangeError("long too big to convert into `int'", (Node)this));
            }
            return new int[]{begin, length};
        }
    }

    @Primitive(name="range_normalized_start_length", lowerFixnum={1})
    public static abstract class NormalizedStartLengthPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        NormalizedStartLengthNode startLengthNode = NormalizedStartLengthNode.create();

        @Specialization
        RubyArray normalize(Object range, int size) {
            return this.createArray(this.startLengthNode.execute(range, size));
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1, raiseIfFrozenSelf=true)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyObjectRange initializeCopy(RubyObjectRange self, RubyIntRange from) {
            self.begin = from.begin;
            self.end = from.end;
            self.excludedEnd = from.excludedEnd;
            return self;
        }

        @Specialization
        RubyObjectRange initializeCopy(RubyObjectRange self, RubyLongRange from) {
            self.begin = from.begin;
            self.end = from.end;
            self.excludedEnd = from.excludedEnd;
            return self;
        }

        @Specialization
        RubyObjectRange initializeCopy(RubyObjectRange self, RubyObjectRange from) {
            self.begin = from.begin;
            self.end = from.end;
            self.excludedEnd = from.excludedEnd;
            return self;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class AllocateNode
    extends RubyBaseNode {
        public abstract RubyObjectRange execute(Node var1, RubyClass var2);

        @Specialization
        static RubyObjectRange allocate(Node node, RubyClass rubyClass) {
            Shape shape = AllocateNode.getLanguage((Node)node).objectRangeShape;
            RubyObjectRange range = new RubyObjectRange(rubyClass, shape, false, nil, nil, false);
            AllocationTracing.trace(range, node);
            return range;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class RangeAllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyObjectRange allocate(RubyClass rubyClass, @Cached AllocateNode allocateNode) {
            return allocateNode.execute(this, rubyClass);
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class NewRangeNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, RubyClass var2, Object var3, Object var4, boolean var5);

        @Specialization(guards={"rubyClass == getRangeClass()"})
        static RubyIntRange intRange(RubyClass rubyClass, int begin, int end, boolean excludeEnd) {
            return new RubyIntRange(excludeEnd, begin, end);
        }

        @Specialization(guards={"rubyClass == getRangeClass()", "fitsInInteger(begin)", "fitsInInteger(end)"})
        static RubyIntRange longFittingIntRange(RubyClass rubyClass, long begin, long end, boolean excludeEnd) {
            return new RubyIntRange(excludeEnd, (int)begin, (int)end);
        }

        @Specialization(guards={"rubyClass == getRangeClass()", "!fitsInInteger(begin) || !fitsInInteger(end)"})
        static RubyLongRange longRange(RubyClass rubyClass, long begin, long end, boolean excludeEnd) {
            return new RubyLongRange(excludeEnd, begin, end);
        }

        @Specialization(guards={"!standardClass || (!isImplicitLong(begin) || !isImplicitLong(end))"})
        static RubyObjectRange objectRange(Node node, RubyClass rubyClass, Object begin, Object end, boolean excludeEnd, @Cached(inline=false) DispatchNode compare, @Bind(value="rubyClass == getRangeClass()") boolean standardClass) {
            if (compare.call(begin, "<=>", end) == nil && end != nil && begin != nil) {
                throw new RaiseException(NewRangeNode.getContext(node), NewRangeNode.coreExceptions(node).argumentError("bad value for range", node));
            }
            Shape shape = NewRangeNode.getLanguage((Node)node).objectRangeShape;
            RubyObjectRange range = new RubyObjectRange(rubyClass, shape, excludeEnd, begin, end, standardClass);
            AllocationTracing.trace(range, node);
            return range;
        }

        protected RubyClass getRangeClass() {
            return this.coreLibrary().rangeClass;
        }
    }

    @NodeChildren(value={@NodeChild(value="beginNode", type=RubyNode.class), @NodeChild(value="endNode", type=RubyNode.class)})
    @NodeField(name="excludeEnd", type=Boolean.class)
    public static abstract class RangeLiteralNode
    extends RubyContextSourceNode {
        abstract RubyNode getBeginNode();

        abstract RubyNode getEndNode();

        abstract boolean getExcludeEnd();

        @Specialization
        Object doRange(Object begin, Object end, @Cached NewRangeNode newRangeNode) {
            return newRangeNode.execute(this, this.coreLibrary().rangeClass, begin, end, this.getExcludeEnd());
        }

        @Override
        public RubyNode cloneUninitialized() {
            return RangeNodesFactory.RangeLiteralNodeGen.create(this.getBeginNode().cloneUninitialized(), this.getEndNode().cloneUninitialized(), this.getExcludeEnd()).copyFlags(this);
        }
    }

    @CoreMethod(names={"new"}, constructor=true, required=2, optional=1)
    public static abstract class NewNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object newRange(RubyClass rubyClass, Object begin, Object end, Object maybeExcludeEnd, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached NewRangeNode newRangeNode) {
            boolean excludeEnd = booleanCastWithDefaultNode.execute(this, maybeExcludeEnd, false);
            return newRangeNode.execute(this, rubyClass, begin, end, excludeEnd);
        }
    }

    @Primitive(name="range_initialize")
    public static abstract class InitializeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyObjectRange initialize(RubyObjectRange range, Object begin, Object end, boolean excludeEnd) {
            range.excludedEnd = excludeEnd;
            range.begin = begin;
            range.end = end;
            return range;
        }
    }

    @CoreMethod(names={"to_a"})
    public static abstract class ToANode
    extends CoreMethodArrayArgumentsNode {
        private final BranchProfile overflow = BranchProfile.create();
        private final ConditionProfile emptyProfile = ConditionProfile.create();
        @Node.Child
        private DispatchNode toAInternalCall;

        @Specialization
        RubyArray toA(RubyIntRange range) {
            int begin;
            int result = range.excludedEnd ? range.end : range.end + 1;
            int length = result - (begin = range.begin);
            if (this.emptyProfile.profile(length < 0)) {
                return this.createEmptyArray();
            }
            int[] values = new int[length];
            for (int n = 0; n < length; ++n) {
                values[n] = begin + n;
            }
            return this.createArray(values);
        }

        @Specialization
        RubyArray toA(RubyLongRange range) {
            int length;
            long begin = range.begin;
            long result = range.excludedEnd ? range.end : range.end + 1L;
            try {
                length = Math.toIntExact(result - begin);
            }
            catch (ArithmeticException e) {
                this.overflow.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().rangeError("long too big to convert into `int'", (Node)this));
            }
            if (this.emptyProfile.profile(length < 0)) {
                return this.createEmptyArray();
            }
            long[] values = new long[length];
            for (int n = 0; n < length; ++n) {
                values[n] = begin + (long)n;
            }
            return this.createArray(values);
        }

        @Specialization(guards={"range.isBounded()"})
        Object boundedToA(RubyObjectRange range) {
            if (this.toAInternalCall == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toAInternalCall = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.toAInternalCall.call(range, "to_a_internal");
        }

        @Specialization(guards={"range.isEndless() || range.isBoundless()"})
        Object endlessToA(RubyObjectRange range) {
            throw new RaiseException(this.getContext(), this.coreExceptions().rangeError("cannot convert endless range to an array", (Node)this));
        }

        @Specialization(guards={"range.isBeginless()"})
        Object beginlessToA(RubyObjectRange range) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("can't iterate from NilClass", this));
        }
    }

    @CoreMethod(names={"step"}, needsBlock=true, optional=1, lowerFixnum={1})
    public static abstract class StepNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DispatchNode stepInternalCall;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"step > 0"})
        Object stepInt(RubyIntRange range, int step, RubyProc block, @Cached LoopConditionProfile loopProfile, @Cached @Cached.Shared CallBlockNode yieldNode) {
            int result = range.excludedEnd ? range.end : range.end + 1;
            int n = range.begin;
            try {
                while (loopProfile.inject(n < result)) {
                    yieldNode.yield(this, block, n);
                    n += step;
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, n - range.begin);
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"step > 0"})
        Object stepLong(RubyLongRange range, int step, RubyProc block, @Cached @Cached.Shared CallBlockNode yieldNode) {
            long n;
            long result = range.excludedEnd ? range.end : range.end + 1L;
            try {
                for (n = range.begin; n < result; n += (long)step) {
                    yieldNode.yield(this, block, n);
                }
            }
            finally {
                this.reportLongLoopCount(n - range.begin);
            }
            return range;
        }

        @Fallback
        Object stepFallback(VirtualFrame frame, Object range, Object step, Object block) {
            if (this.stepInternalCall == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stepInternalCall = (DispatchNode)this.insert(DispatchNode.create());
            }
            if (RubyGuards.wasNotProvided(step)) {
                step = 1;
            }
            Object blockArgument = RubyArguments.getBlock((Frame)frame);
            return this.stepInternalCall.callWithBlock(range, "step_internal", blockArgument, step);
        }
    }

    @CoreMethod(names={"end"})
    public static abstract class EndNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int lastInt(RubyIntRange range) {
            return range.end;
        }

        @Specialization
        long lastLong(RubyLongRange range) {
            return range.end;
        }

        @Specialization
        Object lastObject(RubyObjectRange range) {
            return range.end;
        }
    }

    @CoreMethod(names={"begin"})
    public static abstract class BeginNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int eachInt(RubyIntRange range) {
            return range.begin;
        }

        @Specialization
        long eachLong(RubyLongRange range) {
            return range.begin;
        }

        @Specialization
        Object eachObject(RubyObjectRange range) {
            return range.begin;
        }
    }

    @CoreMethod(names={"exclude_end?"})
    public static abstract class ExcludeEndNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean excludeEnd(RubyObjectRange range) {
            return range.excludedEnd;
        }

        @Specialization
        boolean excludeEnd(RubyIntOrLongRange range) {
            return range.excludedEnd;
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true, enumeratorSize="size")
    public static abstract class EachNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DispatchNode eachInternalCall;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        RubyIntRange eachInt(RubyIntRange range, RubyProc block, @Cached @Cached.Shared InlinedConditionProfile excludedEndProfile, @Cached @Cached.Exclusive InlinedLoopConditionProfile loopProfile, @Cached @Cached.Shared CallBlockNode yieldNode) {
            int exclusiveEnd = excludedEndProfile.profile((Node)this, range.excludedEnd) ? range.end : range.end + 1;
            int n = range.begin;
            try {
                while (loopProfile.inject((Node)this, n < exclusiveEnd)) {
                    yieldNode.yield(this, block, n);
                    ++n;
                }
            }
            finally {
                EachNode.profileAndReportLoopCount((Node)this, loopProfile, n - range.begin);
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        RubyLongRange eachLong(RubyLongRange range, RubyProc block, @Cached @Cached.Shared InlinedConditionProfile excludedEndProfile, @Cached @Cached.Exclusive InlinedLoopConditionProfile loopProfile, @Cached @Cached.Shared CallBlockNode yieldNode) {
            long exclusiveEnd = excludedEndProfile.profile((Node)this, range.excludedEnd) ? range.end : range.end + 1L;
            long n = range.begin;
            try {
                while (loopProfile.inject((Node)this, n < exclusiveEnd)) {
                    yieldNode.yield(this, block, n);
                    ++n;
                }
            }
            finally {
                EachNode.profileAndReportLoopCount((Node)this, loopProfile, n - range.begin);
            }
            return range;
        }

        @Specialization
        Object eachObject(RubyObjectRange range, RubyProc block) {
            if (this.eachInternalCall == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.eachInternalCall = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.eachInternalCall.callWithBlock(range, "each_internal", block);
        }
    }

    @Primitive(name="range_integer_map")
    public static abstract class IntegerMapNode
    extends PrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        RubyArray map(RubyIntRange range, RubyProc block, @Cached ArrayBuilderNode arrayBuilder, @Cached CallBlockNode yieldNode, @Cached InlinedConditionProfile noopProfile, @Cached InlinedLoopConditionProfile loopProfile) {
            int begin = range.begin;
            int end = range.end;
            boolean excludedEnd = range.excludedEnd;
            int exclusiveEnd = excludedEnd ? end : end + 1;
            if (noopProfile.profile((Node)this, begin >= exclusiveEnd)) {
                return this.createEmptyArray();
            }
            int length = exclusiveEnd - begin;
            ArrayBuilderNode.BuilderState state = arrayBuilder.start(length);
            int n = 0;
            try {
                while (loopProfile.inject((Node)this, n < length)) {
                    arrayBuilder.appendValue(state, n, yieldNode.yield(this, block, begin + n));
                    ++n;
                }
            }
            finally {
                IntegerMapNode.profileAndReportLoopCount((Node)this, loopProfile, n);
            }
            return this.createArray(arrayBuilder.finish(state, length), length);
        }

        @Fallback
        Object mapFallback(Object range, Object block) {
            return FAILURE;
        }
    }
}

