/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.queue;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.cast.BooleanCastWithDefaultNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.queue.RubySizedQueue;
import org.truffleruby.core.queue.SizedQueue;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.shared.PropagateSharingNode;

@CoreModule(value="SizedQueue", isClass=true)
public abstract class SizedQueueNodes {

    @CoreMethod(names={"close"})
    public static abstract class CloseNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySizedQueue close(RubySizedQueue self) {
            self.queue.close();
            return self;
        }
    }

    @CoreMethod(names={"num_waiting"})
    public static abstract class NumWaitingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int num_waiting(RubySizedQueue self) {
            SizedQueue queue = self.queue;
            return queue.getNumberWaiting();
        }
    }

    @CoreMethod(names={"clear"})
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySizedQueue clear(RubySizedQueue self) {
            SizedQueue queue = self.queue;
            queue.clear();
            return self;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int size(RubySizedQueue self) {
            SizedQueue queue = self.queue;
            return queue.size();
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean empty(RubySizedQueue self) {
            SizedQueue queue = self.queue;
            return queue.isEmpty();
        }
    }

    @Primitive(name="sized_queue_pop")
    public static abstract class PopNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"!nonBlocking"})
        Object popBlocking(RubySizedQueue self, boolean nonBlocking, Nil timeoutMilliseconds) {
            SizedQueue queue = self.queue;
            Object value = this.doPop(queue);
            if (value == SizedQueue.CLOSED) {
                return nil;
            }
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        private Object doPop(SizedQueue queue) {
            return this.getContext().getThreadManager().runUntilResult(this, queue::take);
        }

        @Specialization(guards={"!nonBlocking"})
        Object popBlocking(RubySizedQueue self, boolean nonBlocking, long timeoutMilliseconds) {
            SizedQueue queue = self.queue;
            long deadline = System.currentTimeMillis() + timeoutMilliseconds;
            return this.getContext().getThreadManager().runUntilResult(this, () -> {
                long currentTimeout = deadline - System.currentTimeMillis();
                Object value = currentTimeout > 0L ? queue.poll(currentTimeout) : queue.poll();
                if (value == SizedQueue.CLOSED || value == null) {
                    return nil;
                }
                return value;
            });
        }

        @Specialization(guards={"nonBlocking"})
        Object popNonBlock(RubySizedQueue self, boolean nonBlocking, Nil timeoutMilliseconds, @Cached InlinedBranchProfile errorProfile) {
            SizedQueue queue = self.queue;
            Object value = queue.poll();
            if (value == null) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().threadError("queue empty", this));
            }
            return value;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PushNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, RubySizedQueue var2, Object var3, boolean var4, Object var5);

        @Specialization(guards={"!nonBlocking"})
        static RubySizedQueue pushBlocking(Node node, RubySizedQueue self, Object value, boolean nonBlocking, Nil timeoutMilliseconds, @Cached @Cached.Shared PropagateSharingNode propagateSharingNode) {
            SizedQueue queue = self.queue;
            propagateSharingNode.execute(node, self, value);
            PushNode.doPushBlocking(node, value, queue);
            return self;
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPushBlocking(Node node, Object value, SizedQueue queue) {
            PushNode.getContext(node).getThreadManager().runUntilResult(node, () -> {
                if (queue.put(value)) {
                    return true;
                }
                throw new RaiseException(PushNode.getContext(node), PushNode.coreExceptions(node).closedQueueError(node));
            });
        }

        @Specialization(guards={"!nonBlocking"})
        static Object pushTimeout(Node node, RubySizedQueue self, Object value, boolean nonBlocking, long timeoutMilliseconds, @Cached @Cached.Shared PropagateSharingNode propagateSharingNode) {
            SizedQueue queue = self.queue;
            propagateSharingNode.execute(node, self, value);
            long deadline = System.currentTimeMillis() + timeoutMilliseconds;
            boolean success = PushNode.getContext(node).getThreadManager().runUntilResult(node, () -> {
                long currentTimeout = deadline - System.currentTimeMillis();
                Object result = currentTimeout > 0L ? queue.put(value, currentTimeout) : queue.put(value, 0L);
                if (result == SizedQueue.CLOSED) {
                    throw new RaiseException(PushNode.getContext(node), PushNode.coreExceptions(node).closedQueueError(node));
                }
                return (boolean)((Boolean)result);
            });
            if (success) {
                return self;
            }
            return nil;
        }

        @Specialization(guards={"nonBlocking"})
        static RubySizedQueue pushNonBlock(Node node, RubySizedQueue self, Object value, boolean nonBlocking, Nil timeoutMilliseconds, @Cached @Cached.Shared PropagateSharingNode propagateSharingNode, @Cached InlinedBranchProfile errorProfile) {
            SizedQueue queue = self.queue;
            propagateSharingNode.execute(node, self, value);
            switch (queue.offer(value)) {
                case SUCCESS: {
                    return self;
                }
                case FULL: {
                    errorProfile.enter(node);
                    throw new RaiseException(PushNode.getContext(node), PushNode.coreExceptions(node).threadErrorQueueFull(node));
                }
                case CLOSED: {
                    errorProfile.enter(node);
                    throw new RaiseException(PushNode.getContext(node), PushNode.coreExceptions(node).closedQueueError(node));
                }
            }
            return self;
        }
    }

    @Primitive(name="sized_queue_push")
    public static abstract class SizedQueuePushNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object doPush(RubySizedQueue self, Object value, Object maybeNonBlocking, Object timeoutMilliseconds, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached PushNode pushNode) {
            boolean nonBlocking = booleanCastWithDefaultNode.execute(this, maybeNonBlocking, false);
            return pushNode.execute(this, self, value, nonBlocking, timeoutMilliseconds);
        }
    }

    @CoreMethod(names={"max"})
    public static abstract class MaxNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int max(RubySizedQueue self) {
            SizedQueue queue = self.queue;
            return queue.getCapacity();
        }
    }

    @CoreMethod(names={"max="}, required=1, lowerFixnum={1})
    public static abstract class SetMaxNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int setMax(RubySizedQueue self, int newCapacity, @Cached InlinedBranchProfile errorProfile) {
            if (newCapacity <= 0) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("queue size must be positive", this));
            }
            SizedQueue queue = self.queue;
            queue.changeCapacity(newCapacity);
            return newCapacity;
        }
    }

    @CoreMethod(names={"initialize"}, visibility=Visibility.PRIVATE, required=1, lowerFixnum={1})
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySizedQueue initialize(RubySizedQueue self, int capacity, @Cached InlinedBranchProfile errorProfile) {
            SizedQueue blockingQueue;
            if (capacity <= 0) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("queue size must be positive", this));
            }
            self.queue = blockingQueue = new SizedQueue(capacity);
            return self;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySizedQueue allocate(RubyClass rubyClass) {
            RubySizedQueue instance = new RubySizedQueue(rubyClass, this.getLanguage().sizedQueueShape, null);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

