/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.queue;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.cast.ToANode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.queue.RubyQueue;
import org.truffleruby.core.queue.RubySizedQueue;
import org.truffleruby.core.queue.UnsizedQueue;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.shared.PropagateSharingNode;

@CoreModule(value="Queue", isClass=true)
public abstract class QueueNodes {

    @CoreMethod(names={"closed?"})
    public static abstract class ClosedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean closed(RubyQueue self) {
            return self.queue.isClosed();
        }

        @Specialization
        boolean closed(RubySizedQueue self) {
            return self.queue.isClosed();
        }
    }

    @CoreMethod(names={"close"})
    public static abstract class CloseNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyQueue close(RubyQueue self) {
            self.queue.close();
            return self;
        }
    }

    @CoreMethod(names={"num_waiting"})
    public static abstract class NumWaitingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int num_waiting(RubyQueue self) {
            UnsizedQueue queue = self.queue;
            return queue.getNumberWaitingToTake();
        }
    }

    @CoreMethod(names={"marshal_dump"})
    public static abstract class MarshalDumpNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object marshal_dump(RubyQueue self) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorCantDump(self, this));
        }
    }

    @CoreMethod(names={"initialize"}, visibility=Visibility.PRIVATE, optional=1)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyQueue initialize(RubyQueue self, NotProvided enumerable) {
            return self;
        }

        @Specialization(guards={"wasProvided(enumerable)"})
        RubyQueue initialize(RubyQueue self, Object enumerable, @CachedLibrary(limit="storageStrategyLimit()") ArrayStoreLibrary stores, @Cached ToANode toANode) {
            RubyArray rubyArray = toANode.executeToA(enumerable);
            Object[] array = stores.boxedCopyOfRange(rubyArray.getStore(), 0, rubyArray.size);
            self.queue.addAll(array);
            return self;
        }
    }

    @CoreMethod(names={"clear"})
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyQueue clear(RubyQueue self) {
            UnsizedQueue queue = self.queue;
            queue.clear();
            return self;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int size(RubyQueue self) {
            UnsizedQueue queue = self.queue;
            return queue.size();
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean empty(RubyQueue self) {
            UnsizedQueue queue = self.queue;
            return queue.isEmpty();
        }
    }

    @Primitive(name="queue_pop")
    public static abstract class PopNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"!nonBlocking"})
        Object popBlocking(RubyQueue self, boolean nonBlocking, Nil timeoutMilliseconds, @Cached @Cached.Exclusive InlinedBranchProfile closedProfile) {
            UnsizedQueue queue = self.queue;
            Object value = this.doPop(queue);
            if (value == UnsizedQueue.CLOSED) {
                closedProfile.enter((Node)this);
                return nil;
            }
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        private Object doPop(UnsizedQueue queue) {
            return this.getContext().getThreadManager().runUntilResult(this, queue::take);
        }

        @Specialization(guards={"!nonBlocking"})
        Object popBlocking(RubyQueue self, boolean nonBlocking, long timeoutMilliseconds) {
            UnsizedQueue queue = self.queue;
            long deadline = System.currentTimeMillis() + timeoutMilliseconds;
            return this.getContext().getThreadManager().runUntilResult(this, () -> {
                long currentTimeout = deadline - System.currentTimeMillis();
                Object value = currentTimeout > 0L ? queue.poll(currentTimeout) : queue.poll();
                if (value == UnsizedQueue.CLOSED || value == null) {
                    return nil;
                }
                return value;
            });
        }

        @Specialization(guards={"nonBlocking"})
        Object popNonBlock(RubyQueue self, boolean nonBlocking, Nil timeoutMilliseconds, @Cached @Cached.Exclusive InlinedBranchProfile errorProfile) {
            UnsizedQueue queue = self.queue;
            Object value = queue.poll();
            if (value == null) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().threadError("queue empty", this));
            }
            return value;
        }
    }

    @CoreMethod(names={"push", "<<", "enq"}, required=1)
    public static abstract class PushNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyQueue push(RubyQueue self, Object value, @Cached PropagateSharingNode propagateSharingNode) {
            UnsizedQueue queue = self.queue;
            propagateSharingNode.execute(this, self, value);
            if (queue.add(value)) {
                return self;
            }
            throw new RaiseException(this.getContext(), this.coreExceptions().closedQueueError(this));
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyQueue allocate(RubyClass rubyClass) {
            RubyQueue instance = new RubyQueue(rubyClass, this.getLanguage().queueShape, new UnsizedQueue());
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

