/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.proc;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.ProcCallTargets;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.interop.ForeignToRubyArgumentsNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.control.FrameOnStackMarker;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.parser.ArgumentDescriptor;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyProc
extends RubyDynamicObject
implements ObjectGraphNode {
    public final RootCallTarget callTarget;
    public final MaterializedFrame declarationFrame;
    public final InternalMethod declaringMethod;
    public final FrameOnStackMarker frameOnStackMarker;
    public final DeclarationContext declarationContext;
    public final ProcType type;
    public final ProcCallTargets callTargets;
    public final Arity arity;
    public final ArgumentDescriptor[] argumentDescriptors;
    public final SpecialVariableStorage declarationVariables;

    public RubyProc(RubyClass rubyClass, Shape shape, ProcType type, Arity arity, ArgumentDescriptor[] argumentDescriptors, ProcCallTargets callTargets, RootCallTarget callTarget, MaterializedFrame declarationFrame, SpecialVariableStorage declarationVariables, InternalMethod declaringMethod, FrameOnStackMarker frameOnStackMarker, DeclarationContext declarationContext) {
        super(rubyClass, shape);
        this.type = type;
        this.arity = arity;
        this.argumentDescriptors = argumentDescriptors;
        this.callTargets = callTargets;
        this.callTarget = callTarget;
        this.declarationFrame = declarationFrame;
        this.declarationVariables = declarationVariables;
        this.declaringMethod = declaringMethod;
        this.frameOnStackMarker = frameOnStackMarker;
        this.declarationContext = declarationContext;
    }

    public RubyProc withArity(Arity newArity, ArgumentDescriptor[] newArgumentDescriptors, RubyClass newRubyClass, Shape newShape) {
        return new RubyProc(newRubyClass, newShape, this.type, newArity, newArgumentDescriptors, this.callTargets, this.callTarget, this.declarationFrame, this.declarationVariables, this.declaringMethod, this.frameOnStackMarker, this.declarationContext);
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        ObjectGraph.getObjectsInFrame((Frame)this.declarationFrame, reachable);
        ObjectGraph.addProperty(reachable, this.declaringMethod);
    }

    public boolean isLambda() {
        return this.type == ProcType.LAMBDA;
    }

    public boolean isProc() {
        return this.type == ProcType.PROC;
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return RubyRootNode.of(this.callTarget).getSharedMethodInfo();
    }

    public int getArityNumber() {
        return this.arity.getProcArityNumber(this.type);
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argumentDescriptors == null ? this.arity.toUnnamedArgumentDescriptors() : this.argumentDescriptors;
    }

    @ExportMessage
    public boolean hasSourceLocation() {
        return true;
    }

    @ExportMessage
    public SourceSection getSourceLocation() {
        return this.getSharedMethodInfo().getSourceSection();
    }

    @ExportMessage
    public boolean isExecutable() {
        return true;
    }

    @ExportMessage
    public Object execute(Object[] arguments, @Cached CallBlockNode yieldNode, @Cached ForeignToRubyArgumentsNode foreignToRubyArgumentsNode, @Bind(value="$node") Node node) {
        return yieldNode.yield(node, this, foreignToRubyArgumentsNode.executeConvert(node, arguments));
    }
}

