/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.objectspace;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.Layouts;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.DataObjectFinalizerReference;
import org.truffleruby.core.FinalizerReference;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.objectspace.ObjectSpaceManager;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.ImmutableRubyObject;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.InternalRespondToNode;
import org.truffleruby.language.objects.IsANode;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectIDOperations;
import org.truffleruby.language.objects.shared.WriteBarrierNode;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="ObjectSpace")
public abstract class ObjectSpaceNodes {

    @CoreMethod(names={"undefine_finalizer"}, isModuleFunction=true, required=1)
    public static abstract class UndefineFinalizerNode
    extends CoreMethodArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object undefineFinalizer(RubyDynamicObject object) {
            DynamicObjectLibrary objectLibrary = DynamicObjectLibrary.getUncached();
            RubyDynamicObject rubyDynamicObject = object;
            synchronized (rubyDynamicObject) {
                FinalizerReference newRef;
                FinalizerReference ref = (FinalizerReference)objectLibrary.getOrDefault((DynamicObject)object, (Object)Layouts.FINALIZER_REF_IDENTIFIER, null);
                if (ref != null && ref != (newRef = this.getContext().getFinalizationService().removeFinalizers((Object)object, ref, ObjectSpaceManager.class))) {
                    objectLibrary.put((DynamicObject)object, (Object)Layouts.FINALIZER_REF_IDENTIFIER, (Object)newRef);
                }
            }
            return object;
        }
    }

    @Primitive(name="objectspace_define_data_finalizer")
    public static abstract class DefineDataObjectFinalizerNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object defineFinalizer(RubyDynamicObject object, Object finalizerCFunction, Object dataStruct, @CachedLibrary(limit="1") DynamicObjectLibrary objectLibrary) {
            DataObjectFinalizerReference newRef = this.getContext().getDataObjectFinalizationService().addFinalizer(this.getContext(), (Object)object, finalizerCFunction, dataStruct);
            objectLibrary.put((DynamicObject)object, (Object)Layouts.DATA_OBJECT_FINALIZER_REF_IDENTIFIER, (Object)newRef);
            return nil;
        }
    }

    @CoreMethod(names={"define_finalizer"}, isModuleFunction=true, required=2)
    public static abstract class DefineFinalizerNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private InternalRespondToNode respondToCallNode = InternalRespondToNode.create();

        @Specialization
        RubyArray defineFinalizer(VirtualFrame frame, RubyDynamicObject object, Object finalizer, @Cached BranchProfile errorProfile, @Cached WriteBarrierNode writeBarrierNode) {
            if (this.respondToCallNode.execute((Frame)frame, finalizer, "call")) {
                if (!this.getContext().getReferenceProcessor().processOnMainThread()) {
                    if (!this.getContext().getSharedObjects().isSharing()) {
                        this.startSharing();
                    }
                    writeBarrierNode.execute(this, finalizer);
                }
                this.defineFinalizer(object, finalizer);
                return this.createArray(new Object[]{0, finalizer});
            }
            errorProfile.enter();
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorWrongArgumentType(finalizer, "callable", this));
        }

        @CompilerDirectives.TruffleBoundary
        private void startSharing() {
            this.getContext().getSharedObjects().startSharing(this.getLanguage(), "creating finalizer");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void defineFinalizer(RubyDynamicObject object, Object finalizer) {
            RubyDynamicObject root = finalizer instanceof RubyDynamicObject ? (RubyDynamicObject)((Object)finalizer) : null;
            CallableFinalizer action = new CallableFinalizer(finalizer);
            DynamicObjectLibrary objectLibrary = DynamicObjectLibrary.getUncached();
            RubyDynamicObject rubyDynamicObject = object;
            synchronized (rubyDynamicObject) {
                FinalizerReference ref = (FinalizerReference)objectLibrary.getOrDefault((DynamicObject)object, (Object)Layouts.FINALIZER_REF_IDENTIFIER, null);
                if (ref == null) {
                    FinalizerReference newRef = this.getContext().getFinalizationService().addFinalizer(this.getContext(), (Object)object, ObjectSpaceManager.class, action, root);
                    objectLibrary.put((DynamicObject)object, (Object)Layouts.FINALIZER_REF_IDENTIFIER, (Object)newRef);
                } else {
                    this.getContext().getFinalizationService().addAdditionalFinalizer(this.getContext(), ref, (Object)object, ObjectSpaceManager.class, action, root);
                }
            }
        }
    }

    private static final class CallableFinalizer
    implements Runnable {
        private final Object callable;

        public CallableFinalizer(Object callable) {
            this.callable = callable;
        }

        @Override
        public void run() {
            DispatchNode.getUncached().call(this.callable, "call");
        }

        public String toString() {
            return this.callable.toString();
        }
    }

    @CoreMethod(names={"each_object"}, isModuleFunction=true, needsBlock=true, optional=1, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachObjectNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int eachObject(NotProvided ofClass, RubyProc block, @Cached @Cached.Shared CallBlockNode yieldNode) {
            int count = 0;
            for (Object object : ObjectGraph.stopAndGetAllObjects("ObjectSpace.each_object", this.getContext(), this)) {
                if (!this.include(object)) continue;
                yieldNode.yield(this, block, object);
                ++count;
            }
            return count;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        int eachObject(RubyModule ofClass, RubyProc block, @Cached IsANode isANode, @Cached @Cached.Shared CallBlockNode yieldNode) {
            int count = 0;
            String reason = "ObjectSpace.each_object(" + String.valueOf(ofClass) + ")";
            for (Object object : ObjectGraph.stopAndGetAllObjects(reason, this.getContext(), this)) {
                if (!this.include(object) || !isANode.executeIsA(object, ofClass)) continue;
                yieldNode.yield(this, block, object);
                ++count;
            }
            return count;
        }

        private boolean include(Object object) {
            if (object instanceof RubySymbol) {
                return true;
            }
            if (object instanceof RubyDynamicObject) {
                if (object instanceof RubyClass) {
                    return !RubyGuards.isSingletonClass(object);
                }
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"_id2ref"}, isModuleFunction=true, required=1)
    @ImportStatic(value={ObjectIDOperations.class})
    public static abstract class ID2RefNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"id == NIL"})
        Object id2RefNil(long id) {
            return nil;
        }

        @Specialization(guards={"id == TRUE"})
        boolean id2RefTrue(long id) {
            return true;
        }

        @Specialization(guards={"id == FALSE"})
        boolean id2RefFalse(long id) {
            return false;
        }

        @Specialization(guards={"isSmallFixnumID(id)"})
        long id2RefSmallInt(long id) {
            return ObjectIDOperations.toFixnum(id);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isBasicObjectID(id)"})
        Object id2Ref(long id) {
            DynamicObjectLibrary objectLibrary = DynamicObjectLibrary.getUncached();
            for (Object object : ObjectGraph.stopAndGetAllObjects("ObjectSpace._id2ref", this.getContext(), this)) {
                assert (ObjectGraph.isRubyObject(object));
                long objectID = 0L;
                if (object instanceof RubyDynamicObject) {
                    objectID = ObjectSpaceManager.readObjectID((RubyDynamicObject)((Object)object), objectLibrary);
                } else if (object instanceof ImmutableRubyObject) {
                    objectID = ((ImmutableRubyObject)object).getObjectId();
                }
                if (objectID != id) continue;
                return object;
            }
            throw new RaiseException(this.getContext(), this.coreExceptions().rangeError(StringUtils.format("0x%016x is not id value", id), (Node)this));
        }

        @Specialization(guards={"isLargeFixnumID(id)"})
        Object id2RefLargeFixnum(RubyBignum id) {
            return BigIntegerOps.longValue(id);
        }

        @Specialization(guards={"isFloatID(id)"})
        double id2RefFloat(RubyBignum id) {
            return Double.longBitsToDouble(BigIntegerOps.longValue(id));
        }

        protected boolean isLargeFixnumID(RubyBignum id) {
            return ObjectIDOperations.isLargeFixnumID(id.value);
        }

        protected boolean isFloatID(RubyBignum id) {
            return ObjectIDOperations.isFloatID(id.value);
        }
    }
}

